C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MAMASS,SSI=0
C
                     SUBROUTINE MAMASS
C                    ******************
C
C     ------------------------------------------------------
     *( XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *  NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *  NPOUE,NPPEL,NBPHYS,
     *  WCT )
C     ------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DES MATRICES ELEMENTAIRES DE MASSE         *
C                    PROBLEMES BIDIMENSIONNELS ET TRIDIMENSIONNEL      *
C                                                                      *
C                                                                      *
C      Ce sous programme constitue une extension de travaux effectuees *
C      par F. JAUBERTEAU et J.P. GREGOIRE, portant sur l'integration   *
C      analytique des matrices elementaires par les formules de        *
C      Zienkiewicz                                                     *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   XMAT    !  TR  ! R  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   COEFMA  !  TR  ! D  ! COEFFICIENTS DES MATRICES                !
C   !           !      !    !  coefma(n) = rho Cp / dt pour masse      !
C   !   PHYSOL  !  TR  ! D  ! Tableau contenant les propri physiques   !
C   !           !  TR  ! D  !   On utilise uniquement PHYSOL(n,>=3)    !
C   !           !      !    !   contient les valeurs des kii sui isotro!
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                ! 
C   !   W1...W10!  TR  ! M  ! TABLEAUX DE TRAVAIL (TAILLE: NELMXS )    !
C   !           !      !    ! (diagonale non assemblee)                !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ASSEMB,OV
C                                      
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : MATELE
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C    
C***********************************************************************
C
C..Variables externes
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NCOEMA
      INTEGER NPOUE,NPPEL,NBPHYS
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM) 
      DOUBLE PRECISION COEFMA(NPOINS),XMAT(NELEMS,NCOEMA)      
      DOUBLE PRECISION WCT(NELEMS,NDMATS),VOLUME(NELEMS)    
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
C
C..Variables internes
      DOUBLE PRECISION ZERO     
      INTEGER I,NCA
      INTEGER N1,N2,N3,N4,N5,N6,N7,N8,N9,N10      
      DOUBLE PRECISION S240,SV240,S960,SV960,S1440,SV1440
      DOUBLE PRECISION R1,R2,R3
      DOUBLE PRECISION RC1,RC2,RC3,RC4,RC5,RC6,RC7,RC8,RC9,RC10
      DOUBLE PRECISION RINDTS,RIN960,RCE
C    
      LOGICAL LVERIF
C***********************************************************************
C
C     INITIALISATIONS
C     ================
C
      LVERIF = .FALSE.
      ZERO   = 0.D0
      RINDTS = 1.D0 / RDTTS
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
      S240 = 1.D0 / 240.D0
      S960 = 1.D0 / 960.D0
      S1440 = 1.D0 / 1440.D0     
C     
C     1- CAS BIDIMENSIONNEL
C     ======================
C        
      IF ( NDIM . EQ . 2 ) THEN
C       
C       1.1 CAS BIDIMENSIONNEL CARTESIEN
C       --------------------------------
C
        IF  (IAXISY.EQ.0) THEN    
C
C  
         DO 110 I=1,NELEMS
C
	  IF (NDPROP .EQ. 1) THEN
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
C
           RC1 = COEFMA(N1) 
           RC2 = COEFMA(N2) 
           RC3 = COEFMA(N3) 
           RC4 = COEFMA(N4) 
           RC5 = COEFMA(N5) 
           RC6 = COEFMA(N6) 
          ELSEIF( NDPROP .EQ. 2) THEN
           RCE = PHYSOL(I,1,1)*PHYSOL(I,1,2)*RINDTS
           RC1 = RCE
           RC2 = RCE
           RC3 = RCE
           RC4 = RCE
           RC5 = RCE
           RC6 = RCE
          ELSE
           RC1 = PHYSOL(I,1,1)*PHYSOL(I,1,2)*RINDTS
           RC2 = PHYSOL(I,2,1)*PHYSOL(I,2,2)*RINDTS  
           RC3 = PHYSOL(I,3,1)*PHYSOL(I,3,2)*RINDTS 
           RC4 = PHYSOL(I,4,1)*PHYSOL(I,4,2)*RINDTS 
           RC5 = PHYSOL(I,5,1)*PHYSOL(I,5,2)*RINDTS 
           RC6 = PHYSOL(I,6,1)*PHYSOL(I,6,2)*RINDTS 
          ENDIF
C
C          Calcul des termes diagonaux (mass-lumpe)
C          ----------------------------------------
C          
           SV240 = S240 * VOLUME(I)           
C
C
           WCT(I,1) =  SV240 * ( 10*RC1 + 5*(RC4+RC6) )
           WCT(I,2) =  SV240 * ( 5*(RC4+RC5) + 10*RC2 )
           WCT(I,3) =  SV240 * ( 5*(RC5+RC6) + 10*RC3 )
           WCT(I,4) =  SV240 * ( 5*(RC1+RC2) + 30*RC4 + 10*(RC5+RC6) )
           WCT(I,5) =  SV240 * ( 5*(RC2+RC3) + 30*RC5 + 10*(RC4+RC6) )
           WCT(I,6) =  SV240 * ( 5*(RC1+RC3) + 30*RC6 + 10*(RC4+RC5) )        
C
  110    CONTINUE      
C
C
C       1.2- CAS AXISYMETRIQUE (DONC 2D)
C       --------------------------------  
        ELSE       
C      
         DO 120 I=1,NELEMS
C
          N1 = NODES(I,1)
          N2 = NODES(I,2)
          N3 = NODES(I,3)
C
	  IF (NDPROP .EQ. 1) THEN
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)        
C
           RC1 = COEFMA(N1) 
           RC2 = COEFMA(N2) 
           RC3 = COEFMA(N3) 
           RC4 = COEFMA(N4) 
           RC5 = COEFMA(N5) 
           RC6 = COEFMA(N6) 
          ELSEIF( NDPROP .EQ. 2) THEN
           RCE = PHYSOL(I,1,1)*PHYSOL(I,1,2)*RINDTS
           RC1 = RCE
           RC2 = RCE
           RC3 = RCE
           RC4 = RCE
           RC5 = RCE
           RC6 = RCE
          ELSE
           RC1 = PHYSOL(I,1,1)*PHYSOL(I,1,2)*RINDTS
           RC2 = PHYSOL(I,2,1)*PHYSOL(I,2,2)*RINDTS  
           RC3 = PHYSOL(I,3,1)*PHYSOL(I,3,2)*RINDTS 
           RC4 = PHYSOL(I,4,1)*PHYSOL(I,4,2)*RINDTS 
           RC5 = PHYSOL(I,5,1)*PHYSOL(I,5,2)*RINDTS 
           RC6 = PHYSOL(I,6,1)*PHYSOL(I,6,2)*RINDTS 
          ENDIF
C
C          Calcul des termes diagonaux (mass-lumpe)
C          ---------------------------------------           
           SV1440 = S1440 * VOLUME(I)
C
C          l'axe Y est pris comme coordonne radiale
C          l'axe X est pris comme axe de rotation
           R1 = ABS(COORDS(N1,NCA)) * SV1440
           R2 = ABS(COORDS(N2,NCA)) * SV1440
           R3 = ABS(COORDS(N3,NCA)) * SV1440 
C
C
           WCT(I,1) = RC1 * ( 48*R1 + 6*(R2+R3) ) +
     &                RC4 * ( 21*R1 + 6*R2 + 3*R3 ) +
     &                RC6 * ( 21*R1 + 3*R2 + 6*R3 )
           WCT(I,2) = RC2 * ( 48*R2 + 6*(R1+R3) ) +
     &                RC4 * ( 21*R2 + 6*R1 + 3*R3 ) +
     &                RC5 * ( 21*R2 + 3*R1 + 6*R3 )
           WCT(I,3) = RC3 * ( 48*R3 + 6*(R1+R2) ) +
     &                RC5 * ( 21*R3 + 6*R2 + 3*R1 ) +
     &                RC6 * ( 21*R3 + 3*R2 + 6*R1 )
           WCT(I,4) = RC1 * ( 21*R1 + 6*R2 + 3*R3 ) +
     &                RC2 * ( 6*R1 + 21*R2 + 3*R3 ) +
     &                RC4 * ( 78*(R1+R2) + 24*R3 ) +
     &                RC5 * ( 15*(R1+R3) + 30*R2 ) +
     &                RC6 * ( 15*(R2+R3) + 30*R1 )
           WCT(I,5) = RC2 * ( 21*R2 + 6*R3 + 3*R1 ) +
     &                RC3 * ( 6*R2 + 21*R3 + 3*R1 ) +
     &                RC5 * ( 78*(R2+R3) + 24*R1 ) +
     &                RC4 * ( 15*(R1+R3) + 30*R2 ) +
     &                RC6 * ( 15*(R1+R2) + 30*R3 )
           WCT(I,6) = RC1 * ( 21*R1 + 6*R3 + 3*R2 ) +
     &                RC3 * ( 6*R1 + 21*R3 + 3*R2 ) +
     &                RC6 * ( 78*(R1+R3) + 24*R2 ) +
     &                RC4 * ( 15*(R2+R3) + 30*R1 ) +
     &                RC5 * ( 15*(R1+R2) + 30*R3 )
C
  120    CONTINUE
C
        ENDIF
C
C
C
C
C     2- CAS TRIDIMENSIONNEL
C     ======================
      ELSE
C     
         DO 210 I=1,NELEMS        
C
           SV960 = S960 * VOLUME(I)  
C
	  IF (NDPROP .EQ. 1) THEN
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
           N7 = NODES(I,7)
           N8 = NODES(I,8)
           N9 = NODES(I,9)
           N10 = NODES(I,10)
C
           RC1 = SV960 * COEFMA(N1)
           RC2 = SV960 * COEFMA(N2)
           RC3 = SV960 * COEFMA(N3)
           RC4 = SV960 * COEFMA(N4)
           RC5 = SV960 * COEFMA(N5)
           RC6 = SV960 * COEFMA(N6)
           RC7 = SV960 * COEFMA(N7)
           RC8 = SV960 * COEFMA(N8)
           RC9 = SV960 * COEFMA(N9)
           RC10 = SV960 * COEFMA(N10)
          ELSEIF( NDPROP .EQ. 2) THEN
           RCE = SV960 * PHYSOL(I,1,1)*PHYSOL(I,1,2)*RINDTS
           RC1 = RCE
           RC2 = RCE
           RC3 = RCE
           RC4 = RCE
           RC5 = RCE
           RC6 = RCE
           RC7 = RCE
           RC8 = RCE
           RC9 = RCE
           RC10 = RCE
          ELSE
           RIN960 = RINDTS*SV960
           RC1 = PHYSOL(I,1,1)*PHYSOL(I,1,2)*RIN960
           RC2 = PHYSOL(I,2,1)*PHYSOL(I,2,2)*RIN960
           RC3 = PHYSOL(I,3,1)*PHYSOL(I,3,2)*RIN960
           RC4 = PHYSOL(I,4,1)*PHYSOL(I,4,2)*RIN960
           RC5 = PHYSOL(I,5,1)*PHYSOL(I,5,2)*RIN960
           RC6 = PHYSOL(I,6,1)*PHYSOL(I,6,2)*RIN960
           RC7 = PHYSOL(I,7,1)*PHYSOL(I,7,2)*RIN960
           RC8 = PHYSOL(I,8,1)*PHYSOL(I,8,2)*RIN960
           RC9 = PHYSOL(I,9,1)*PHYSOL(I,9,2)*RIN960
           RC10= PHYSOL(I,10,1)*PHYSOL(I,10,2)*RIN960
          ENDIF
C                                                                       
C
           WCT(I,1) = 12*RC1+6*(RC5+RC7+RC8)
           WCT(I,2) = 12*RC2+6*(RC5+RC6+RC9)
           WCT(I,3) = 12*RC3+6*(RC6+RC7+RC10)
           WCT(I,4) = 12*RC4+6*(RC8+RC9+RC10)
           WCT(I,5) = 6*(RC1+RC2)+12*(RC7+RC9)+18*(RC6+RC8)+48*RC5
           WCT(I,6) = 6*(RC2+RC3)+18*(RC5+RC7+RC9+RC10)+24*RC8+72*RC6
           WCT(I,7) = 6*(RC1+RC3)+12*(RC5+RC10)+18*(RC6+RC8)+48*RC7
           WCT(I,8) = 6*(RC1+RC4)+18*(RC5+RC7+RC9+RC10)+24*RC6+72*RC8
           WCT(I,9) = 6*(RC2+RC4)+12*(RC5+RC10)+18*(RC6+RC8)+48*RC9
           WCT(I,10) = 6*(RC3+RC4)+12*(RC7+RC9)+18*(RC6+RC8)+48*RC10
C
C
  210    CONTINUE
C           
C
C     Fin du cas 3D                  
      ENDIF                 
C
C-------
C FORMAT
C-------
C
C
      END

