/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mp3.hh"
#include <id3tag.h>
#include <iostream>

void TagMp3::extract_fields(struct id3_tag const *tag, bool const ignore_standards_fields) {
	if (tag == NULL)
		return;

	for (unsigned int i = 0; i < tag->nframes; i++) {
		struct id3_frame const *frame;
		frame = tag->frames[i];

		union id3_field const *field;
		field = id3_frame_field(frame, 1);
		if (field != NULL) {
			int nstrings = id3_field_getnstrings(field);
			for (int j = 0; j < nstrings; ++j) {
				id3_ucs4_t const *ucs4;
				id3_utf8_t *utf8;

				id3_field_getstrings(field, j);
				ucs4 = id3_field_getstrings(field, j);
				utf8 = id3_ucs4_utf8duplicate(ucs4);

				if (std::string(frame->id) == "TXXX")
					add_vector((char*) utf8, false);
				else if (!ignore_standards_fields)
					add_vector((char*) frame->id, (char*) utf8, ignore_standards_fields);
			}
		}
	}
}

bool TagMp3::extract_from_file(std::string const path, bool const ignore_standards_fields) {
	Tag::extract_from_file(path);

	struct id3_file *file;
	file = id3_file_open(path.c_str(), ID3_FILE_MODE_READONLY);
	if (file != NULL) {
		extract_fields(id3_file_tag(file), ignore_standards_fields);
		id3_file_close(file);
		return true;
	}
	return false;
}
