/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */



#include <sstream>
#include <iostream>
#include "basic.hh"
#include "global.hh"



void string_split(const std::string str, const char separator, void (*callback)(std::string str, void *params), void *params) {
	std::string buf("");
	int size = str.size();
	char c;
	
	for (int i = 0; i < size; i++) {
		if ((c = str[i]) == separator) {
			callback(buf, params);
			buf = "";
		}
		else
			buf += c;
	}
	callback(buf, params);
}

void string_split(const std::string str, const char separator, std::list<std::string>* result) {
	std::string buf("");
	int size = str.size();
	char c;
	result->clear();
	for (int i = 0; i < size; i++) {
		if ((c = str[i]) == separator) {
			result->push_back(buf);
			buf = "";
		}
		else
			buf += c;
	}
	result->push_back(buf);
}

std::string int2string(const int& number) {
	std::ostringstream oss;
	oss << number;
	return oss.str();
}

void color(int c) {
	printf("\033[%dm", c);
}

bool print_result(bool b) {
	color((b) ? 32 : 31);
	std::cout << ((b) ? _("DONE") : _("ERROR")) << std::endl;
	color(0);
	return b;
}

void print_action(std::string action) {
	std::cout << action << "...";
	fflush(stdout);
}

void print_error(std::string msg) {
	color(31);
	std::cout << "ERROR: ";
	color(0);
	std::cout << msg << std::endl;
}

