/*
 * Decompiled with CFR 0.152.
 */
package ari.ucidy;

import ari.ucidy.UCDParser;
import ari.ucidy.UCDWord;
import ari.ucidy.UCDWordList;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;

public class DeprecatedUCDWordList
extends UCDWordList {
    protected final UCDWordList nonDeprecatedWords;

    public DeprecatedUCDWordList(UCDWordList nonDeprecatedWords) throws NullPointerException {
        this(nonDeprecatedWords, null);
    }

    public DeprecatedUCDWordList(UCDWordList nonDeprecatedWords, String version) throws NullPointerException {
        super(version == null || version.trim().isEmpty() ? nonDeprecatedWords.getVersion() : version);
        if (nonDeprecatedWords == null) {
            throw new NullPointerException("Missing list of all non deprecated UCD words!");
        }
        this.nonDeprecatedWords = nonDeprecatedWords;
    }

    public final boolean isForSameVersion() {
        return Objects.equals(this.getVersion(), this.nonDeprecatedWords.getVersion());
    }

    @Override
    public boolean add(UCDWord newWord) {
        if (newWord == null || !newWord.isDeprecated() || !newWord.valid || newWord.recognised || !newWord.suggestedReplacement.isAllRecognised()) {
            return false;
        }
        return this.words.add(newWord);
    }

    @Override
    public int addAll(Reader reader, boolean recommended) throws NullPointerException, IOException {
        return UCDParser.parseDeprecatedWordList(reader, this.nonDeprecatedWords, this);
    }
}

