/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DBType;
import adql.db.exception.UnresolvedJoinException;
import java.util.ArrayList;
import java.util.Iterator;

public class DBCommonColumn
implements DBColumn {
    protected DBColumn generalColumnDesc;
    protected ArrayList<DBTable> lstCoveredTables = new ArrayList();

    public DBCommonColumn(DBColumn leftCol, DBColumn rightCol) throws UnresolvedJoinException {
        Iterator<DBTable> it;
        if (leftCol.getDatatype() != null && rightCol.getDatatype() != null && !leftCol.getDatatype().isCompatible(rightCol.getDatatype())) {
            throw new UnresolvedJoinException("JOIN impossible: incompatible column types when trying to join the columns " + leftCol.getADQLName() + " (" + leftCol.getDatatype() + ") and " + rightCol.getADQLName() + " (" + rightCol.getDatatype() + ")!");
        }
        if (leftCol instanceof DBCommonColumn) {
            this.generalColumnDesc = ((DBCommonColumn)leftCol).generalColumnDesc;
            it = ((DBCommonColumn)leftCol).getCoveredTables();
            while (it.hasNext()) {
                this.addCoveredTable(it.next());
            }
        } else {
            this.generalColumnDesc = leftCol.copy(leftCol.getDBName(), leftCol.getADQLName(), null);
            this.addCoveredTable(leftCol.getTable());
        }
        if (rightCol instanceof DBCommonColumn) {
            it = ((DBCommonColumn)rightCol).getCoveredTables();
            while (it.hasNext()) {
                this.addCoveredTable(it.next());
            }
        } else {
            this.addCoveredTable(rightCol.getTable());
        }
    }

    public DBCommonColumn(DBCommonColumn toCopy, String dbName, String adqlName) {
        this.generalColumnDesc = toCopy.generalColumnDesc.copy(dbName, adqlName, null);
        this.lstCoveredTables = (ArrayList)toCopy.lstCoveredTables.clone();
    }

    @Override
    public final String getADQLName() {
        return this.generalColumnDesc.getADQLName();
    }

    @Override
    public final boolean isCaseSensitive() {
        return this.generalColumnDesc.isCaseSensitive();
    }

    @Override
    public final String getDBName() {
        return this.generalColumnDesc.getDBName();
    }

    @Override
    public final DBType getDatatype() {
        return this.generalColumnDesc.getDatatype();
    }

    @Override
    public final DBTable getTable() {
        return null;
    }

    public final Iterator<DBTable> getCoveredTables() {
        return this.lstCoveredTables.iterator();
    }

    protected void addCoveredTable(DBTable table) {
        if (table != null) {
            this.lstCoveredTables.add(table);
        }
    }

    @Override
    public DBColumn copy(String dbName, String adqlName, DBTable dbTable) {
        return this.generalColumnDesc.copy(dbName, adqlName, dbTable);
    }
}

