8.2 コード(和音)

# コード(和音)

Sonic Piは和音名のリストを返す機能を内蔵しています。実際に試してみましょう。

```
play chord(:E3, :minor)
```

さあ、本当に動きましたね。そのままのリストよりも美しく見えますねそして人間にとっても読みやすいでしょう。では、どんな和音をSonic Pi はサポートをしているのでしょうか。沢山あります。下記のように、いくつかのコードを試してみましょう。

* `chord(:E3, :m7)`
* `chord(:E3, :minor)`
* `chord(:E3, :dim7)`
* `chord(:E3, :dom7)`

## アルペジオ

`play_pattern`関数で簡単にコード（和音）からアルベジオ(和音を構成する音を一音ずつ順番に弾いていく奏法)に変更して演奏を行うことができます。

```
play_pattern chord(:E3, :m7)
```

でも、それはとてもゆっくりと演奏をしているので、あまり楽しくないかもしれません。`play_pattern`は、区切られたリスト内の各音符を再生する度に`sleep 1` を呼び出して演奏します。`play_pattern_timed`関数を使用することで独自のタイミングと速度を指定することがきます。

```
play_pattern_timed chord(:E3, :m7), 0.25
```

時間のリスト化は、時間周期として取り扱うことができるでしょう。

```
play_pattern_timed chord(:E3, :m13), [0.25, 0.5]
```

これは下記と同等です。

```
play 52
sleep 0.25
play 55
sleep 0.5
play 59
sleep 0.25
play 62
sleep 0.5
play 66
sleep 0.25
play 69
sleep 0.5
play 73
```

どちらの書き方を好みますか？
