/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.sikuli.script.Location;

public class Flag
extends Component {
    Location location;
    String text;
    public static final int DIRECTION_EAST = 1;
    public static final int DIRECTION_WEST = 2;
    public static final int DIRECTION_SOUTH = 3;
    public static final int DIRECTION_NORTH = 4;
    int direction = 1;
    Font font;
    int text_height;
    int text_width;
    int xspacing = 5;
    int yspacing = 5;
    int d = 10;

    public Flag(Location location, String string) {
        this.location = location;
        this.text = string;
        this.font = new Font("sansserif", 1, 16);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.text_width = fontMetrics.stringWidth(this.text);
        this.text_height = fontMetrics.getHeight();
        this.text_width += this.xspacing * 2;
        this.text_height += this.yspacing * 2;
        this.setDirection(1);
    }

    public void setDirection(int n) {
        this.direction = n;
        if (n == 1) {
            this.setBounds(-3 + this.location.x - this.d - this.text_width, this.location.y - this.text_height / 2, this.text_width + this.d + 10, this.text_height + 10);
        } else if (n == 2) {
            this.setBounds(-3 + this.location.x, this.location.y - this.text_height / 2, this.text_width + this.d + 10, this.text_height + 10);
        } else if (n == 3) {
            this.setBounds(-3 + this.location.x - this.text_width / 2, this.location.y - this.text_height - this.d, this.text_width + this.d + 10, this.text_height + this.d + 10);
        } else if (n == 4) {
            this.setBounds(-3 + this.location.x - this.text_width / 2, this.location.y, this.text_width + this.d + 10, this.text_height + this.d + 10);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(3, 0);
        graphics2D.setFont(this.font);
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Location location = null;
        if (this.direction == 1) {
            location = new Location(0, this.text_height);
        } else if (this.direction == 2) {
            location = new Location(this.d, this.text_height);
        } else if (this.direction == 3) {
            location = new Location(0, this.text_height);
        } else if (this.direction == 4) {
            location = new Location(0, this.d + this.text_height);
        }
        GeneralPath generalPath = new GeneralPath();
        if (this.direction == 2 || this.direction == 1) {
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(this.text_width, 0.0f);
            generalPath.lineTo(this.text_width + this.d, this.text_height / 2);
            generalPath.lineTo(this.text_width, this.text_height);
            generalPath.lineTo(0.0f, this.text_height);
            generalPath.closePath();
        } else {
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(this.text_width, 0.0f);
            generalPath.lineTo(this.text_width, this.text_height);
            generalPath.lineTo(this.text_width / 2 + 8, this.text_height);
            generalPath.lineTo(this.text_width / 2, this.text_height + this.d);
            generalPath.lineTo(this.text_width / 2 - 8, this.text_height);
            generalPath.lineTo(0.0f, this.text_height);
            generalPath.closePath();
        }
        graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (this.direction == 2) {
            object = new AffineTransform();
            ((AffineTransform)object).setToTranslation(this.text_width + this.d, this.text_height);
            ((AffineTransform)object).rotate(Math.PI);
            generalPath.transform((AffineTransform)object);
        } else if (this.direction == 4) {
            object = new AffineTransform();
            ((AffineTransform)object).setToTranslation(this.text_width, this.text_height + this.d);
            ((AffineTransform)object).rotate(Math.PI);
            generalPath.transform((AffineTransform)object);
        }
        graphics2D.translate(4, 4);
        graphics2D.setColor(new Color(0.3f, 0.3f, 0.3f));
        graphics2D.fill(generalPath);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.translate(-2, -2);
        object = new BasicStroke(3.0f);
        graphics2D.setStroke((Stroke)object);
        graphics2D.setColor(Color.black);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.white);
        graphics2D.drawString(this.text, location.x + this.xspacing, location.y - this.yspacing * 2);
    }
}

