<!--
SPDX-FileCopyrightText: Heiko Schaefer <heiko@schaefer.name>
SPDX-License-Identifier: MIT OR Apache-2.0
-->

# rpgpie 🦀️🔐🥧

A higher-level [OpenPGP](https://openpgp.dev/book/) API based on [rPGP](https://github.com/rpgp/rpgp/).

rpgpie is an experimental wrapping API on top of the rPGP library.

Main goals of rpgpie include simplicity, collaboration and fun 🥳.

## Objectives of rpgpie

More concretely, rpgpie currently has the following objectives:

- Expose an API to implement [stateless OpenPGP (SOP)](https://datatracker.ietf.org/doc/draft-dkg-openpgp-stateless-cli/) functionality (see [rsop](https://crates.io/crates/rsop)).
- Experiment with applying the terminology and conceptual framing of the ["OpenPGP for application developers"](https://openpgp.dev/) documentation.
- Experiment with high level API design for OpenPGP.
- Add a basic policy to rPGP (e.g. to limit accepted algorithms).

## Limitations and non-objectives

rpgpie does not currently process messages in an efficient, streaming manner. Messages that are too large to be conveniently processed in RAM can currently not be handled with rpgpie.

The rpgpie API currently limits itself to using certificates (also known as "OpenPGP public keys") and TSKs (also known as "OpenPGP secret/private keys") as they are.
Updating or altering certificates or TSKs is currently out of scope.

For the current phase of exploration, proper error handling is not a goal of rpgpie. The code may panic in all kinds of circumstances.

API stability is not a goal in the current phase of development.

## Technical Details

Rpgpie implements some higher-order OpenPGP facilities:

- **Certificate-level**:

    - A policy on cryptographic primitives (to reject use of weak algorithms).
    - Asserting [validity](https://openpgp.dev/book/verification.html) of individual OpenPGP signature packets.
    - Evaluating stacks of OpenPGP signatures (which make statements about the same component) over time.
    - OpenPGP semantics guarantees on the certificate level (evaluating self-signature graphs).

- **Message-level**:

    - Generate/validate data signatures,
    - Encrypt/decrypt data.
    - Apply a policy for acceptable cryptographic mechanisms.

## Warning, early-stage project!

The code in this project is NOT currently intended for production use.
