% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.r
\docType{methods}
\name{coerce-git_commit-method}
\alias{coerce-git_commit-method}
\alias{coerce,git_commit,data.frame-method}
\title{Coerce a commit to a \code{data.frame}}
\arguments{
\item{from}{The commit \code{object}}
}
\value{
\code{data.frame}
}
\description{
The commit is coerced to a \code{data.frame}
}
\details{
The \code{data.frame} have the following columns:
\describe{

\item{sha}{
    The 40 character hexadecimal string of the SHA-1
  }

\item{summary}{
    the short "summary" of the git commit message.
  }

\item{message}{
    the full message of a commit
  }

\item{author}{
    full name of the author
  }

\item{email}{
    email of the author
  }

\item{when}{
    time when the commit happened
  }

}
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file and commit
writeLines("Example file",  file.path(path, "example.txt"))
add(repo, "example.txt")
c1 <- commit(repo, "Commit message")

## Coerce the commit to a data.frame
df <- as(c1, "data.frame")
df
}
}
\keyword{methods}
