#include "musicplayer.h"
#include "config.h"

#include <QFile>
#include <QFlags>
#include <QQmlContext>
#include <QQuickView>
#include <QQmlEngine>
#include <QStandardPaths>

MusicPlayer::MusicPlayer (int& argc, char** argv) : QApplication (argc, argv), pView (nullptr)
{
    setOrganizationName ("music.ubports");
    setApplicationName ("music.ubports");
}

MusicPlayer::~MusicPlayer ()
{
    if (this->pView)
    {
        delete this->pView;
    }
}

bool MusicPlayer::setup ()
{
    this->pView = new QQuickView ();
    this->pView->setColor (Qt::black);
    this->pView->setResizeMode (QQuickView::SizeRootObjectToView);
    this->pView->setTitle (tr ("Music Player"));
    this->pView->rootContext ()->setContextProperty ("mApplication", this);

    this->getXdgMusicDir ();

    QUrl sSource (musicPlayerDirectory () + "/app/music-app.qml");
    this->pView->setSource (sSource);
    this->pView->show ();

    return true;
}

void MusicPlayer::getXdgMusicDir ()
{
    QStringList musicLocations = QStandardPaths::standardLocations (QStandardPaths::MusicLocation);

    QString musicDir = !musicLocations.isEmpty ()
        ? musicLocations.at(0)
        : "/home/phablet/Music";

    this->pView->engine ()->rootContext ()->setContextProperty ("XDG_MUSIC_DIR", musicDir);
}
