-- https://www.unicode.org/Public/math/revision-15/MathClass-15.txt
module Typst.MathClass
 ( MathClass(..),
   mathClassOf )
where
import qualified Data.Map as M
import Data.Maybe (fromMaybe)

data MathClass =
    Normal
  | Opening
  | Closing
  | Fence
  | Vary
  | Punctuation
  | Binary
  | Unary
  | Relation
  | Alphabetic
  | Diacritic
  | Large
  | GlyphPart
  | Space
  | Special
  deriving (Show, Eq, Ord, Bounded)

mathClassOf :: Char -> MathClass
mathClassOf c = fromMaybe Normal $ M.lookup c mathClassMap

mathClassMap :: M.Map Char MathClass
mathClassMap = M.fromList [
    ('\x20', Space),
    ('\x21', Normal),
    ('\x23', Normal),
    ('\x24', Normal),
    ('\x25', Normal),
    ('\x26', Normal),
    ('\x28', Opening),
    ('\x29', Closing),
    ('\x2a', Normal),
    ('\x2b', Vary),
    ('\x2c', Punctuation),
    ('\x2d', Normal),
    ('\x2e', Punctuation),
    ('\x2f', Binary),
    ('\x30', Normal),
    ('\x31', Normal),
    ('\x32', Normal),
    ('\x33', Normal),
    ('\x34', Normal),
    ('\x35', Normal),
    ('\x36', Normal),
    ('\x37', Normal),
    ('\x38', Normal),
    ('\x39', Normal),
    ('\x3a', Punctuation),
    ('\x3b', Punctuation),
    ('\x3c', Relation),
    ('\x3d', Relation),
    ('\x3e', Relation),
    ('\x3f', Punctuation),
    ('\x40', Normal),
    ('\x41', Alphabetic),
    ('\x42', Alphabetic),
    ('\x43', Alphabetic),
    ('\x44', Alphabetic),
    ('\x45', Alphabetic),
    ('\x46', Alphabetic),
    ('\x47', Alphabetic),
    ('\x48', Alphabetic),
    ('\x49', Alphabetic),
    ('\x4a', Alphabetic),
    ('\x4b', Alphabetic),
    ('\x4c', Alphabetic),
    ('\x4d', Alphabetic),
    ('\x4e', Alphabetic),
    ('\x4f', Alphabetic),
    ('\x50', Alphabetic),
    ('\x51', Alphabetic),
    ('\x52', Alphabetic),
    ('\x53', Alphabetic),
    ('\x54', Alphabetic),
    ('\x55', Alphabetic),
    ('\x56', Alphabetic),
    ('\x57', Alphabetic),
    ('\x58', Alphabetic),
    ('\x59', Alphabetic),
    ('\x5a', Alphabetic),
    ('\x5b', Opening),
    ('\x5c', Binary),
    ('\x5d', Closing),
    ('\x5e', Normal),
    ('\x5f', Normal),
    ('\x60', Diacritic),
    ('\x61', Alphabetic),
    ('\x62', Alphabetic),
    ('\x63', Alphabetic),
    ('\x64', Alphabetic),
    ('\x65', Alphabetic),
    ('\x66', Alphabetic),
    ('\x67', Alphabetic),
    ('\x68', Alphabetic),
    ('\x69', Alphabetic),
    ('\x6a', Alphabetic),
    ('\x6b', Alphabetic),
    ('\x6c', Alphabetic),
    ('\x6d', Alphabetic),
    ('\x6e', Alphabetic),
    ('\x6f', Alphabetic),
    ('\x70', Alphabetic),
    ('\x71', Alphabetic),
    ('\x72', Alphabetic),
    ('\x73', Alphabetic),
    ('\x74', Alphabetic),
    ('\x75', Alphabetic),
    ('\x76', Alphabetic),
    ('\x77', Alphabetic),
    ('\x78', Alphabetic),
    ('\x79', Alphabetic),
    ('\x7a', Alphabetic),
    ('\x7b', Opening),
    ('\x7c', Fence),
    ('\x7d', Closing),
    ('\x7e', Normal),
    ('\xa0', Space),
    ('\xa1', Punctuation),
    ('\xa2', Normal),
    ('\xa3', Normal),
    ('\xa4', Normal),
    ('\xa5', Normal),
    ('\xa6', Normal),
    ('\xa7', Normal),
    ('\xa8', Diacritic),
    ('\xac', Unary),
    ('\xaf', Diacritic),
    ('\xb0', Normal),
    ('\xb1', Vary),
    ('\xb2', Normal),
    ('\xb3', Normal),
    ('\xb4', Normal),
    ('\xb5', Normal),
    ('\xb6', Normal),
    ('\xb7', Binary),
    ('\xb9', Normal),
    ('\xbc', Normal),
    ('\xbd', Normal),
    ('\xbe', Normal),
    ('\xbf', Punctuation),
    ('\xd7', Binary),
    ('\xf7', Binary),
    ('\x131', Alphabetic),
    ('\x237', Alphabetic),
    ('\x2c6', Diacritic),
    ('\x2c7', Diacritic),
    ('\x2d8', Diacritic),
    ('\x2d9', Diacritic),
    ('\x2da', Diacritic),
    ('\x2dc', Diacritic),
    ('\x300', Diacritic),
    ('\x301', Diacritic),
    ('\x302', Diacritic),
    ('\x303', Diacritic),
    ('\x304', Diacritic),
    ('\x305', Diacritic),
    ('\x306', Diacritic),
    ('\x307', Diacritic),
    ('\x308', Diacritic),
    ('\x30a', Diacritic),
    ('\x30c', Diacritic),
    ('\x311', Diacritic),
    ('\x323', Diacritic),
    ('\x32c', Diacritic),
    ('\x32d', Diacritic),
    ('\x32e', Diacritic),
    ('\x32f', Diacritic),
    ('\x330', Diacritic),
    ('\x331', Diacritic),
    ('\x332', Diacritic),
    ('\x333', Diacritic),
    ('\x338', Diacritic),
    ('\x33a', Diacritic),
    ('\x33f', Diacritic),
    ('\x346', Diacritic),
    ('\x391', Alphabetic),
    ('\x392', Alphabetic),
    ('\x393', Alphabetic),
    ('\x394', Alphabetic),
    ('\x395', Alphabetic),
    ('\x396', Alphabetic),
    ('\x397', Alphabetic),
    ('\x398', Alphabetic),
    ('\x399', Alphabetic),
    ('\x39a', Alphabetic),
    ('\x39b', Alphabetic),
    ('\x39c', Alphabetic),
    ('\x39d', Alphabetic),
    ('\x39e', Alphabetic),
    ('\x39f', Alphabetic),
    ('\x3a0', Alphabetic),
    ('\x3a1', Alphabetic),
    ('\x3a3', Alphabetic),
    ('\x3a4', Alphabetic),
    ('\x3a6', Alphabetic),
    ('\x3a7', Alphabetic),
    ('\x3a8', Alphabetic),
    ('\x3a9', Alphabetic),
    ('\x3b1', Alphabetic),
    ('\x3b2', Alphabetic),
    ('\x3b3', Alphabetic),
    ('\x3b4', Alphabetic),
    ('\x3b5', Alphabetic),
    ('\x3b6', Alphabetic),
    ('\x3b7', Alphabetic),
    ('\x3b8', Alphabetic),
    ('\x3b9', Alphabetic),
    ('\x3ba', Alphabetic),
    ('\x3bb', Alphabetic),
    ('\x3bc', Alphabetic),
    ('\x3bd', Alphabetic),
    ('\x3be', Alphabetic),
    ('\x3bf', Alphabetic),
    ('\x3c0', Alphabetic),
    ('\x3c1', Alphabetic),
    ('\x3c3', Alphabetic),
    ('\x3c4', Alphabetic),
    ('\x3c5', Alphabetic),
    ('\x3c6', Alphabetic),
    ('\x3c7', Alphabetic),
    ('\x3c8', Alphabetic),
    ('\x3c9', Alphabetic),
    ('\x3d0', Alphabetic),
    ('\x3d1', Alphabetic),
    ('\x3d2', Alphabetic),
    ('\x3d5', Alphabetic),
    ('\x3d6', Alphabetic),
    ('\x3d8', Normal),
    ('\x3d9', Normal),
    ('\x3da', Alphabetic),
    ('\x3db', Alphabetic),
    ('\x3dc', Alphabetic),
    ('\x3dd', Alphabetic),
    ('\x3e0', Alphabetic),
    ('\x3e1', Alphabetic),
    ('\x3f0', Alphabetic),
    ('\x3f1', Alphabetic),
    ('\x3f4', Alphabetic),
    ('\x3f5', Alphabetic),
    ('\x3f6', Normal),
    ('\x428', Alphabetic),
    ('\x606', Large),
    ('\x607', Large),
    ('\x608', Alphabetic),
    ('\x2000', Space),
    ('\x2001', Space),
    ('\x2002', Space),
    ('\x2003', Space),
    ('\x2004', Space),
    ('\x2005', Space),
    ('\x2006', Space),
    ('\x2007', Space),
    ('\x2009', Space),
    ('\x200a', Space),
    ('\x200b', Space),
    ('\x2010', Punctuation),
    ('\x2012', Punctuation),
    ('\x2013', Punctuation),
    ('\x2014', Punctuation),
    ('\x2016', Fence),
    ('\x2020', Relation),
    ('\x2021', Relation),
    ('\x2022', Binary),
    ('\x2026', Normal),
    ('\x2032', Normal),
    ('\x2033', Normal),
    ('\x2034', Normal),
    ('\x2035', Normal),
    ('\x2036', Normal),
    ('\x2037', Normal),
    ('\x203b', Normal),
    ('\x203c', Normal),
    ('\x2040', Binary),
    ('\x2044', Binary),
    ('\x204e', Binary),
    ('\x204f', Relation),
    ('\x2050', Relation),
    ('\x2051', Normal),
    ('\x2052', Normal),
    ('\x2057', Normal),
    ('\x205f', Space),
    ('\x2061', Binary),
    ('\x2062', Binary),
    ('\x2063', Punctuation),
    ('\x2064', Special),
    ('\x207a', Normal),
    ('\x207b', Normal),
    ('\x207c', Normal),
    ('\x207d', Normal),
    ('\x207e', Normal),
    ('\x208a', Normal),
    ('\x208b', Normal),
    ('\x208c', Normal),
    ('\x208d', Normal),
    ('\x208e', Normal),
    ('\x20d0', Diacritic),
    ('\x20d1', Diacritic),
    ('\x20d2', Diacritic),
    ('\x20d3', Special),
    ('\x20d4', Diacritic),
    ('\x20d5', Diacritic),
    ('\x20d6', Diacritic),
    ('\x20d7', Diacritic),
    ('\x20d8', Diacritic),
    ('\x20d9', Diacritic),
    ('\x20da', Diacritic),
    ('\x20db', Diacritic),
    ('\x20dc', Diacritic),
    ('\x20dd', Diacritic),
    ('\x20de', Diacritic),
    ('\x20df', Diacritic),
    ('\x20e1', Diacritic),
    ('\x20e4', Diacritic),
    ('\x20e5', Diacritic),
    ('\x20e6', Diacritic),
    ('\x20e7', Diacritic),
    ('\x20e8', Diacritic),
    ('\x20e9', Diacritic),
    ('\x20ea', Diacritic),
    ('\x20eb', Diacritic),
    ('\x20ec', Diacritic),
    ('\x20ed', Diacritic),
    ('\x20ee', Diacritic),
    ('\x20ef', Diacritic),
    ('\x2102', Alphabetic),
    ('\x2107', Normal),
    ('\x210a', Alphabetic),
    ('\x210b', Alphabetic),
    ('\x210c', Alphabetic),
    ('\x210d', Alphabetic),
    ('\x210e', Normal),
    ('\x210f', Normal),
    ('\x2110', Alphabetic),
    ('\x2111', Alphabetic),
    ('\x2112', Alphabetic),
    ('\x2113', Alphabetic),
    ('\x2115', Alphabetic),
    ('\x2118', Alphabetic),
    ('\x2119', Alphabetic),
    ('\x211a', Alphabetic),
    ('\x211b', Alphabetic),
    ('\x211c', Alphabetic),
    ('\x211d', Alphabetic),
    ('\x2124', Alphabetic),
    ('\x2126', Normal),
    ('\x2127', Normal),
    ('\x2128', Alphabetic),
    ('\x2129', Normal),
    ('\x212b', Alphabetic),
    ('\x212c', Alphabetic),
    ('\x212d', Alphabetic),
    ('\x212f', Alphabetic),
    ('\x2130', Alphabetic),
    ('\x2131', Alphabetic),
    ('\x2132', Normal),
    ('\x2133', Alphabetic),
    ('\x2134', Alphabetic),
    ('\x2135', Alphabetic),
    ('\x2136', Alphabetic),
    ('\x2137', Alphabetic),
    ('\x2138', Alphabetic),
    ('\x213c', Alphabetic),
    ('\x213d', Alphabetic),
    ('\x213e', Normal),
    ('\x213f', Alphabetic),
    ('\x2140', Large),
    ('\x2141', Normal),
    ('\x2142', Normal),
    ('\x2143', Normal),
    ('\x2144', Normal),
    ('\x2145', Normal),
    ('\x2146', Normal),
    ('\x2147', Normal),
    ('\x2148', Normal),
    ('\x2149', Normal),
    ('\x214b', Normal),
    ('\x2190', Relation),
    ('\x2191', Relation),
    ('\x2192', Relation),
    ('\x2193', Relation),
    ('\x2194', Relation),
    ('\x2195', Relation),
    ('\x2196', Relation),
    ('\x2197', Relation),
    ('\x2198', Relation),
    ('\x2199', Relation),
    ('\x219a', Relation),
    ('\x219b', Relation),
    ('\x219c', Relation),
    ('\x219d', Relation),
    ('\x219e', Relation),
    ('\x219f', Relation),
    ('\x21a0', Relation),
    ('\x21a1', Relation),
    ('\x21a2', Relation),
    ('\x21a3', Relation),
    ('\x21a4', Relation),
    ('\x21a5', Relation),
    ('\x21a6', Relation),
    ('\x21a7', Relation),
    ('\x21a8', Relation),
    ('\x21a9', Relation),
    ('\x21aa', Relation),
    ('\x21ab', Relation),
    ('\x21ac', Relation),
    ('\x21ad', Relation),
    ('\x21ae', Relation),
    ('\x21af', Relation),
    ('\x21b0', Relation),
    ('\x21b1', Relation),
    ('\x21b2', Relation),
    ('\x21b3', Relation),
    ('\x21b6', Relation),
    ('\x21b7', Relation),
    ('\x21ba', Relation),
    ('\x21bb', Relation),
    ('\x21bc', Relation),
    ('\x21bd', Relation),
    ('\x21be', Relation),
    ('\x21bf', Relation),
    ('\x21c0', Relation),
    ('\x21c1', Relation),
    ('\x21c2', Relation),
    ('\x21c3', Relation),
    ('\x21c4', Relation),
    ('\x21c5', Relation),
    ('\x21c6', Relation),
    ('\x21c7', Relation),
    ('\x21c8', Relation),
    ('\x21c9', Relation),
    ('\x21ca', Relation),
    ('\x21cb', Relation),
    ('\x21cc', Relation),
    ('\x21cd', Relation),
    ('\x21ce', Relation),
    ('\x21cf', Relation),
    ('\x21d0', Relation),
    ('\x21d1', Relation),
    ('\x21d2', Relation),
    ('\x21d3', Relation),
    ('\x21d4', Relation),
    ('\x21d5', Relation),
    ('\x21d6', Relation),
    ('\x21d7', Relation),
    ('\x21d8', Relation),
    ('\x21d9', Relation),
    ('\x21da', Relation),
    ('\x21db', Relation),
    ('\x21dc', Relation),
    ('\x21dd', Relation),
    ('\x21de', Relation),
    ('\x21df', Relation),
    ('\x21e0', Relation),
    ('\x21e1', Relation),
    ('\x21e2', Relation),
    ('\x21e3', Relation),
    ('\x21e4', Relation),
    ('\x21e5', Relation),
    ('\x21e6', Relation),
    ('\x21e7', Relation),
    ('\x21e8', Relation),
    ('\x21e9', Relation),
    ('\x21ea', Relation),
    ('\x21eb', Relation),
    ('\x21ec', Relation),
    ('\x21ed', Relation),
    ('\x21ee', Relation),
    ('\x21ef', Relation),
    ('\x21f0', Relation),
    ('\x21f1', Relation),
    ('\x21f2', Relation),
    ('\x21f3', Relation),
    ('\x21f4', Relation),
    ('\x21f5', Relation),
    ('\x21f6', Relation),
    ('\x21f7', Relation),
    ('\x21f8', Relation),
    ('\x21f9', Relation),
    ('\x21fa', Relation),
    ('\x21fb', Relation),
    ('\x21fc', Relation),
    ('\x21fd', Relation),
    ('\x21fe', Relation),
    ('\x21ff', Relation),
    ('\x2200', Unary),
    ('\x2201', Unary),
    ('\x2202', Normal),
    ('\x2203', Unary),
    ('\x2204', Unary),
    ('\x2205', Normal),
    ('\x2206', Unary),
    ('\x2207', Unary),
    ('\x2208', Relation),
    ('\x2209', Relation),
    ('\x220a', Relation),
    ('\x220b', Relation),
    ('\x220c', Relation),
    ('\x220d', Relation),
    ('\x220e', Normal),
    ('\x220f', Large),
    ('\x2210', Large),
    ('\x2211', Large),
    ('\x2212', Vary),
    ('\x2213', Vary),
    ('\x2214', Binary),
    ('\x2215', Binary),
    ('\x2216', Binary),
    ('\x2217', Binary),
    ('\x2218', Binary),
    ('\x2219', Binary),
    ('\x221a', Large),
    ('\x221b', Large),
    ('\x221c', Large),
    ('\x221d', Relation),
    ('\x221e', Normal),
    ('\x221f', Normal),
    ('\x2220', Normal),
    ('\x2221', Normal),
    ('\x2222', Normal),
    ('\x2223', Relation),
    ('\x2224', Relation),
    ('\x2225', Relation),
    ('\x2226', Relation),
    ('\x2227', Binary),
    ('\x2228', Binary),
    ('\x2229', Binary),
    ('\x222a', Binary),
    ('\x222b', Large),
    ('\x222c', Large),
    ('\x222d', Large),
    ('\x222e', Large),
    ('\x222f', Large),
    ('\x2230', Large),
    ('\x2231', Large),
    ('\x2232', Large),
    ('\x2233', Large),
    ('\x2234', Relation),
    ('\x2235', Relation),
    ('\x2236', Relation),
    ('\x2237', Relation),
    ('\x2238', Binary),
    ('\x2239', Relation),
    ('\x223a', Relation),
    ('\x223b', Relation),
    ('\x223c', Relation),
    ('\x223d', Relation),
    ('\x223e', Binary),
    ('\x223f', Normal),
    ('\x2240', Binary),
    ('\x2241', Relation),
    ('\x2242', Relation),
    ('\x2243', Relation),
    ('\x2244', Relation),
    ('\x2245', Relation),
    ('\x2246', Relation),
    ('\x2247', Relation),
    ('\x2248', Relation),
    ('\x2249', Relation),
    ('\x224a', Relation),
    ('\x224b', Relation),
    ('\x224c', Relation),
    ('\x224d', Relation),
    ('\x224e', Relation),
    ('\x224f', Relation),
    ('\x2250', Relation),
    ('\x2251', Relation),
    ('\x2252', Relation),
    ('\x2253', Relation),
    ('\x2254', Relation),
    ('\x2255', Relation),
    ('\x2256', Relation),
    ('\x2257', Relation),
    ('\x2258', Relation),
    ('\x2259', Relation),
    ('\x225a', Relation),
    ('\x225b', Relation),
    ('\x225c', Relation),
    ('\x225d', Relation),
    ('\x225e', Relation),
    ('\x225f', Relation),
    ('\x2260', Relation),
    ('\x2261', Relation),
    ('\x2262', Relation),
    ('\x2263', Relation),
    ('\x2264', Relation),
    ('\x2265', Relation),
    ('\x2266', Relation),
    ('\x2267', Relation),
    ('\x2268', Relation),
    ('\x2269', Relation),
    ('\x226a', Relation),
    ('\x226b', Relation),
    ('\x226c', Relation),
    ('\x226d', Relation),
    ('\x226e', Relation),
    ('\x226f', Relation),
    ('\x2270', Relation),
    ('\x2271', Relation),
    ('\x2272', Relation),
    ('\x2273', Relation),
    ('\x2274', Relation),
    ('\x2275', Relation),
    ('\x2276', Relation),
    ('\x2277', Relation),
    ('\x2278', Relation),
    ('\x2279', Relation),
    ('\x227a', Relation),
    ('\x227b', Relation),
    ('\x227c', Relation),
    ('\x227d', Relation),
    ('\x227e', Relation),
    ('\x227f', Relation),
    ('\x2280', Relation),
    ('\x2281', Relation),
    ('\x2282', Relation),
    ('\x2283', Relation),
    ('\x2284', Relation),
    ('\x2285', Relation),
    ('\x2286', Relation),
    ('\x2287', Relation),
    ('\x2288', Relation),
    ('\x2289', Relation),
    ('\x228a', Relation),
    ('\x228b', Relation),
    ('\x228c', Binary),
    ('\x228d', Binary),
    ('\x228e', Binary),
    ('\x228f', Relation),
    ('\x2290', Relation),
    ('\x2291', Relation),
    ('\x2292', Relation),
    ('\x2293', Binary),
    ('\x2294', Binary),
    ('\x2295', Binary),
    ('\x2296', Binary),
    ('\x2297', Binary),
    ('\x2298', Binary),
    ('\x2299', Binary),
    ('\x229a', Binary),
    ('\x229b', Binary),
    ('\x229c', Binary),
    ('\x229d', Binary),
    ('\x229e', Binary),
    ('\x229f', Binary),
    ('\x22a0', Binary),
    ('\x22a1', Binary),
    ('\x22a2', Relation),
    ('\x22a3', Relation),
    ('\x22a4', Normal),
    ('\x22a5', Relation),
    ('\x22a6', Relation),
    ('\x22a7', Relation),
    ('\x22a8', Relation),
    ('\x22a9', Relation),
    ('\x22aa', Relation),
    ('\x22ab', Relation),
    ('\x22ac', Relation),
    ('\x22ad', Relation),
    ('\x22ae', Relation),
    ('\x22af', Relation),
    ('\x22b0', Relation),
    ('\x22b1', Relation),
    ('\x22b2', Relation),
    ('\x22b3', Relation),
    ('\x22b4', Relation),
    ('\x22b5', Relation),
    ('\x22b6', Relation),
    ('\x22b7', Relation),
    ('\x22b8', Relation),
    ('\x22b9', Binary),
    ('\x22ba', Binary),
    ('\x22bb', Binary),
    ('\x22bc', Binary),
    ('\x22bd', Binary),
    ('\x22be', Normal),
    ('\x22bf', Normal),
    ('\x22c0', Large),
    ('\x22c1', Large),
    ('\x22c2', Large),
    ('\x22c3', Large),
    ('\x22c4', Binary),
    ('\x22c5', Binary),
    ('\x22c6', Binary),
    ('\x22c7', Binary),
    ('\x22c8', Relation),
    ('\x22c9', Binary),
    ('\x22ca', Binary),
    ('\x22cb', Binary),
    ('\x22cc', Binary),
    ('\x22cd', Relation),
    ('\x22ce', Binary),
    ('\x22cf', Binary),
    ('\x22d0', Relation),
    ('\x22d1', Relation),
    ('\x22d2', Binary),
    ('\x22d3', Binary),
    ('\x22d4', Relation),
    ('\x22d5', Relation),
    ('\x22d6', Relation),
    ('\x22d7', Relation),
    ('\x22d8', Relation),
    ('\x22d9', Relation),
    ('\x22da', Relation),
    ('\x22db', Relation),
    ('\x22dc', Relation),
    ('\x22dd', Relation),
    ('\x22de', Relation),
    ('\x22df', Relation),
    ('\x22e0', Relation),
    ('\x22e1', Relation),
    ('\x22e2', Relation),
    ('\x22e3', Relation),
    ('\x22e4', Relation),
    ('\x22e5', Relation),
    ('\x22e6', Relation),
    ('\x22e7', Relation),
    ('\x22e8', Relation),
    ('\x22e9', Relation),
    ('\x22ea', Relation),
    ('\x22eb', Relation),
    ('\x22ec', Relation),
    ('\x22ed', Relation),
    ('\x22ee', Relation),
    ('\x22ef', Relation),
    ('\x22f0', Relation),
    ('\x22f1', Relation),
    ('\x22f2', Relation),
    ('\x22f3', Relation),
    ('\x22f4', Relation),
    ('\x22f5', Relation),
    ('\x22f6', Relation),
    ('\x22f7', Relation),
    ('\x22f8', Relation),
    ('\x22f9', Relation),
    ('\x22fa', Relation),
    ('\x22fb', Relation),
    ('\x22fc', Relation),
    ('\x22fd', Relation),
    ('\x22fe', Relation),
    ('\x22ff', Relation),
    ('\x2300', Normal),
    ('\x2302', Normal),
    ('\x2305', Binary),
    ('\x2306', Binary),
    ('\x2308', Opening),
    ('\x2309', Closing),
    ('\x230a', Opening),
    ('\x230b', Closing),
    ('\x2310', Normal),
    ('\x2311', Normal),
    ('\x2319', Normal),
    ('\x231c', Opening),
    ('\x231d', Closing),
    ('\x231e', Opening),
    ('\x231f', Closing),
    ('\x2320', GlyphPart),
    ('\x2321', GlyphPart),
    ('\x2322', Relation),
    ('\x2323', Relation),
    ('\x2336', Normal),
    ('\x233d', Binary),
    ('\x233f', Relation),
    ('\x237c', Relation),
    ('\x2394', Normal),
    ('\x239b', GlyphPart),
    ('\x239c', GlyphPart),
    ('\x239d', GlyphPart),
    ('\x239e', GlyphPart),
    ('\x239f', GlyphPart),
    ('\x23a0', GlyphPart),
    ('\x23a1', GlyphPart),
    ('\x23a2', GlyphPart),
    ('\x23a3', GlyphPart),
    ('\x23a4', GlyphPart),
    ('\x23a5', GlyphPart),
    ('\x23a6', GlyphPart),
    ('\x23a7', GlyphPart),
    ('\x23a8', GlyphPart),
    ('\x23a9', GlyphPart),
    ('\x23aa', GlyphPart),
    ('\x23ab', GlyphPart),
    ('\x23ac', GlyphPart),
    ('\x23ad', GlyphPart),
    ('\x23ae', GlyphPart),
    ('\x23af', GlyphPart),
    ('\x23b0', Relation),
    ('\x23b1', Relation),
    ('\x23b2', GlyphPart),
    ('\x23b3', GlyphPart),
    ('\x23b4', Normal),
    ('\x23b5', Normal),
    ('\x23b6', Normal),
    ('\x23b7', GlyphPart),
    ('\x23d0', GlyphPart),
    ('\x23dc', Normal),
    ('\x23dd', Normal),
    ('\x23de', Normal),
    ('\x23df', Normal),
    ('\x23e0', Normal),
    ('\x23e1', Normal),
    ('\x23e2', Normal),
    ('\x23e3', Normal),
    ('\x23e4', Normal),
    ('\x23e5', Normal),
    ('\x23e6', Normal),
    ('\x23e7', Normal),
    ('\x24c8', Normal),
    ('\x25a0', Normal),
    ('\x25a1', Normal),
    ('\x25aa', Normal),
    ('\x25ab', Normal),
    ('\x25ad', Normal),
    ('\x25ae', Normal),
    ('\x25af', Normal),
    ('\x25b0', Normal),
    ('\x25b1', Normal),
    ('\x25b2', Binary),
    ('\x25b3', Binary),
    ('\x25b4', Binary),
    ('\x25b5', Binary),
    ('\x25b6', Binary),
    ('\x25b7', Binary),
    ('\x25b8', Binary),
    ('\x25b9', Binary),
    ('\x25bc', Binary),
    ('\x25bd', Binary),
    ('\x25be', Binary),
    ('\x25bf', Binary),
    ('\x25c0', Binary),
    ('\x25c1', Binary),
    ('\x25c2', Binary),
    ('\x25c3', Binary),
    ('\x25c4', Binary),
    ('\x25c5', Binary),
    ('\x25c6', Normal),
    ('\x25c7', Normal),
    ('\x25c8', Normal),
    ('\x25c9', Normal),
    ('\x25ca', Binary),
    ('\x25cb', Binary),
    ('\x25ce', Normal),
    ('\x25cf', Normal),
    ('\x25d0', Normal),
    ('\x25d1', Normal),
    ('\x25d2', Normal),
    ('\x25d3', Normal),
    ('\x25d6', Normal),
    ('\x25d7', Normal),
    ('\x25e2', Normal),
    ('\x25e3', Normal),
    ('\x25e4', Normal),
    ('\x25e5', Normal),
    ('\x25e6', Binary),
    ('\x25e7', Normal),
    ('\x25e8', Normal),
    ('\x25e9', Normal),
    ('\x25ea', Normal),
    ('\x25eb', Binary),
    ('\x25ec', Binary),
    ('\x25ef', Normal),
    ('\x25f8', Binary),
    ('\x25f9', Binary),
    ('\x25fa', Binary),
    ('\x25fb', Binary),
    ('\x25fc', Binary),
    ('\x25fd', Binary),
    ('\x25fe', Binary),
    ('\x25ff', Binary),
    ('\x2605', Binary),
    ('\x2606', Binary),
    ('\x2609', Normal),
    ('\x260c', Normal),
    ('\x263d', Normal),
    ('\x263e', Normal),
    ('\x263f', Normal),
    ('\x2640', Normal),
    ('\x2641', Normal),
    ('\x2642', Normal),
    ('\x2643', Normal),
    ('\x2644', Normal),
    ('\x2646', Normal),
    ('\x2647', Normal),
    ('\x2648', Normal),
    ('\x2649', Normal),
    ('\x2660', Normal),
    ('\x2661', Normal),
    ('\x2662', Normal),
    ('\x2663', Normal),
    ('\x2664', Normal),
    ('\x2665', Normal),
    ('\x2666', Normal),
    ('\x2667', Normal),
    ('\x2669', Normal),
    ('\x266d', Normal),
    ('\x266e', Normal),
    ('\x266f', Normal),
    ('\x2680', Normal),
    ('\x2681', Normal),
    ('\x2682', Normal),
    ('\x2683', Normal),
    ('\x2684', Normal),
    ('\x2685', Normal),
    ('\x2686', Normal),
    ('\x2687', Normal),
    ('\x2688', Normal),
    ('\x2689', Normal),
    ('\x26aa', Normal),
    ('\x26ab', Normal),
    ('\x26ac', Normal),
    ('\x26b2', Normal),
    ('\x2713', Normal),
    ('\x2717', Normal),
    ('\x2720', Normal),
    ('\x272a', Normal),
    ('\x2736', Normal),
    ('\x2772', Opening),
    ('\x2773', Closing),
    ('\x27c0', Normal),
    ('\x27c1', Normal),
    ('\x27c2', Relation),
    ('\x27c3', Relation),
    ('\x27c4', Relation),
    ('\x27c5', Relation),
    ('\x27c6', Relation),
    ('\x27c7', Relation),
    ('\x27c8', Relation),
    ('\x27c9', Relation),
    ('\x27ca', Relation),
    ('\x27cb', Relation),
    ('\x27cc', Large),
    ('\x27cd', Relation),
    ('\x27ce', Binary),
    ('\x27cf', Binary),
    ('\x27d0', Normal),
    ('\x27d1', Binary),
    ('\x27d2', Relation),
    ('\x27d3', Relation),
    ('\x27d4', Relation),
    ('\x27d5', Large),
    ('\x27d6', Large),
    ('\x27d7', Large),
    ('\x27d8', Large),
    ('\x27d9', Large),
    ('\x27da', Relation),
    ('\x27db', Relation),
    ('\x27dc', Relation),
    ('\x27dd', Relation),
    ('\x27de', Relation),
    ('\x27df', Relation),
    ('\x27e0', Binary),
    ('\x27e1', Binary),
    ('\x27e2', Binary),
    ('\x27e3', Binary),
    ('\x27e4', Binary),
    ('\x27e5', Binary),
    ('\x27e6', Opening),
    ('\x27e7', Closing),
    ('\x27e8', Opening),
    ('\x27e9', Closing),
    ('\x27ea', Opening),
    ('\x27eb', Closing),
    ('\x27ec', Opening),
    ('\x27ed', Closing),
    ('\x27ee', Opening),
    ('\x27ef', Closing),
    ('\x27f0', Relation),
    ('\x27f1', Relation),
    ('\x27f2', Relation),
    ('\x27f3', Relation),
    ('\x27f4', Relation),
    ('\x27f5', Relation),
    ('\x27f6', Relation),
    ('\x27f7', Relation),
    ('\x27f8', Relation),
    ('\x27f9', Relation),
    ('\x27fa', Relation),
    ('\x27fb', Relation),
    ('\x27fc', Relation),
    ('\x27fd', Relation),
    ('\x27fe', Relation),
    ('\x27ff', Relation),
    ('\x2900', Relation),
    ('\x2901', Relation),
    ('\x2902', Relation),
    ('\x2903', Relation),
    ('\x2904', Relation),
    ('\x2905', Relation),
    ('\x2906', Relation),
    ('\x2907', Relation),
    ('\x2908', Relation),
    ('\x2909', Relation),
    ('\x290a', Relation),
    ('\x290b', Relation),
    ('\x290c', Relation),
    ('\x290d', Relation),
    ('\x290e', Relation),
    ('\x290f', Relation),
    ('\x2910', Relation),
    ('\x2911', Relation),
    ('\x2912', Relation),
    ('\x2913', Relation),
    ('\x2914', Relation),
    ('\x2915', Relation),
    ('\x2916', Relation),
    ('\x2917', Relation),
    ('\x2918', Relation),
    ('\x2919', Relation),
    ('\x291a', Relation),
    ('\x291b', Relation),
    ('\x291c', Relation),
    ('\x291d', Relation),
    ('\x291e', Relation),
    ('\x291f', Relation),
    ('\x2920', Relation),
    ('\x2921', Relation),
    ('\x2922', Relation),
    ('\x2923', Relation),
    ('\x2924', Relation),
    ('\x2925', Relation),
    ('\x2926', Relation),
    ('\x2927', Relation),
    ('\x2928', Relation),
    ('\x2929', Relation),
    ('\x292a', Relation),
    ('\x292b', Relation),
    ('\x292c', Relation),
    ('\x292d', Relation),
    ('\x292e', Relation),
    ('\x292f', Relation),
    ('\x2930', Relation),
    ('\x2931', Relation),
    ('\x2932', Relation),
    ('\x2933', Relation),
    ('\x2934', Relation),
    ('\x2935', Relation),
    ('\x2936', Relation),
    ('\x2937', Relation),
    ('\x2938', Relation),
    ('\x2939', Relation),
    ('\x293a', Relation),
    ('\x293b', Relation),
    ('\x293c', Relation),
    ('\x293d', Relation),
    ('\x293e', Relation),
    ('\x293f', Relation),
    ('\x2940', Relation),
    ('\x2941', Relation),
    ('\x2942', Relation),
    ('\x2943', Relation),
    ('\x2944', Relation),
    ('\x2945', Relation),
    ('\x2946', Relation),
    ('\x2947', Relation),
    ('\x2948', Relation),
    ('\x2949', Relation),
    ('\x294a', Relation),
    ('\x294b', Relation),
    ('\x294c', Relation),
    ('\x294d', Relation),
    ('\x294e', Relation),
    ('\x294f', Relation),
    ('\x2950', Relation),
    ('\x2951', Relation),
    ('\x2952', Relation),
    ('\x2953', Relation),
    ('\x2954', Relation),
    ('\x2955', Relation),
    ('\x2956', Relation),
    ('\x2957', Relation),
    ('\x2958', Relation),
    ('\x2959', Relation),
    ('\x295a', Relation),
    ('\x295b', Relation),
    ('\x295c', Relation),
    ('\x295d', Relation),
    ('\x295e', Relation),
    ('\x295f', Relation),
    ('\x2960', Relation),
    ('\x2961', Relation),
    ('\x2962', Relation),
    ('\x2963', Relation),
    ('\x2964', Relation),
    ('\x2965', Relation),
    ('\x2966', Relation),
    ('\x2967', Relation),
    ('\x2968', Relation),
    ('\x2969', Relation),
    ('\x296a', Relation),
    ('\x296b', Relation),
    ('\x296c', Relation),
    ('\x296d', Relation),
    ('\x296e', Relation),
    ('\x296f', Relation),
    ('\x2970', Relation),
    ('\x2971', Relation),
    ('\x2972', Relation),
    ('\x2973', Relation),
    ('\x2974', Relation),
    ('\x2975', Relation),
    ('\x2976', Relation),
    ('\x2977', Relation),
    ('\x2978', Relation),
    ('\x2979', Relation),
    ('\x297a', Relation),
    ('\x297b', Relation),
    ('\x297c', Relation),
    ('\x297d', Relation),
    ('\x297e', Relation),
    ('\x297f', Relation),
    ('\x2980', Fence),
    ('\x2981', Normal),
    ('\x2982', Fence),
    ('\x2983', Opening),
    ('\x2984', Closing),
    ('\x2985', Opening),
    ('\x2986', Closing),
    ('\x2987', Opening),
    ('\x2988', Closing),
    ('\x2989', Opening),
    ('\x298a', Closing),
    ('\x298b', Opening),
    ('\x298c', Closing),
    ('\x298d', Opening),
    ('\x298e', Closing),
    ('\x298f', Opening),
    ('\x2990', Closing),
    ('\x2991', Opening),
    ('\x2992', Closing),
    ('\x2993', Opening),
    ('\x2994', Closing),
    ('\x2995', Opening),
    ('\x2996', Closing),
    ('\x2997', Opening),
    ('\x2998', Closing),
    ('\x2999', Fence),
    ('\x299a', Fence),
    ('\x299b', Normal),
    ('\x299c', Normal),
    ('\x299d', Normal),
    ('\x299e', Normal),
    ('\x299f', Normal),
    ('\x29a0', Normal),
    ('\x29a1', Normal),
    ('\x29a2', Normal),
    ('\x29a3', Normal),
    ('\x29a4', Normal),
    ('\x29a5', Normal),
    ('\x29a6', Normal),
    ('\x29a7', Normal),
    ('\x29a8', Normal),
    ('\x29a9', Normal),
    ('\x29aa', Normal),
    ('\x29ab', Normal),
    ('\x29ac', Normal),
    ('\x29ad', Normal),
    ('\x29ae', Normal),
    ('\x29af', Normal),
    ('\x29b0', Normal),
    ('\x29b1', Normal),
    ('\x29b2', Normal),
    ('\x29b3', Normal),
    ('\x29b4', Normal),
    ('\x29b5', Normal),
    ('\x29b6', Binary),
    ('\x29b7', Binary),
    ('\x29b8', Binary),
    ('\x29b9', Binary),
    ('\x29ba', Normal),
    ('\x29bb', Normal),
    ('\x29bc', Normal),
    ('\x29bd', Normal),
    ('\x29be', Normal),
    ('\x29bf', Normal),
    ('\x29c0', Binary),
    ('\x29c1', Binary),
    ('\x29c2', Normal),
    ('\x29c3', Normal),
    ('\x29c4', Binary),
    ('\x29c5', Binary),
    ('\x29c6', Binary),
    ('\x29c7', Binary),
    ('\x29c8', Binary),
    ('\x29c9', Normal),
    ('\x29ca', Normal),
    ('\x29cb', Normal),
    ('\x29cc', Normal),
    ('\x29cd', Normal),
    ('\x29ce', Relation),
    ('\x29cf', Relation),
    ('\x29d0', Relation),
    ('\x29d1', Relation),
    ('\x29d2', Relation),
    ('\x29d3', Relation),
    ('\x29d4', Relation),
    ('\x29d5', Relation),
    ('\x29d6', Binary),
    ('\x29d7', Binary),
    ('\x29d8', Opening),
    ('\x29d9', Closing),
    ('\x29da', Opening),
    ('\x29db', Closing),
    ('\x29dc', Normal),
    ('\x29dd', Normal),
    ('\x29de', Normal),
    ('\x29df', Relation),
    ('\x29e0', Normal),
    ('\x29e1', Relation),
    ('\x29e2', Binary),
    ('\x29e3', Relation),
    ('\x29e4', Relation),
    ('\x29e5', Relation),
    ('\x29e6', Relation),
    ('\x29e7', Normal),
    ('\x29e8', Normal),
    ('\x29e9', Normal),
    ('\x29ea', Normal),
    ('\x29eb', Binary),
    ('\x29ec', Normal),
    ('\x29ed', Normal),
    ('\x29ee', Normal),
    ('\x29ef', Normal),
    ('\x29f0', Normal),
    ('\x29f1', Normal),
    ('\x29f2', Normal),
    ('\x29f3', Normal),
    ('\x29f4', Relation),
    ('\x29f5', Binary),
    ('\x29f6', Binary),
    ('\x29f7', Binary),
    ('\x29f8', Large),
    ('\x29f9', Large),
    ('\x29fa', Binary),
    ('\x29fb', Binary),
    ('\x29fc', Opening),
    ('\x29fd', Closing),
    ('\x29fe', Binary),
    ('\x29ff', Binary),
    ('\x2a00', Large),
    ('\x2a01', Large),
    ('\x2a02', Large),
    ('\x2a03', Large),
    ('\x2a04', Large),
    ('\x2a05', Large),
    ('\x2a06', Large),
    ('\x2a07', Large),
    ('\x2a08', Large),
    ('\x2a09', Large),
    ('\x2a0a', Large),
    ('\x2a0b', Large),
    ('\x2a0c', Large),
    ('\x2a0d', Large),
    ('\x2a0e', Large),
    ('\x2a0f', Large),
    ('\x2a10', Large),
    ('\x2a11', Large),
    ('\x2a12', Large),
    ('\x2a13', Large),
    ('\x2a14', Large),
    ('\x2a15', Large),
    ('\x2a16', Large),
    ('\x2a17', Large),
    ('\x2a18', Large),
    ('\x2a19', Large),
    ('\x2a1a', Large),
    ('\x2a1b', Large),
    ('\x2a1c', Large),
    ('\x2a1d', Large),
    ('\x2a1e', Large),
    ('\x2a1f', Large),
    ('\x2a20', Large),
    ('\x2a21', Large),
    ('\x2a22', Binary),
    ('\x2a23', Binary),
    ('\x2a24', Binary),
    ('\x2a25', Binary),
    ('\x2a26', Binary),
    ('\x2a27', Binary),
    ('\x2a28', Binary),
    ('\x2a29', Binary),
    ('\x2a2a', Binary),
    ('\x2a2b', Binary),
    ('\x2a2c', Binary),
    ('\x2a2d', Binary),
    ('\x2a2e', Binary),
    ('\x2a2f', Binary),
    ('\x2a30', Binary),
    ('\x2a31', Binary),
    ('\x2a32', Binary),
    ('\x2a33', Binary),
    ('\x2a34', Binary),
    ('\x2a35', Binary),
    ('\x2a36', Binary),
    ('\x2a37', Binary),
    ('\x2a38', Binary),
    ('\x2a39', Binary),
    ('\x2a3a', Binary),
    ('\x2a3b', Binary),
    ('\x2a3c', Binary),
    ('\x2a3d', Binary),
    ('\x2a3e', Binary),
    ('\x2a3f', Binary),
    ('\x2a40', Binary),
    ('\x2a41', Binary),
    ('\x2a42', Binary),
    ('\x2a43', Binary),
    ('\x2a44', Binary),
    ('\x2a45', Binary),
    ('\x2a46', Binary),
    ('\x2a47', Binary),
    ('\x2a48', Binary),
    ('\x2a49', Binary),
    ('\x2a4a', Binary),
    ('\x2a4b', Binary),
    ('\x2a4c', Binary),
    ('\x2a4d', Binary),
    ('\x2a4e', Binary),
    ('\x2a4f', Binary),
    ('\x2a50', Binary),
    ('\x2a51', Binary),
    ('\x2a52', Binary),
    ('\x2a53', Binary),
    ('\x2a54', Binary),
    ('\x2a55', Binary),
    ('\x2a56', Binary),
    ('\x2a57', Binary),
    ('\x2a58', Binary),
    ('\x2a59', Relation),
    ('\x2a5a', Binary),
    ('\x2a5b', Binary),
    ('\x2a5c', Binary),
    ('\x2a5d', Binary),
    ('\x2a5e', Binary),
    ('\x2a5f', Binary),
    ('\x2a60', Binary),
    ('\x2a61', Binary),
    ('\x2a62', Binary),
    ('\x2a63', Binary),
    ('\x2a64', Binary),
    ('\x2a65', Binary),
    ('\x2a66', Relation),
    ('\x2a67', Relation),
    ('\x2a68', Relation),
    ('\x2a69', Relation),
    ('\x2a6a', Relation),
    ('\x2a6b', Relation),
    ('\x2a6c', Relation),
    ('\x2a6d', Relation),
    ('\x2a6e', Relation),
    ('\x2a6f', Relation),
    ('\x2a70', Relation),
    ('\x2a71', Binary),
    ('\x2a72', Binary),
    ('\x2a73', Relation),
    ('\x2a74', Relation),
    ('\x2a75', Relation),
    ('\x2a76', Relation),
    ('\x2a77', Relation),
    ('\x2a78', Relation),
    ('\x2a79', Relation),
    ('\x2a7a', Relation),
    ('\x2a7b', Relation),
    ('\x2a7c', Relation),
    ('\x2a7d', Relation),
    ('\x2a7e', Relation),
    ('\x2a7f', Relation),
    ('\x2a80', Relation),
    ('\x2a81', Relation),
    ('\x2a82', Relation),
    ('\x2a83', Relation),
    ('\x2a84', Relation),
    ('\x2a85', Relation),
    ('\x2a86', Relation),
    ('\x2a87', Relation),
    ('\x2a88', Relation),
    ('\x2a89', Relation),
    ('\x2a8a', Relation),
    ('\x2a8b', Relation),
    ('\x2a8c', Relation),
    ('\x2a8d', Relation),
    ('\x2a8e', Relation),
    ('\x2a8f', Relation),
    ('\x2a90', Relation),
    ('\x2a91', Relation),
    ('\x2a92', Relation),
    ('\x2a93', Relation),
    ('\x2a94', Relation),
    ('\x2a95', Relation),
    ('\x2a96', Relation),
    ('\x2a97', Relation),
    ('\x2a98', Relation),
    ('\x2a99', Relation),
    ('\x2a9a', Relation),
    ('\x2a9b', Relation),
    ('\x2a9c', Relation),
    ('\x2a9d', Relation),
    ('\x2a9e', Relation),
    ('\x2a9f', Relation),
    ('\x2aa0', Relation),
    ('\x2aa1', Relation),
    ('\x2aa2', Relation),
    ('\x2aa3', Relation),
    ('\x2aa4', Relation),
    ('\x2aa5', Relation),
    ('\x2aa6', Relation),
    ('\x2aa7', Relation),
    ('\x2aa8', Relation),
    ('\x2aa9', Relation),
    ('\x2aaa', Relation),
    ('\x2aab', Relation),
    ('\x2aac', Relation),
    ('\x2aad', Relation),
    ('\x2aae', Relation),
    ('\x2aaf', Relation),
    ('\x2ab0', Relation),
    ('\x2ab1', Relation),
    ('\x2ab2', Relation),
    ('\x2ab3', Relation),
    ('\x2ab4', Relation),
    ('\x2ab5', Relation),
    ('\x2ab6', Relation),
    ('\x2ab7', Relation),
    ('\x2ab8', Relation),
    ('\x2ab9', Relation),
    ('\x2aba', Relation),
    ('\x2abb', Relation),
    ('\x2abc', Relation),
    ('\x2abd', Relation),
    ('\x2abe', Relation),
    ('\x2abf', Relation),
    ('\x2ac0', Relation),
    ('\x2ac1', Relation),
    ('\x2ac2', Relation),
    ('\x2ac3', Relation),
    ('\x2ac4', Relation),
    ('\x2ac5', Relation),
    ('\x2ac6', Relation),
    ('\x2ac7', Relation),
    ('\x2ac8', Relation),
    ('\x2ac9', Relation),
    ('\x2aca', Relation),
    ('\x2acb', Relation),
    ('\x2acc', Relation),
    ('\x2acd', Relation),
    ('\x2ace', Relation),
    ('\x2acf', Relation),
    ('\x2ad0', Relation),
    ('\x2ad1', Relation),
    ('\x2ad2', Relation),
    ('\x2ad3', Relation),
    ('\x2ad4', Relation),
    ('\x2ad5', Relation),
    ('\x2ad6', Relation),
    ('\x2ad7', Relation),
    ('\x2ad8', Relation),
    ('\x2ad9', Relation),
    ('\x2ada', Relation),
    ('\x2adb', Relation),
    ('\x2adc', Relation),
    ('\x2add', Relation),
    ('\x2ade', Relation),
    ('\x2adf', Relation),
    ('\x2ae0', Relation),
    ('\x2ae1', Normal),
    ('\x2ae2', Relation),
    ('\x2ae3', Relation),
    ('\x2ae4', Relation),
    ('\x2ae5', Relation),
    ('\x2ae6', Relation),
    ('\x2ae7', Relation),
    ('\x2ae8', Relation),
    ('\x2ae9', Relation),
    ('\x2aea', Relation),
    ('\x2aeb', Relation),
    ('\x2aec', Relation),
    ('\x2aed', Relation),
    ('\x2aee', Relation),
    ('\x2aef', Relation),
    ('\x2af0', Relation),
    ('\x2af1', Normal),
    ('\x2af2', Relation),
    ('\x2af3', Relation),
    ('\x2af4', Binary),
    ('\x2af5', Binary),
    ('\x2af6', Binary),
    ('\x2af7', Relation),
    ('\x2af8', Relation),
    ('\x2af9', Relation),
    ('\x2afa', Relation),
    ('\x2afb', Binary),
    ('\x2afc', Large),
    ('\x2afd', Binary),
    ('\x2afe', Binary),
    ('\x2aff', Large),
    ('\x2b00', Relation),
    ('\x2b01', Relation),
    ('\x2b02', Relation),
    ('\x2b03', Relation),
    ('\x2b04', Relation),
    ('\x2b05', Relation),
    ('\x2b06', Relation),
    ('\x2b07', Relation),
    ('\x2b08', Relation),
    ('\x2b09', Relation),
    ('\x2b0a', Relation),
    ('\x2b0b', Relation),
    ('\x2b0c', Relation),
    ('\x2b0d', Relation),
    ('\x2b0e', Relation),
    ('\x2b0f', Relation),
    ('\x2b10', Relation),
    ('\x2b11', Relation),
    ('\x2b12', Normal),
    ('\x2b13', Normal),
    ('\x2b14', Normal),
    ('\x2b15', Normal),
    ('\x2b16', Normal),
    ('\x2b17', Normal),
    ('\x2b18', Normal),
    ('\x2b19', Normal),
    ('\x2b1b', Normal),
    ('\x2b1c', Normal),
    ('\x2b1d', Normal),
    ('\x2b1e', Normal),
    ('\x2b1f', Normal),
    ('\x2b20', Normal),
    ('\x2b21', Normal),
    ('\x2b22', Normal),
    ('\x2b23', Normal),
    ('\x2b24', Normal),
    ('\x2b25', Normal),
    ('\x2b26', Normal),
    ('\x2b27', Normal),
    ('\x2b28', Normal),
    ('\x2b29', Normal),
    ('\x2b2a', Normal),
    ('\x2b2b', Normal),
    ('\x2b2c', Normal),
    ('\x2b2d', Normal),
    ('\x2b2e', Normal),
    ('\x2b2f', Normal),
    ('\x2b30', Relation),
    ('\x2b31', Relation),
    ('\x2b32', Relation),
    ('\x2b33', Relation),
    ('\x2b34', Relation),
    ('\x2b35', Relation),
    ('\x2b36', Relation),
    ('\x2b37', Relation),
    ('\x2b38', Relation),
    ('\x2b39', Relation),
    ('\x2b3a', Relation),
    ('\x2b3b', Relation),
    ('\x2b3c', Relation),
    ('\x2b3d', Relation),
    ('\x2b3e', Relation),
    ('\x2b3f', Relation),
    ('\x2b40', Relation),
    ('\x2b41', Relation),
    ('\x2b42', Relation),
    ('\x2b43', Relation),
    ('\x2b44', Relation),
    ('\x2b45', Relation),
    ('\x2b46', Relation),
    ('\x2b47', Relation),
    ('\x2b48', Relation),
    ('\x2b49', Relation),
    ('\x2b4a', Relation),
    ('\x2b4b', Relation),
    ('\x2b4c', Relation),
    ('\x2b50', Normal),
    ('\x2b51', Normal),
    ('\x2b52', Normal),
    ('\x2b53', Normal),
    ('\x2b54', Normal),
    ('\x2b95', Relation),
    ('\x2bc2', Normal),
    ('\x2bc3', Normal),
    ('\x2bc4', Normal),
    ('\x2bc5', Normal),
    ('\x2bc6', Normal),
    ('\x2bc7', Normal),
    ('\x2bc8', Normal),
    ('\x2bca', Normal),
    ('\x2bcb', Normal),
    ('\x3008', Special),
    ('\x3009', Special),
    ('\x301a', Special),
    ('\x301b', Special),
    ('\x306e', Normal),
    ('\xfb29', Special),
    ('\xfe00', Diacritic),
    ('\xfe61', Special),
    ('\xfe62', Special),
    ('\xfe63', Special),
    ('\xfe64', Special),
    ('\xfe65', Special),
    ('\xfe66', Special),
    ('\xfe68', Special),
    ('\xff0b', Special),
    ('\xff1c', Special),
    ('\xff1d', Special),
    ('\xff1e', Special),
    ('\xff3c', Special),
    ('\xff3e', Special),
    ('\xff5c', Special),
    ('\xff5e', Special),
    ('\xffe2', Special),
    ('\xffe9', Special),
    ('\xffea', Special),
    ('\xffeb', Special),
    ('\xffec', Special),
    ('\x1d400', Alphabetic),
    ('\x1d401', Alphabetic),
    ('\x1d402', Alphabetic),
    ('\x1d403', Alphabetic),
    ('\x1d404', Alphabetic),
    ('\x1d405', Alphabetic),
    ('\x1d406', Alphabetic),
    ('\x1d407', Alphabetic),
    ('\x1d408', Alphabetic),
    ('\x1d409', Alphabetic),
    ('\x1d40a', Alphabetic),
    ('\x1d40b', Alphabetic),
    ('\x1d40c', Alphabetic),
    ('\x1d40d', Alphabetic),
    ('\x1d40e', Alphabetic),
    ('\x1d40f', Alphabetic),
    ('\x1d410', Alphabetic),
    ('\x1d411', Alphabetic),
    ('\x1d412', Alphabetic),
    ('\x1d413', Alphabetic),
    ('\x1d414', Alphabetic),
    ('\x1d415', Alphabetic),
    ('\x1d416', Alphabetic),
    ('\x1d417', Alphabetic),
    ('\x1d418', Alphabetic),
    ('\x1d419', Alphabetic),
    ('\x1d41a', Alphabetic),
    ('\x1d41b', Alphabetic),
    ('\x1d41c', Alphabetic),
    ('\x1d41d', Alphabetic),
    ('\x1d41e', Alphabetic),
    ('\x1d41f', Alphabetic),
    ('\x1d420', Alphabetic),
    ('\x1d421', Alphabetic),
    ('\x1d422', Alphabetic),
    ('\x1d423', Alphabetic),
    ('\x1d424', Alphabetic),
    ('\x1d425', Alphabetic),
    ('\x1d426', Alphabetic),
    ('\x1d427', Alphabetic),
    ('\x1d428', Alphabetic),
    ('\x1d429', Alphabetic),
    ('\x1d42a', Alphabetic),
    ('\x1d42b', Alphabetic),
    ('\x1d42c', Alphabetic),
    ('\x1d42d', Alphabetic),
    ('\x1d42e', Alphabetic),
    ('\x1d42f', Alphabetic),
    ('\x1d430', Alphabetic),
    ('\x1d431', Alphabetic),
    ('\x1d432', Alphabetic),
    ('\x1d433', Alphabetic),
    ('\x1d434', Alphabetic),
    ('\x1d435', Alphabetic),
    ('\x1d436', Alphabetic),
    ('\x1d437', Alphabetic),
    ('\x1d438', Alphabetic),
    ('\x1d439', Alphabetic),
    ('\x1d43a', Alphabetic),
    ('\x1d43b', Alphabetic),
    ('\x1d43c', Alphabetic),
    ('\x1d43d', Alphabetic),
    ('\x1d43e', Alphabetic),
    ('\x1d43f', Alphabetic),
    ('\x1d440', Alphabetic),
    ('\x1d441', Alphabetic),
    ('\x1d442', Alphabetic),
    ('\x1d443', Alphabetic),
    ('\x1d444', Alphabetic),
    ('\x1d445', Alphabetic),
    ('\x1d446', Alphabetic),
    ('\x1d447', Alphabetic),
    ('\x1d448', Alphabetic),
    ('\x1d449', Alphabetic),
    ('\x1d44a', Alphabetic),
    ('\x1d44b', Alphabetic),
    ('\x1d44c', Alphabetic),
    ('\x1d44d', Alphabetic),
    ('\x1d44e', Alphabetic),
    ('\x1d44f', Alphabetic),
    ('\x1d450', Alphabetic),
    ('\x1d451', Alphabetic),
    ('\x1d452', Alphabetic),
    ('\x1d453', Alphabetic),
    ('\x1d454', Alphabetic),
    ('\x1d456', Alphabetic),
    ('\x1d457', Alphabetic),
    ('\x1d458', Alphabetic),
    ('\x1d459', Alphabetic),
    ('\x1d45a', Alphabetic),
    ('\x1d45b', Alphabetic),
    ('\x1d45c', Alphabetic),
    ('\x1d45d', Alphabetic),
    ('\x1d45e', Alphabetic),
    ('\x1d45f', Alphabetic),
    ('\x1d460', Alphabetic),
    ('\x1d461', Alphabetic),
    ('\x1d462', Alphabetic),
    ('\x1d463', Alphabetic),
    ('\x1d464', Alphabetic),
    ('\x1d465', Alphabetic),
    ('\x1d466', Alphabetic),
    ('\x1d467', Alphabetic),
    ('\x1d468', Alphabetic),
    ('\x1d469', Alphabetic),
    ('\x1d46a', Alphabetic),
    ('\x1d46b', Alphabetic),
    ('\x1d46c', Alphabetic),
    ('\x1d46d', Alphabetic),
    ('\x1d46e', Alphabetic),
    ('\x1d46f', Alphabetic),
    ('\x1d470', Alphabetic),
    ('\x1d471', Alphabetic),
    ('\x1d472', Alphabetic),
    ('\x1d473', Alphabetic),
    ('\x1d474', Alphabetic),
    ('\x1d475', Alphabetic),
    ('\x1d476', Alphabetic),
    ('\x1d477', Alphabetic),
    ('\x1d478', Alphabetic),
    ('\x1d479', Alphabetic),
    ('\x1d47a', Alphabetic),
    ('\x1d47b', Alphabetic),
    ('\x1d47c', Alphabetic),
    ('\x1d47d', Alphabetic),
    ('\x1d47e', Alphabetic),
    ('\x1d47f', Alphabetic),
    ('\x1d480', Alphabetic),
    ('\x1d481', Alphabetic),
    ('\x1d482', Alphabetic),
    ('\x1d483', Alphabetic),
    ('\x1d484', Alphabetic),
    ('\x1d485', Alphabetic),
    ('\x1d486', Alphabetic),
    ('\x1d487', Alphabetic),
    ('\x1d488', Alphabetic),
    ('\x1d489', Alphabetic),
    ('\x1d48a', Alphabetic),
    ('\x1d48b', Alphabetic),
    ('\x1d48c', Alphabetic),
    ('\x1d48d', Alphabetic),
    ('\x1d48e', Alphabetic),
    ('\x1d48f', Alphabetic),
    ('\x1d490', Alphabetic),
    ('\x1d491', Alphabetic),
    ('\x1d492', Alphabetic),
    ('\x1d493', Alphabetic),
    ('\x1d494', Alphabetic),
    ('\x1d495', Alphabetic),
    ('\x1d496', Alphabetic),
    ('\x1d497', Alphabetic),
    ('\x1d498', Alphabetic),
    ('\x1d499', Alphabetic),
    ('\x1d49a', Alphabetic),
    ('\x1d49b', Alphabetic),
    ('\x1d49c', Alphabetic),
    ('\x1d49e', Alphabetic),
    ('\x1d49f', Alphabetic),
    ('\x1d4a2', Alphabetic),
    ('\x1d4a5', Alphabetic),
    ('\x1d4a6', Alphabetic),
    ('\x1d4a9', Alphabetic),
    ('\x1d4aa', Alphabetic),
    ('\x1d4ab', Alphabetic),
    ('\x1d4ac', Alphabetic),
    ('\x1d4ae', Alphabetic),
    ('\x1d4af', Alphabetic),
    ('\x1d4b0', Alphabetic),
    ('\x1d4b1', Alphabetic),
    ('\x1d4b2', Alphabetic),
    ('\x1d4b3', Alphabetic),
    ('\x1d4b4', Alphabetic),
    ('\x1d4b5', Alphabetic),
    ('\x1d4b6', Alphabetic),
    ('\x1d4b7', Alphabetic),
    ('\x1d4b8', Alphabetic),
    ('\x1d4b9', Alphabetic),
    ('\x1d4bb', Alphabetic),
    ('\x1d4bd', Alphabetic),
    ('\x1d4be', Alphabetic),
    ('\x1d4bf', Alphabetic),
    ('\x1d4c0', Alphabetic),
    ('\x1d4c1', Alphabetic),
    ('\x1d4c2', Alphabetic),
    ('\x1d4c3', Alphabetic),
    ('\x1d4c5', Alphabetic),
    ('\x1d4c6', Alphabetic),
    ('\x1d4c7', Alphabetic),
    ('\x1d4c8', Alphabetic),
    ('\x1d4c9', Alphabetic),
    ('\x1d4ca', Alphabetic),
    ('\x1d4cb', Alphabetic),
    ('\x1d4cc', Alphabetic),
    ('\x1d4cd', Alphabetic),
    ('\x1d4ce', Alphabetic),
    ('\x1d4cf', Alphabetic),
    ('\x1d4d0', Alphabetic),
    ('\x1d4d1', Alphabetic),
    ('\x1d4d2', Alphabetic),
    ('\x1d4d3', Alphabetic),
    ('\x1d4d4', Alphabetic),
    ('\x1d4d5', Alphabetic),
    ('\x1d4d6', Alphabetic),
    ('\x1d4d7', Alphabetic),
    ('\x1d4d8', Alphabetic),
    ('\x1d4d9', Alphabetic),
    ('\x1d4da', Alphabetic),
    ('\x1d4db', Alphabetic),
    ('\x1d4dc', Alphabetic),
    ('\x1d4dd', Alphabetic),
    ('\x1d4de', Alphabetic),
    ('\x1d4df', Alphabetic),
    ('\x1d4e0', Alphabetic),
    ('\x1d4e1', Alphabetic),
    ('\x1d4e2', Alphabetic),
    ('\x1d4e3', Alphabetic),
    ('\x1d4e4', Alphabetic),
    ('\x1d4e5', Alphabetic),
    ('\x1d4e6', Alphabetic),
    ('\x1d4e7', Alphabetic),
    ('\x1d4e8', Alphabetic),
    ('\x1d4e9', Alphabetic),
    ('\x1d4ea', Alphabetic),
    ('\x1d4eb', Alphabetic),
    ('\x1d4ec', Alphabetic),
    ('\x1d4ed', Alphabetic),
    ('\x1d4ee', Alphabetic),
    ('\x1d4ef', Alphabetic),
    ('\x1d4f0', Alphabetic),
    ('\x1d4f1', Alphabetic),
    ('\x1d4f2', Alphabetic),
    ('\x1d4f3', Alphabetic),
    ('\x1d4f4', Alphabetic),
    ('\x1d4f5', Alphabetic),
    ('\x1d4f6', Alphabetic),
    ('\x1d4f7', Alphabetic),
    ('\x1d4f8', Alphabetic),
    ('\x1d4f9', Alphabetic),
    ('\x1d4fa', Alphabetic),
    ('\x1d4fb', Alphabetic),
    ('\x1d4fc', Alphabetic),
    ('\x1d4fd', Alphabetic),
    ('\x1d4fe', Alphabetic),
    ('\x1d4ff', Alphabetic),
    ('\x1d500', Alphabetic),
    ('\x1d501', Alphabetic),
    ('\x1d502', Alphabetic),
    ('\x1d503', Alphabetic),
    ('\x1d504', Alphabetic),
    ('\x1d505', Alphabetic),
    ('\x1d507', Alphabetic),
    ('\x1d508', Alphabetic),
    ('\x1d509', Alphabetic),
    ('\x1d50a', Alphabetic),
    ('\x1d50d', Alphabetic),
    ('\x1d50e', Alphabetic),
    ('\x1d50f', Alphabetic),
    ('\x1d510', Alphabetic),
    ('\x1d511', Alphabetic),
    ('\x1d512', Alphabetic),
    ('\x1d513', Alphabetic),
    ('\x1d514', Alphabetic),
    ('\x1d516', Alphabetic),
    ('\x1d517', Alphabetic),
    ('\x1d518', Alphabetic),
    ('\x1d519', Alphabetic),
    ('\x1d51a', Alphabetic),
    ('\x1d51b', Alphabetic),
    ('\x1d51c', Alphabetic),
    ('\x1d51e', Alphabetic),
    ('\x1d51f', Alphabetic),
    ('\x1d520', Alphabetic),
    ('\x1d521', Alphabetic),
    ('\x1d522', Alphabetic),
    ('\x1d523', Alphabetic),
    ('\x1d524', Alphabetic),
    ('\x1d525', Alphabetic),
    ('\x1d526', Alphabetic),
    ('\x1d527', Alphabetic),
    ('\x1d528', Alphabetic),
    ('\x1d529', Alphabetic),
    ('\x1d52a', Alphabetic),
    ('\x1d52b', Alphabetic),
    ('\x1d52c', Alphabetic),
    ('\x1d52d', Alphabetic),
    ('\x1d52e', Alphabetic),
    ('\x1d52f', Alphabetic),
    ('\x1d530', Alphabetic),
    ('\x1d531', Alphabetic),
    ('\x1d532', Alphabetic),
    ('\x1d533', Alphabetic),
    ('\x1d534', Alphabetic),
    ('\x1d535', Alphabetic),
    ('\x1d536', Alphabetic),
    ('\x1d537', Alphabetic),
    ('\x1d538', Alphabetic),
    ('\x1d539', Alphabetic),
    ('\x1d53b', Alphabetic),
    ('\x1d53c', Alphabetic),
    ('\x1d53d', Alphabetic),
    ('\x1d53e', Alphabetic),
    ('\x1d540', Alphabetic),
    ('\x1d541', Alphabetic),
    ('\x1d542', Alphabetic),
    ('\x1d543', Alphabetic),
    ('\x1d544', Alphabetic),
    ('\x1d546', Alphabetic),
    ('\x1d54a', Alphabetic),
    ('\x1d54b', Alphabetic),
    ('\x1d54c', Alphabetic),
    ('\x1d54d', Alphabetic),
    ('\x1d54e', Alphabetic),
    ('\x1d54f', Alphabetic),
    ('\x1d550', Alphabetic),
    ('\x1d552', Alphabetic),
    ('\x1d553', Alphabetic),
    ('\x1d554', Alphabetic),
    ('\x1d555', Alphabetic),
    ('\x1d556', Alphabetic),
    ('\x1d557', Alphabetic),
    ('\x1d558', Alphabetic),
    ('\x1d559', Alphabetic),
    ('\x1d55a', Alphabetic),
    ('\x1d55b', Alphabetic),
    ('\x1d55c', Alphabetic),
    ('\x1d55d', Alphabetic),
    ('\x1d55e', Alphabetic),
    ('\x1d55f', Alphabetic),
    ('\x1d560', Alphabetic),
    ('\x1d561', Alphabetic),
    ('\x1d562', Alphabetic),
    ('\x1d563', Alphabetic),
    ('\x1d564', Alphabetic),
    ('\x1d565', Alphabetic),
    ('\x1d566', Alphabetic),
    ('\x1d567', Alphabetic),
    ('\x1d568', Alphabetic),
    ('\x1d569', Alphabetic),
    ('\x1d56a', Alphabetic),
    ('\x1d56b', Alphabetic),
    ('\x1d56c', Alphabetic),
    ('\x1d56d', Alphabetic),
    ('\x1d56e', Alphabetic),
    ('\x1d56f', Alphabetic),
    ('\x1d570', Alphabetic),
    ('\x1d571', Alphabetic),
    ('\x1d572', Alphabetic),
    ('\x1d573', Alphabetic),
    ('\x1d574', Alphabetic),
    ('\x1d575', Alphabetic),
    ('\x1d576', Alphabetic),
    ('\x1d577', Alphabetic),
    ('\x1d578', Alphabetic),
    ('\x1d579', Alphabetic),
    ('\x1d57a', Alphabetic),
    ('\x1d57b', Alphabetic),
    ('\x1d57c', Alphabetic),
    ('\x1d57d', Alphabetic),
    ('\x1d57e', Alphabetic),
    ('\x1d57f', Alphabetic),
    ('\x1d580', Alphabetic),
    ('\x1d581', Alphabetic),
    ('\x1d582', Alphabetic),
    ('\x1d583', Alphabetic),
    ('\x1d584', Alphabetic),
    ('\x1d585', Alphabetic),
    ('\x1d586', Alphabetic),
    ('\x1d587', Alphabetic),
    ('\x1d588', Alphabetic),
    ('\x1d589', Alphabetic),
    ('\x1d58a', Alphabetic),
    ('\x1d58b', Alphabetic),
    ('\x1d58c', Alphabetic),
    ('\x1d58d', Alphabetic),
    ('\x1d58e', Alphabetic),
    ('\x1d58f', Alphabetic),
    ('\x1d590', Alphabetic),
    ('\x1d591', Alphabetic),
    ('\x1d592', Alphabetic),
    ('\x1d593', Alphabetic),
    ('\x1d594', Alphabetic),
    ('\x1d595', Alphabetic),
    ('\x1d596', Alphabetic),
    ('\x1d597', Alphabetic),
    ('\x1d598', Alphabetic),
    ('\x1d599', Alphabetic),
    ('\x1d59a', Alphabetic),
    ('\x1d59b', Alphabetic),
    ('\x1d59c', Alphabetic),
    ('\x1d59d', Alphabetic),
    ('\x1d59e', Alphabetic),
    ('\x1d59f', Alphabetic),
    ('\x1d5a0', Alphabetic),
    ('\x1d5a1', Alphabetic),
    ('\x1d5a2', Alphabetic),
    ('\x1d5a3', Alphabetic),
    ('\x1d5a4', Alphabetic),
    ('\x1d5a5', Alphabetic),
    ('\x1d5a6', Alphabetic),
    ('\x1d5a7', Alphabetic),
    ('\x1d5a8', Alphabetic),
    ('\x1d5a9', Alphabetic),
    ('\x1d5aa', Alphabetic),
    ('\x1d5ab', Alphabetic),
    ('\x1d5ac', Alphabetic),
    ('\x1d5ad', Alphabetic),
    ('\x1d5ae', Alphabetic),
    ('\x1d5af', Alphabetic),
    ('\x1d5b0', Alphabetic),
    ('\x1d5b1', Alphabetic),
    ('\x1d5b2', Alphabetic),
    ('\x1d5b3', Alphabetic),
    ('\x1d5b4', Alphabetic),
    ('\x1d5b5', Alphabetic),
    ('\x1d5b6', Alphabetic),
    ('\x1d5b7', Alphabetic),
    ('\x1d5b8', Alphabetic),
    ('\x1d5b9', Alphabetic),
    ('\x1d5ba', Alphabetic),
    ('\x1d5bb', Alphabetic),
    ('\x1d5bc', Alphabetic),
    ('\x1d5bd', Alphabetic),
    ('\x1d5be', Alphabetic),
    ('\x1d5bf', Alphabetic),
    ('\x1d5c0', Alphabetic),
    ('\x1d5c1', Alphabetic),
    ('\x1d5c2', Alphabetic),
    ('\x1d5c3', Alphabetic),
    ('\x1d5c4', Alphabetic),
    ('\x1d5c5', Alphabetic),
    ('\x1d5c6', Alphabetic),
    ('\x1d5c7', Alphabetic),
    ('\x1d5c8', Alphabetic),
    ('\x1d5c9', Alphabetic),
    ('\x1d5ca', Alphabetic),
    ('\x1d5cb', Alphabetic),
    ('\x1d5cc', Alphabetic),
    ('\x1d5cd', Alphabetic),
    ('\x1d5ce', Alphabetic),
    ('\x1d5cf', Alphabetic),
    ('\x1d5d0', Alphabetic),
    ('\x1d5d1', Alphabetic),
    ('\x1d5d2', Alphabetic),
    ('\x1d5d3', Alphabetic),
    ('\x1d5d4', Alphabetic),
    ('\x1d5d5', Alphabetic),
    ('\x1d5d6', Alphabetic),
    ('\x1d5d7', Alphabetic),
    ('\x1d5d8', Alphabetic),
    ('\x1d5d9', Alphabetic),
    ('\x1d5da', Alphabetic),
    ('\x1d5db', Alphabetic),
    ('\x1d5dc', Alphabetic),
    ('\x1d5dd', Alphabetic),
    ('\x1d5de', Alphabetic),
    ('\x1d5df', Alphabetic),
    ('\x1d5e0', Alphabetic),
    ('\x1d5e1', Alphabetic),
    ('\x1d5e2', Alphabetic),
    ('\x1d5e3', Alphabetic),
    ('\x1d5e4', Alphabetic),
    ('\x1d5e5', Alphabetic),
    ('\x1d5e6', Alphabetic),
    ('\x1d5e7', Alphabetic),
    ('\x1d5e8', Alphabetic),
    ('\x1d5e9', Alphabetic),
    ('\x1d5ea', Alphabetic),
    ('\x1d5eb', Alphabetic),
    ('\x1d5ec', Alphabetic),
    ('\x1d5ed', Alphabetic),
    ('\x1d5ee', Alphabetic),
    ('\x1d5ef', Alphabetic),
    ('\x1d5f0', Alphabetic),
    ('\x1d5f1', Alphabetic),
    ('\x1d5f2', Alphabetic),
    ('\x1d5f3', Alphabetic),
    ('\x1d5f4', Alphabetic),
    ('\x1d5f5', Alphabetic),
    ('\x1d5f6', Alphabetic),
    ('\x1d5f7', Alphabetic),
    ('\x1d5f8', Alphabetic),
    ('\x1d5f9', Alphabetic),
    ('\x1d5fa', Alphabetic),
    ('\x1d5fb', Alphabetic),
    ('\x1d5fc', Alphabetic),
    ('\x1d5fd', Alphabetic),
    ('\x1d5fe', Alphabetic),
    ('\x1d5ff', Alphabetic),
    ('\x1d600', Alphabetic),
    ('\x1d601', Alphabetic),
    ('\x1d602', Alphabetic),
    ('\x1d603', Alphabetic),
    ('\x1d604', Alphabetic),
    ('\x1d605', Alphabetic),
    ('\x1d606', Alphabetic),
    ('\x1d607', Alphabetic),
    ('\x1d608', Alphabetic),
    ('\x1d609', Alphabetic),
    ('\x1d60a', Alphabetic),
    ('\x1d60b', Alphabetic),
    ('\x1d60c', Alphabetic),
    ('\x1d60d', Alphabetic),
    ('\x1d60e', Alphabetic),
    ('\x1d60f', Alphabetic),
    ('\x1d610', Alphabetic),
    ('\x1d611', Alphabetic),
    ('\x1d612', Alphabetic),
    ('\x1d613', Alphabetic),
    ('\x1d614', Alphabetic),
    ('\x1d615', Alphabetic),
    ('\x1d616', Alphabetic),
    ('\x1d617', Alphabetic),
    ('\x1d618', Alphabetic),
    ('\x1d619', Alphabetic),
    ('\x1d61a', Alphabetic),
    ('\x1d61b', Alphabetic),
    ('\x1d61c', Alphabetic),
    ('\x1d61d', Alphabetic),
    ('\x1d61e', Alphabetic),
    ('\x1d61f', Alphabetic),
    ('\x1d620', Alphabetic),
    ('\x1d621', Alphabetic),
    ('\x1d622', Alphabetic),
    ('\x1d623', Alphabetic),
    ('\x1d624', Alphabetic),
    ('\x1d625', Alphabetic),
    ('\x1d626', Alphabetic),
    ('\x1d627', Alphabetic),
    ('\x1d628', Alphabetic),
    ('\x1d629', Alphabetic),
    ('\x1d62a', Alphabetic),
    ('\x1d62b', Alphabetic),
    ('\x1d62c', Alphabetic),
    ('\x1d62d', Alphabetic),
    ('\x1d62e', Alphabetic),
    ('\x1d62f', Alphabetic),
    ('\x1d630', Alphabetic),
    ('\x1d631', Alphabetic),
    ('\x1d632', Alphabetic),
    ('\x1d633', Alphabetic),
    ('\x1d634', Alphabetic),
    ('\x1d635', Alphabetic),
    ('\x1d636', Alphabetic),
    ('\x1d637', Alphabetic),
    ('\x1d638', Alphabetic),
    ('\x1d639', Alphabetic),
    ('\x1d63a', Alphabetic),
    ('\x1d63b', Alphabetic),
    ('\x1d63c', Alphabetic),
    ('\x1d63d', Alphabetic),
    ('\x1d63e', Alphabetic),
    ('\x1d63f', Alphabetic),
    ('\x1d640', Alphabetic),
    ('\x1d641', Alphabetic),
    ('\x1d642', Alphabetic),
    ('\x1d643', Alphabetic),
    ('\x1d644', Alphabetic),
    ('\x1d645', Alphabetic),
    ('\x1d646', Alphabetic),
    ('\x1d647', Alphabetic),
    ('\x1d648', Alphabetic),
    ('\x1d649', Alphabetic),
    ('\x1d64a', Alphabetic),
    ('\x1d64b', Alphabetic),
    ('\x1d64c', Alphabetic),
    ('\x1d64d', Alphabetic),
    ('\x1d64e', Alphabetic),
    ('\x1d64f', Alphabetic),
    ('\x1d650', Alphabetic),
    ('\x1d651', Alphabetic),
    ('\x1d652', Alphabetic),
    ('\x1d653', Alphabetic),
    ('\x1d654', Alphabetic),
    ('\x1d655', Alphabetic),
    ('\x1d656', Alphabetic),
    ('\x1d657', Alphabetic),
    ('\x1d658', Alphabetic),
    ('\x1d659', Alphabetic),
    ('\x1d65a', Alphabetic),
    ('\x1d65b', Alphabetic),
    ('\x1d65c', Alphabetic),
    ('\x1d65d', Alphabetic),
    ('\x1d65e', Alphabetic),
    ('\x1d65f', Alphabetic),
    ('\x1d660', Alphabetic),
    ('\x1d661', Alphabetic),
    ('\x1d662', Alphabetic),
    ('\x1d663', Alphabetic),
    ('\x1d664', Alphabetic),
    ('\x1d665', Alphabetic),
    ('\x1d666', Alphabetic),
    ('\x1d667', Alphabetic),
    ('\x1d668', Alphabetic),
    ('\x1d669', Alphabetic),
    ('\x1d66a', Alphabetic),
    ('\x1d66b', Alphabetic),
    ('\x1d66c', Alphabetic),
    ('\x1d66d', Alphabetic),
    ('\x1d66e', Alphabetic),
    ('\x1d66f', Alphabetic),
    ('\x1d670', Alphabetic),
    ('\x1d671', Alphabetic),
    ('\x1d672', Alphabetic),
    ('\x1d673', Alphabetic),
    ('\x1d674', Alphabetic),
    ('\x1d675', Alphabetic),
    ('\x1d676', Alphabetic),
    ('\x1d677', Alphabetic),
    ('\x1d678', Alphabetic),
    ('\x1d679', Alphabetic),
    ('\x1d67a', Alphabetic),
    ('\x1d67b', Alphabetic),
    ('\x1d67c', Alphabetic),
    ('\x1d67d', Alphabetic),
    ('\x1d67e', Alphabetic),
    ('\x1d67f', Alphabetic),
    ('\x1d680', Alphabetic),
    ('\x1d681', Alphabetic),
    ('\x1d682', Alphabetic),
    ('\x1d683', Alphabetic),
    ('\x1d684', Alphabetic),
    ('\x1d685', Alphabetic),
    ('\x1d686', Alphabetic),
    ('\x1d687', Alphabetic),
    ('\x1d688', Alphabetic),
    ('\x1d689', Alphabetic),
    ('\x1d68a', Alphabetic),
    ('\x1d68b', Alphabetic),
    ('\x1d68c', Alphabetic),
    ('\x1d68d', Alphabetic),
    ('\x1d68e', Alphabetic),
    ('\x1d68f', Alphabetic),
    ('\x1d690', Alphabetic),
    ('\x1d691', Alphabetic),
    ('\x1d692', Alphabetic),
    ('\x1d693', Alphabetic),
    ('\x1d694', Alphabetic),
    ('\x1d695', Alphabetic),
    ('\x1d696', Alphabetic),
    ('\x1d697', Alphabetic),
    ('\x1d698', Alphabetic),
    ('\x1d699', Alphabetic),
    ('\x1d69a', Alphabetic),
    ('\x1d69b', Alphabetic),
    ('\x1d69c', Alphabetic),
    ('\x1d69d', Alphabetic),
    ('\x1d69e', Alphabetic),
    ('\x1d69f', Alphabetic),
    ('\x1d6a0', Alphabetic),
    ('\x1d6a1', Alphabetic),
    ('\x1d6a2', Alphabetic),
    ('\x1d6a3', Alphabetic),
    ('\x1d6a4', Alphabetic),
    ('\x1d6a5', Alphabetic),
    ('\x1d6a8', Alphabetic),
    ('\x1d6a9', Alphabetic),
    ('\x1d6aa', Alphabetic),
    ('\x1d6ab', Alphabetic),
    ('\x1d6ac', Alphabetic),
    ('\x1d6ad', Alphabetic),
    ('\x1d6ae', Alphabetic),
    ('\x1d6af', Alphabetic),
    ('\x1d6b0', Alphabetic),
    ('\x1d6b1', Alphabetic),
    ('\x1d6b2', Alphabetic),
    ('\x1d6b3', Alphabetic),
    ('\x1d6b4', Alphabetic),
    ('\x1d6b5', Alphabetic),
    ('\x1d6b6', Alphabetic),
    ('\x1d6b7', Alphabetic),
    ('\x1d6b8', Alphabetic),
    ('\x1d6b9', Alphabetic),
    ('\x1d6ba', Alphabetic),
    ('\x1d6bb', Alphabetic),
    ('\x1d6bc', Alphabetic),
    ('\x1d6bd', Alphabetic),
    ('\x1d6be', Alphabetic),
    ('\x1d6bf', Alphabetic),
    ('\x1d6c0', Alphabetic),
    ('\x1d6c1', Alphabetic),
    ('\x1d6c2', Alphabetic),
    ('\x1d6c3', Alphabetic),
    ('\x1d6c4', Alphabetic),
    ('\x1d6c5', Alphabetic),
    ('\x1d6c6', Alphabetic),
    ('\x1d6c7', Alphabetic),
    ('\x1d6c8', Alphabetic),
    ('\x1d6c9', Alphabetic),
    ('\x1d6ca', Alphabetic),
    ('\x1d6cb', Alphabetic),
    ('\x1d6cc', Alphabetic),
    ('\x1d6cd', Alphabetic),
    ('\x1d6ce', Alphabetic),
    ('\x1d6cf', Alphabetic),
    ('\x1d6d0', Alphabetic),
    ('\x1d6d1', Alphabetic),
    ('\x1d6d2', Alphabetic),
    ('\x1d6d3', Alphabetic),
    ('\x1d6d4', Alphabetic),
    ('\x1d6d5', Alphabetic),
    ('\x1d6d6', Alphabetic),
    ('\x1d6d7', Alphabetic),
    ('\x1d6d8', Alphabetic),
    ('\x1d6d9', Alphabetic),
    ('\x1d6da', Alphabetic),
    ('\x1d6db', Alphabetic),
    ('\x1d6dc', Alphabetic),
    ('\x1d6dd', Alphabetic),
    ('\x1d6de', Alphabetic),
    ('\x1d6df', Alphabetic),
    ('\x1d6e0', Alphabetic),
    ('\x1d6e1', Alphabetic),
    ('\x1d6e2', Alphabetic),
    ('\x1d6e3', Alphabetic),
    ('\x1d6e4', Alphabetic),
    ('\x1d6e5', Alphabetic),
    ('\x1d6e6', Alphabetic),
    ('\x1d6e7', Alphabetic),
    ('\x1d6e8', Alphabetic),
    ('\x1d6e9', Alphabetic),
    ('\x1d6ea', Alphabetic),
    ('\x1d6eb', Alphabetic),
    ('\x1d6ec', Alphabetic),
    ('\x1d6ed', Alphabetic),
    ('\x1d6ee', Alphabetic),
    ('\x1d6ef', Alphabetic),
    ('\x1d6f0', Alphabetic),
    ('\x1d6f1', Alphabetic),
    ('\x1d6f2', Alphabetic),
    ('\x1d6f3', Alphabetic),
    ('\x1d6f4', Alphabetic),
    ('\x1d6f5', Alphabetic),
    ('\x1d6f6', Alphabetic),
    ('\x1d6f7', Alphabetic),
    ('\x1d6f8', Alphabetic),
    ('\x1d6f9', Alphabetic),
    ('\x1d6fa', Alphabetic),
    ('\x1d6fb', Alphabetic),
    ('\x1d6fc', Alphabetic),
    ('\x1d6fd', Alphabetic),
    ('\x1d6fe', Alphabetic),
    ('\x1d6ff', Alphabetic),
    ('\x1d700', Alphabetic),
    ('\x1d701', Alphabetic),
    ('\x1d702', Alphabetic),
    ('\x1d703', Alphabetic),
    ('\x1d704', Alphabetic),
    ('\x1d705', Alphabetic),
    ('\x1d706', Alphabetic),
    ('\x1d707', Alphabetic),
    ('\x1d708', Alphabetic),
    ('\x1d709', Alphabetic),
    ('\x1d70a', Alphabetic),
    ('\x1d70b', Alphabetic),
    ('\x1d70c', Alphabetic),
    ('\x1d70d', Alphabetic),
    ('\x1d70e', Alphabetic),
    ('\x1d70f', Alphabetic),
    ('\x1d710', Alphabetic),
    ('\x1d711', Alphabetic),
    ('\x1d712', Alphabetic),
    ('\x1d713', Alphabetic),
    ('\x1d714', Alphabetic),
    ('\x1d715', Alphabetic),
    ('\x1d716', Alphabetic),
    ('\x1d717', Alphabetic),
    ('\x1d718', Alphabetic),
    ('\x1d719', Alphabetic),
    ('\x1d71a', Alphabetic),
    ('\x1d71b', Alphabetic),
    ('\x1d71c', Alphabetic),
    ('\x1d71d', Alphabetic),
    ('\x1d71e', Alphabetic),
    ('\x1d71f', Alphabetic),
    ('\x1d720', Alphabetic),
    ('\x1d721', Alphabetic),
    ('\x1d722', Alphabetic),
    ('\x1d723', Alphabetic),
    ('\x1d724', Alphabetic),
    ('\x1d725', Alphabetic),
    ('\x1d726', Alphabetic),
    ('\x1d727', Alphabetic),
    ('\x1d728', Alphabetic),
    ('\x1d729', Alphabetic),
    ('\x1d72a', Alphabetic),
    ('\x1d72b', Alphabetic),
    ('\x1d72c', Alphabetic),
    ('\x1d72d', Alphabetic),
    ('\x1d72e', Alphabetic),
    ('\x1d72f', Alphabetic),
    ('\x1d730', Alphabetic),
    ('\x1d731', Alphabetic),
    ('\x1d732', Alphabetic),
    ('\x1d733', Alphabetic),
    ('\x1d734', Alphabetic),
    ('\x1d735', Alphabetic),
    ('\x1d736', Alphabetic),
    ('\x1d737', Alphabetic),
    ('\x1d738', Alphabetic),
    ('\x1d739', Alphabetic),
    ('\x1d73a', Alphabetic),
    ('\x1d73b', Alphabetic),
    ('\x1d73c', Alphabetic),
    ('\x1d73d', Alphabetic),
    ('\x1d73e', Alphabetic),
    ('\x1d73f', Alphabetic),
    ('\x1d740', Alphabetic),
    ('\x1d741', Alphabetic),
    ('\x1d742', Alphabetic),
    ('\x1d743', Alphabetic),
    ('\x1d744', Alphabetic),
    ('\x1d745', Alphabetic),
    ('\x1d746', Alphabetic),
    ('\x1d747', Alphabetic),
    ('\x1d748', Alphabetic),
    ('\x1d749', Alphabetic),
    ('\x1d74a', Alphabetic),
    ('\x1d74b', Alphabetic),
    ('\x1d74c', Alphabetic),
    ('\x1d74d', Alphabetic),
    ('\x1d74e', Alphabetic),
    ('\x1d74f', Alphabetic),
    ('\x1d750', Alphabetic),
    ('\x1d751', Alphabetic),
    ('\x1d752', Alphabetic),
    ('\x1d753', Alphabetic),
    ('\x1d754', Alphabetic),
    ('\x1d755', Alphabetic),
    ('\x1d756', Alphabetic),
    ('\x1d757', Alphabetic),
    ('\x1d758', Alphabetic),
    ('\x1d759', Alphabetic),
    ('\x1d75a', Alphabetic),
    ('\x1d75b', Alphabetic),
    ('\x1d75c', Alphabetic),
    ('\x1d75d', Alphabetic),
    ('\x1d75e', Alphabetic),
    ('\x1d75f', Alphabetic),
    ('\x1d760', Alphabetic),
    ('\x1d761', Alphabetic),
    ('\x1d762', Alphabetic),
    ('\x1d763', Alphabetic),
    ('\x1d764', Alphabetic),
    ('\x1d765', Alphabetic),
    ('\x1d766', Alphabetic),
    ('\x1d767', Alphabetic),
    ('\x1d768', Alphabetic),
    ('\x1d769', Alphabetic),
    ('\x1d76a', Alphabetic),
    ('\x1d76b', Alphabetic),
    ('\x1d76c', Alphabetic),
    ('\x1d76d', Alphabetic),
    ('\x1d76e', Alphabetic),
    ('\x1d76f', Alphabetic),
    ('\x1d770', Alphabetic),
    ('\x1d771', Alphabetic),
    ('\x1d772', Alphabetic),
    ('\x1d773', Alphabetic),
    ('\x1d774', Alphabetic),
    ('\x1d775', Alphabetic),
    ('\x1d776', Alphabetic),
    ('\x1d777', Alphabetic),
    ('\x1d778', Alphabetic),
    ('\x1d779', Alphabetic),
    ('\x1d77a', Alphabetic),
    ('\x1d77b', Alphabetic),
    ('\x1d77c', Alphabetic),
    ('\x1d77d', Alphabetic),
    ('\x1d77e', Alphabetic),
    ('\x1d77f', Alphabetic),
    ('\x1d780', Alphabetic),
    ('\x1d781', Alphabetic),
    ('\x1d782', Alphabetic),
    ('\x1d783', Alphabetic),
    ('\x1d784', Alphabetic),
    ('\x1d785', Alphabetic),
    ('\x1d786', Alphabetic),
    ('\x1d787', Alphabetic),
    ('\x1d788', Alphabetic),
    ('\x1d789', Alphabetic),
    ('\x1d78a', Alphabetic),
    ('\x1d78b', Alphabetic),
    ('\x1d78c', Alphabetic),
    ('\x1d78d', Alphabetic),
    ('\x1d78e', Alphabetic),
    ('\x1d78f', Alphabetic),
    ('\x1d790', Alphabetic),
    ('\x1d791', Alphabetic),
    ('\x1d792', Alphabetic),
    ('\x1d793', Alphabetic),
    ('\x1d794', Alphabetic),
    ('\x1d795', Alphabetic),
    ('\x1d796', Alphabetic),
    ('\x1d797', Alphabetic),
    ('\x1d798', Alphabetic),
    ('\x1d799', Alphabetic),
    ('\x1d79a', Alphabetic),
    ('\x1d79b', Alphabetic),
    ('\x1d79c', Alphabetic),
    ('\x1d79d', Alphabetic),
    ('\x1d79e', Alphabetic),
    ('\x1d79f', Alphabetic),
    ('\x1d7a0', Alphabetic),
    ('\x1d7a1', Alphabetic),
    ('\x1d7a2', Alphabetic),
    ('\x1d7a3', Alphabetic),
    ('\x1d7a4', Alphabetic),
    ('\x1d7a5', Alphabetic),
    ('\x1d7a6', Alphabetic),
    ('\x1d7a7', Alphabetic),
    ('\x1d7a8', Alphabetic),
    ('\x1d7a9', Alphabetic),
    ('\x1d7aa', Alphabetic),
    ('\x1d7ab', Alphabetic),
    ('\x1d7ac', Alphabetic),
    ('\x1d7ad', Alphabetic),
    ('\x1d7ae', Alphabetic),
    ('\x1d7af', Alphabetic),
    ('\x1d7b0', Alphabetic),
    ('\x1d7b1', Alphabetic),
    ('\x1d7b2', Alphabetic),
    ('\x1d7b3', Alphabetic),
    ('\x1d7b4', Alphabetic),
    ('\x1d7b5', Alphabetic),
    ('\x1d7b6', Alphabetic),
    ('\x1d7b7', Alphabetic),
    ('\x1d7b8', Alphabetic),
    ('\x1d7b9', Alphabetic),
    ('\x1d7ba', Alphabetic),
    ('\x1d7bb', Alphabetic),
    ('\x1d7bc', Alphabetic),
    ('\x1d7bd', Alphabetic),
    ('\x1d7be', Alphabetic),
    ('\x1d7bf', Alphabetic),
    ('\x1d7c0', Alphabetic),
    ('\x1d7c1', Alphabetic),
    ('\x1d7c2', Alphabetic),
    ('\x1d7c3', Alphabetic),
    ('\x1d7c4', Alphabetic),
    ('\x1d7c5', Alphabetic),
    ('\x1d7c6', Alphabetic),
    ('\x1d7c7', Alphabetic),
    ('\x1d7c8', Alphabetic),
    ('\x1d7c9', Alphabetic),
    ('\x1d7ca', Alphabetic),
    ('\x1d7cb', Alphabetic),
    ('\x1d7ce', Normal),
    ('\x1d7cf', Normal),
    ('\x1d7d0', Normal),
    ('\x1d7d1', Normal),
    ('\x1d7d2', Normal),
    ('\x1d7d3', Normal),
    ('\x1d7d4', Normal),
    ('\x1d7d5', Normal),
    ('\x1d7d6', Normal),
    ('\x1d7d7', Normal),
    ('\x1d7d8', Normal),
    ('\x1d7d9', Normal),
    ('\x1d7da', Normal),
    ('\x1d7db', Normal),
    ('\x1d7dc', Normal),
    ('\x1d7dd', Normal),
    ('\x1d7de', Normal),
    ('\x1d7df', Normal),
    ('\x1d7e0', Normal),
    ('\x1d7e1', Normal),
    ('\x1d7e2', Normal),
    ('\x1d7e3', Normal),
    ('\x1d7e4', Normal),
    ('\x1d7e5', Normal),
    ('\x1d7e6', Normal),
    ('\x1d7e7', Normal),
    ('\x1d7e8', Normal),
    ('\x1d7e9', Normal),
    ('\x1d7ea', Normal),
    ('\x1d7eb', Normal),
    ('\x1d7ec', Normal),
    ('\x1d7ed', Normal),
    ('\x1d7ee', Normal),
    ('\x1d7ef', Normal),
    ('\x1d7f0', Normal),
    ('\x1d7f1', Normal),
    ('\x1d7f2', Normal),
    ('\x1d7f3', Normal),
    ('\x1d7f4', Normal),
    ('\x1d7f5', Normal),
    ('\x1d7f6', Normal),
    ('\x1d7f7', Normal),
    ('\x1d7f8', Normal),
    ('\x1d7f9', Normal),
    ('\x1d7fa', Normal),
    ('\x1d7fb', Normal),
    ('\x1d7fc', Normal),
    ('\x1d7fd', Normal),
    ('\x1d7fe', Normal),
    ('\x1d7ff', Normal),
    ('\x1ee00', Alphabetic),
    ('\x1ee01', Alphabetic),
    ('\x1ee02', Alphabetic),
    ('\x1ee03', Alphabetic),
    ('\x1ee05', Alphabetic),
    ('\x1ee06', Alphabetic),
    ('\x1ee07', Alphabetic),
    ('\x1ee08', Alphabetic),
    ('\x1ee09', Alphabetic),
    ('\x1ee0a', Alphabetic),
    ('\x1ee0b', Alphabetic),
    ('\x1ee0c', Alphabetic),
    ('\x1ee0d', Alphabetic),
    ('\x1ee0e', Alphabetic),
    ('\x1ee0f', Alphabetic),
    ('\x1ee10', Alphabetic),
    ('\x1ee11', Alphabetic),
    ('\x1ee12', Alphabetic),
    ('\x1ee13', Alphabetic),
    ('\x1ee14', Alphabetic),
    ('\x1ee15', Alphabetic),
    ('\x1ee16', Alphabetic),
    ('\x1ee17', Alphabetic),
    ('\x1ee18', Alphabetic),
    ('\x1ee19', Alphabetic),
    ('\x1ee1a', Alphabetic),
    ('\x1ee1b', Alphabetic),
    ('\x1ee1c', Alphabetic),
    ('\x1ee1d', Alphabetic),
    ('\x1ee1e', Alphabetic),
    ('\x1ee1f', Alphabetic),
    ('\x1ee21', Alphabetic),
    ('\x1ee22', Alphabetic),
    ('\x1ee24', Alphabetic),
    ('\x1ee27', Alphabetic),
    ('\x1ee29', Alphabetic),
    ('\x1ee2a', Alphabetic),
    ('\x1ee2b', Alphabetic),
    ('\x1ee2c', Alphabetic),
    ('\x1ee2d', Alphabetic),
    ('\x1ee2e', Alphabetic),
    ('\x1ee2f', Alphabetic),
    ('\x1ee30', Alphabetic),
    ('\x1ee31', Alphabetic),
    ('\x1ee32', Alphabetic),
    ('\x1ee34', Alphabetic),
    ('\x1ee35', Alphabetic),
    ('\x1ee36', Alphabetic),
    ('\x1ee37', Alphabetic),
    ('\x1ee39', Alphabetic),
    ('\x1ee3b', Alphabetic),
    ('\x1ee42', Alphabetic),
    ('\x1ee47', Alphabetic),
    ('\x1ee49', Alphabetic),
    ('\x1ee4b', Alphabetic),
    ('\x1ee4d', Alphabetic),
    ('\x1ee4e', Alphabetic),
    ('\x1ee4f', Alphabetic),
    ('\x1ee51', Alphabetic),
    ('\x1ee52', Alphabetic),
    ('\x1ee54', Alphabetic),
    ('\x1ee57', Alphabetic),
    ('\x1ee59', Alphabetic),
    ('\x1ee5b', Alphabetic),
    ('\x1ee5d', Alphabetic),
    ('\x1ee5f', Alphabetic),
    ('\x1ee61', Alphabetic),
    ('\x1ee62', Alphabetic),
    ('\x1ee64', Alphabetic),
    ('\x1ee67', Alphabetic),
    ('\x1ee68', Alphabetic),
    ('\x1ee69', Alphabetic),
    ('\x1ee6a', Alphabetic),
    ('\x1ee6c', Alphabetic),
    ('\x1ee6d', Alphabetic),
    ('\x1ee6e', Alphabetic),
    ('\x1ee6f', Alphabetic),
    ('\x1ee70', Alphabetic),
    ('\x1ee71', Alphabetic),
    ('\x1ee72', Alphabetic),
    ('\x1ee74', Alphabetic),
    ('\x1ee75', Alphabetic),
    ('\x1ee76', Alphabetic),
    ('\x1ee77', Alphabetic),
    ('\x1ee79', Alphabetic),
    ('\x1ee7a', Alphabetic),
    ('\x1ee7b', Alphabetic),
    ('\x1ee7c', Alphabetic),
    ('\x1ee7e', Alphabetic),
    ('\x1ee80', Alphabetic),
    ('\x1ee81', Alphabetic),
    ('\x1ee82', Alphabetic),
    ('\x1ee83', Alphabetic),
    ('\x1ee84', Alphabetic),
    ('\x1ee85', Alphabetic),
    ('\x1ee86', Alphabetic),
    ('\x1ee87', Alphabetic),
    ('\x1ee88', Alphabetic),
    ('\x1ee89', Alphabetic),
    ('\x1ee8b', Alphabetic),
    ('\x1ee8c', Alphabetic),
    ('\x1ee8d', Alphabetic),
    ('\x1ee8e', Alphabetic),
    ('\x1ee8f', Alphabetic),
    ('\x1ee90', Alphabetic),
    ('\x1ee91', Alphabetic),
    ('\x1ee92', Alphabetic),
    ('\x1ee93', Alphabetic),
    ('\x1ee94', Alphabetic),
    ('\x1ee95', Alphabetic),
    ('\x1ee96', Alphabetic),
    ('\x1ee97', Alphabetic),
    ('\x1ee98', Alphabetic),
    ('\x1ee99', Alphabetic),
    ('\x1ee9a', Alphabetic),
    ('\x1ee9b', Alphabetic),
    ('\x1eea1', Alphabetic),
    ('\x1eea2', Alphabetic),
    ('\x1eea3', Alphabetic),
    ('\x1eea5', Alphabetic),
    ('\x1eea6', Alphabetic),
    ('\x1eea7', Alphabetic),
    ('\x1eea8', Alphabetic),
    ('\x1eea9', Alphabetic),
    ('\x1eeab', Alphabetic),
    ('\x1eeac', Alphabetic),
    ('\x1eead', Alphabetic),
    ('\x1eeae', Alphabetic),
    ('\x1eeaf', Alphabetic),
    ('\x1eeb0', Alphabetic),
    ('\x1eeb1', Alphabetic),
    ('\x1eeb2', Alphabetic),
    ('\x1eeb3', Alphabetic),
    ('\x1eeb4', Alphabetic),
    ('\x1eeb5', Alphabetic),
    ('\x1eeb6', Alphabetic),
    ('\x1eeb7', Alphabetic),
    ('\x1eeb8', Alphabetic),
    ('\x1eeb9', Alphabetic),
    ('\x1eeba', Alphabetic),
    ('\x1eebb', Alphabetic),
    ('\x1eef0', Large),
    ('\x1eef1', Large),
    ('\x1f784', Normal),
    ('\x1f78c', Normal),
    ('\x1f78d', Normal),
    ('\x1f797', Normal),
    ('\x1f798', Normal),
    ('\x1f799', Normal),
    ('\x1f79d', Normal),
    ('\x1f79e', Normal),
    ('\x1f79f', Normal)]
