/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Description

\*---------------------------------------------------------------------------*/

#include <OpenFOAM/error.H>
#include "blockMesh.H"

// * * * * * * * * * * * * * Private Member Functions  * * * * * * * * * * * //

Foam::labelList Foam::blockMesh::createBlockOffsets()
{
    Info<< nl << "Creating block offsets" << endl;

    blockMesh& blocks = *this;

    nPoints_ = blocks[0].points().size();
    nCells_ = blocks[0].cells().size();

    labelList BlockOffsets(blocks.size());
    BlockOffsets[0] = 0;

    label blockLabel;
    for (blockLabel=1; blockLabel<blocks.size(); blockLabel++)
    {
        nPoints_ += blocks[blockLabel].points().size();
        nCells_ += blocks[blockLabel].cells().size();

        BlockOffsets[blockLabel]
            = BlockOffsets[blockLabel-1]
            + blocks[blockLabel-1].points().size();
    }

    return BlockOffsets;
}

// ************************ vim: set sw=4 sts=4 et: ************************ //
