/*
 * $Id: misc_gen_eth_busy.c,v 1.9 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "misc_gen_eth_busy.h"

#define CHIP_(x) misc_gen_eth_busy_ ## x
#define CHIP "misc_gen_eth_busy"

struct cpssp {
	/* Ports */
	struct sig_boolean *port_busy;
	struct sig_eth *port_eth0;
	struct sig_eth *port_eth1;

	/* State */
	unsigned int active;
};

static void
CHIP_(recv0)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->active = 1;

	sig_eth_send(cpssp->port_eth1, cpssp, buf, buflen);
}

static void
CHIP_(recv1)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->active = 1;

	sig_eth_send(cpssp->port_eth0, cpssp, buf, buflen);
}

static void
CHIP_(timer)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	sig_boolean_set(cpssp->port_busy, cpssp, cpssp->active);

	cpssp->active = 0;

	time_call_after(TIME_HZ, CHIP_(timer), cpssp);
}

void *
CHIP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_eth *port_eth0,
	struct sig_eth *port_eth1,
	struct sig_boolean *port_busy
)
{
	static const struct sig_eth_funcs eth0_funcs = {
		.recv = CHIP_(recv0),
	};
	static const struct sig_eth_funcs eth1_funcs = {
		.recv = CHIP_(recv1),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* FIXME */

	/* Call */
	cpssp->port_eth0 = port_eth0;
	sig_eth_connect(port_eth0, cpssp, &eth0_funcs);

	cpssp->port_eth1 = port_eth1;
	sig_eth_connect(port_eth1, cpssp, &eth1_funcs);

	/* Out */
	cpssp->port_busy = port_busy;
	sig_boolean_connect_out(port_busy, cpssp, 0);

	/* In */

	time_call_after(TIME_HZ, CHIP_(timer), cpssp);

	return cpssp;
}

void
CHIP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
CHIP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
CHIP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
