# 💂‍♂ - 🥇 🔁

➡️ 🌈 👈 👆 ✔️ 👆 **👩‍💻** 🛠️ 🆔.

&amp; 👆 ✔️ **🕸** ➕1️⃣ 🆔 ⚖️ 🎏 ➡ 🎏 🆔 (⚖️ 📱 🈸).

&amp; 👆 💚 ✔️ 🌌 🕸 🔓 ⏮️ 👩‍💻, ⚙️ **🆔** &amp; **🔐**.

👥 💪 ⚙️ **Oauth2️⃣** 🏗 👈 ⏮️ **FastAPI**.

✋️ ➡️ 🖊 👆 🕰 👂 🌕 📏 🔧 🔎 👈 🐥 🍖 ℹ 👆 💪.

➡️ ⚙️ 🧰 🚚 **FastAPI** 🍵 💂‍♂.

## ❔ ⚫️ 👀

➡️ 🥇 ⚙️ 📟 &amp; 👀 ❔ ⚫️ 👷, &amp; ⤴️ 👥 🔜 👟 🔙 🤔 ⚫️❔ 😥.

## ✍ `main.py`

📁 🖼 📁 `main.py`:

```Python
{!../../../docs_src/security/tutorial001.py!}
```

## 🏃 ⚫️

!!! info
    🥇 ❎ <a href="https://andrew-d.github.io/python-multipart/" class="external-link" target="_blank">`python-multipart`</a>.

    🤶 Ⓜ. `pip install python-multipart`.

    👉 ↩️ **Oauth2️⃣** ⚙️ "📨 📊" 📨 `username` &amp; `password`.

🏃 🖼 ⏮️:

<div class="termy">

```console
$ uvicorn main:app --reload

<span style="color: green;">INFO</span>:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)
```

</div>

## ✅ ⚫️

🚶 🎓 🩺: <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a>.

👆 🔜 👀 🕳 💖 👉:

<img src="/img/tutorial/security/image01.png">

!!! check "✔ 🔼 ❗"
    👆 ⏪ ✔️ ✨ 🆕 "✔" 🔼.

     &amp; 👆 *➡ 🛠️* ✔️ 🐥 🔒 🔝-▶️️ ↩ 👈 👆 💪 🖊.

&amp; 🚥 👆 🖊 ⚫️, 👆 ✔️ 🐥 ✔ 📨 🆎 `username` &amp; `password` (&amp; 🎏 📦 🏑):

<img src="/img/tutorial/security/image02.png">

!!! note
    ⚫️ 🚫 🤔 ⚫️❔ 👆 🆎 📨, ⚫️ 🏆 🚫 👷. ✋️ 👥 🔜 🤚 📤.

👉 ↗️ 🚫 🕸 🏁 👩‍💻, ✋️ ⚫️ 👑 🏧 🧰 📄 🖥 🌐 👆 🛠️.

⚫️ 💪 ⚙️ 🕸 🏉 (👈 💪 👆).

⚫️ 💪 ⚙️ 🥉 🥳 🈸 &amp; ⚙️.

&amp; ⚫️ 💪 ⚙️ 👆, ℹ, ✅ &amp; 💯 🎏 🈸.

##  `password` 💧

🔜 ➡️ 🚶 🔙 👄 &amp; 🤔 ⚫️❔ 🌐 👈.

`password` "💧" 1️⃣ 🌌 ("💧") 🔬 Oauth2️⃣, 🍵 💂‍♂ &amp; 🤝.

Oauth2️⃣ 🔧 👈 👩‍💻 ⚖️ 🛠️ 💪 🔬 💽 👈 🔓 👩‍💻.

✋️ 👉 💼, 🎏 **FastAPI** 🈸 🔜 🍵 🛠️ &amp; 🤝.

, ➡️ 📄 ⚫️ ⚪️➡️ 👈 📉 ☝ 🎑:

* 👩‍💻 🆎 `username` &amp; `password` 🕸, &amp; 🎯 `Enter`.
* 🕸 (🏃‍♂ 👩‍💻 🖥) 📨 👈 `username` &amp; `password` 🎯 📛 👆 🛠️ (📣 ⏮️ `tokenUrl="token"`).
* 🛠️ ✅ 👈 `username` &amp; `password`, &amp; 📨 ⏮️ "🤝" (👥 🚫 🛠️ 🙆 👉).
    *  "🤝" 🎻 ⏮️ 🎚 👈 👥 💪 ⚙️ ⏪ ✔ 👉 👩‍💻.
    * 🛎, 🤝 ⚒ 🕛 ⏮️ 🕰.
        * , 👩‍💻 🔜 ✔️ 🕹 🔄 ☝ ⏪.
        *  &amp; 🚥 🤝 📎, ⚠ 🌘. ⚫️ 🚫 💖 🧲 🔑 👈 🔜 👷 ♾ (🏆 💼).
* 🕸 🏪 👈 🤝 🍕 👱.
* 👩‍💻 🖊 🕸 🚶 ➕1️⃣ 📄 🕸 🕸 📱.
* 🕸 💪 ☕ 🌅 💽 ⚪️➡️ 🛠️.
    * ✋️ ⚫️ 💪 🤝 👈 🎯 🔗.
    * , 🔓 ⏮️ 👆 🛠️, ⚫️ 📨 🎚 `Authorization` ⏮️ 💲 `Bearer ` ➕ 🤝.
    * 🚥 🤝 🔌 `foobar`, 🎚 `Authorization` 🎚 🔜: `Bearer foobar`.

## **FastAPI**'Ⓜ `OAuth2PasswordBearer`

**FastAPI** 🚚 📚 🧰, 🎏 🎚 ⚛, 🛠️ 👫 💂‍♂ ⚒.

👉 🖼 👥 🔜 ⚙️ **Oauth2️⃣**, ⏮️ **🔐** 💧, ⚙️ **📨** 🤝. 👥 👈 ⚙️ `OAuth2PasswordBearer` 🎓.

!!! info
     "📨" 🤝 🚫 🕴 🎛.

    ✋️ ⚫️ 🏆 1️⃣ 👆 ⚙️ 💼.

     &amp; ⚫️ 💪 🏆 🏆 ⚙️ 💼, 🚥 👆 Oauth2️⃣ 🕴 &amp; 💭 ⚫️❔ ⚫️❔ 📤 ➕1️⃣ 🎛 👈 ♣ 👻 👆 💪.

    👈 💼, **FastAPI** 🚚 👆 ⏮️ 🧰 🏗 ⚫️.

🕐❔ 👥 ✍ 👐 `OAuth2PasswordBearer` 🎓 👥 🚶‍♀️ `tokenUrl` 🔢. 👉 🔢 🔌 📛 👈 👩‍💻 (🕸 🏃 👩‍💻 🖥) 🔜 ⚙️ 📨 `username` &amp; `password` ✔ 🤚 🤝.

```Python hl_lines="6"
{!../../../docs_src/security/tutorial001.py!}
```

!!! tip
    📥 `tokenUrl="token"` 🔗 ⚖ 📛 `token` 👈 👥 🚫 ✍. ⚫️ ⚖ 📛, ⚫️ 🌓 `./token`.

    ↩️ 👥 ⚙️ ⚖ 📛, 🚥 👆 🛠️ 🔎 `https://example.com/`, ⤴️ ⚫️ 🔜 🔗 `https://example.com/token`. ✋️ 🚥 👆 🛠️ 🔎 `https://example.com/api/v1/`, ⤴️ ⚫️ 🔜 🔗 `https://example.com/api/v1/token`.

    ⚙️ ⚖ 📛 ⚠ ⚒ 💭 👆 🈸 🚧 👷 🏧 ⚙️ 💼 💖 [⛅ 🗳](../../advanced/behind-a-proxy.md){.internal-link target=_blank}.

👉 🔢 🚫 ✍ 👈 🔗 / *➡ 🛠️*, ✋️ 📣 👈 📛 `/token` 🔜 1️⃣ 👈 👩‍💻 🔜 ⚙️ 🤚 🤝. 👈 ℹ ⚙️ 🗄, &amp; ⤴️ 🎓 🛠️ 🧾 ⚙️.

👥 🔜 🔜 ✍ ☑ ➡ 🛠️.

!!! info
    🚥 👆 📶 ⚠ "✍" 👆 💪 👎 👗 🔢 📛 `tokenUrl` ↩️ `token_url`.

    👈 ↩️ ⚫️ ⚙️ 🎏 📛 🗄 🔌. 👈 🚥 👆 💪 🔬 🌅 🔃 🙆 👫 💂‍♂ ⚖ 👆 💪 📁 &amp; 📋 ⚫️ 🔎 🌖 ℹ 🔃 ⚫️.

`oauth2_scheme` 🔢 👐 `OAuth2PasswordBearer`, ✋️ ⚫️ "🇧🇲".

⚫️ 💪 🤙:

```Python
oauth2_scheme(some, parameters)
```

, ⚫️ 💪 ⚙️ ⏮️ `Depends`.

### ⚙️ ⚫️

🔜 👆 💪 🚶‍♀️ 👈 `oauth2_scheme` 🔗 ⏮️ `Depends`.

```Python hl_lines="10"
{!../../../docs_src/security/tutorial001.py!}
```

👉 🔗 🔜 🚚 `str` 👈 🛠️ 🔢 `token` *➡ 🛠️ 🔢*.

**FastAPI** 🔜 💭 👈 ⚫️ 💪 ⚙️ 👉 🔗 🔬 "💂‍♂ ⚖" 🗄 🔗 (&amp; 🏧 🛠️ 🩺).

!!! info "📡 ℹ"
    **FastAPI** 🔜 💭 👈 ⚫️ 💪 ⚙️ 🎓 `OAuth2PasswordBearer` (📣 🔗) 🔬 💂‍♂ ⚖ 🗄 ↩️ ⚫️ 😖 ⚪️➡️ `fastapi.security.oauth2.OAuth2`, ❔ 🔄 😖 ⚪️➡️ `fastapi.security.base.SecurityBase`.

    🌐 💂‍♂ 🚙 👈 🛠️ ⏮️ 🗄 (&amp; 🏧 🛠️ 🩺) 😖 ⚪️➡️ `SecurityBase`, 👈 ❔ **FastAPI** 💪 💭 ❔ 🛠️ 👫 🗄.

## ⚫️❔ ⚫️ 🔨

⚫️ 🔜 🚶 &amp; 👀 📨 👈 `Authorization` 🎚, ✅ 🚥 💲 `Bearer ` ➕ 🤝, &amp; 🔜 📨 🤝 `str`.

🚥 ⚫️ 🚫 👀 `Authorization` 🎚, ⚖️ 💲 🚫 ✔️ `Bearer ` 🤝, ⚫️ 🔜 📨 ⏮️ 4️⃣0️⃣1️⃣ 👔 📟 ❌ (`UNAUTHORIZED`) 🔗.

👆 🚫 ✔️ ✅ 🚥 🤝 🔀 📨 ❌. 👆 💪 💭 👈 🚥 👆 🔢 🛠️, ⚫️ 🔜 ✔️ `str` 👈 🤝.

👆 💪 🔄 ⚫️ ⏪ 🎓 🩺:

<img src="/img/tutorial/security/image03.png">

👥 🚫 ✔ 🔬 🤝, ✋️ 👈 ▶️ ⏪.

## 🌃

, 3️⃣ ⚖️ 4️⃣ ➕ ⏸, 👆 ⏪ ✔️ 🐒 📨 💂‍♂.
