# LIB_CHECK_LAPACK
#------------------
# Checks for the lapack library and header files.
AC_DEFUN([LIB_CHECK_LAPACK],
[

    AC_MSG_CHECKING([for lapack])

    xsh_lapack_check_header="clapack.h"
    xsh_lapack_check_lib="libclapack.a"

    xsh_lapack_includes=""
    xsh_lapack_libraries=""

    AC_ARG_WITH(lapack,
                AC_HELP_STRING([--with-lapack],
                               [location where lapack is installed]),
                [
                    xsh_with_lapack_includes=$withval/include
                    xsh_with_lapack_libs=$withval/lib
                ])

    AC_ARG_WITH(lapack-includes,
                AC_HELP_STRING([--with-lapack-includes],
                               [location of the lapack header files]),
                xsh_with_lapack_includes=$withval)

    AC_ARG_WITH(lapack-libs,
                AC_HELP_STRING([--with-lapack-libs],
                               [location of the lapack library]),
                xsh_with_lapack_libs=$withval)

    AC_ARG_ENABLE(lapack-test,
                  AC_HELP_STRING([--disable-lapack-test],
                                 [disables checks for the lapack library and headers]),
                  xsh_enable_lapack_test=$enableval,
                  xsh_enable_lapack_test=yes)


    if test "x$xsh_enable_lapack_test" = xyes; then

        # Check for the lapack includes

        if test -z "$xsh_with_lapack_includes"; then
            xsh_lapack_incdirs="/opt/clapack/include /usr/local/include /usr/include"

            test -n "$CPLDIR" && xsh_lapack_incdirs="$CPLDIR/include \
                $xsh_lapack_incdirs"

            test -n "$LAPACKDIR" && xsh_lapack_incdirs="$LAPACKDIR/include \
                $xsh_lapack_incdirs"
        else
            xsh_lapack_incdirs="$xsh_with_lapack_includes"
        fi

        ESO_FIND_FILE($xsh_lapack_check_header, $xsh_lapack_incdirs,
                      xsh_lapack_includes)


        # Check for the lapack library

        if test -z "$xsh_with_lapack_libs"; then
            xsh_lapack_libdirs="/opt/clapack/lib /usr/local/lib /usr/lib"

            test -n "$CPLDIR" && xsh_lapack_libdirs="$CPLDIR/lib \
                $xsh_lapack_libdirs"

            test -n "$LAPACKDIR" && xsh_lapack_libdirs="$LAPACKDIR/lib \
                $xsh_lapack_libdirs"
        else
            xsh_lapack_libdirs="$xsh_with_lapack_libs"
        fi

        ESO_FIND_FILE($xsh_lapack_check_lib, $xsh_lapack_libdirs,
                      xsh_lapack_libraries)


        if test x"$xsh_lapack_includes" = xno || \
            test x"$xsh_lapack_libraries" = xno; then
            xsh_lapack_notfound=""

            if test x"$xsh_lapack_includes" = xno; then
                if test x"$xsh_lapack_libraries" = xno; then
                    xsh_lapack_notfound="(headers and libraries)"
                else
                    xsh_lapack_notfound="(headers)"
                fi
            else
                xsh_lapack_notfound="(libraries)"
            fi

            AC_MSG_ERROR([lapack $xsh_lapack_notfound was not found on your system. Please check!])
        else
            AC_MSG_RESULT([libraries $xsh_lapack_libraries, headers $xsh_lapack_includes])
        fi

        # Set up the symbols

        LAPACK_INCLUDES="-I$xsh_lapack_includes"
        LAPACK_LDFLAGS="-L$xsh_lapack_libraries"
        LDFLAGS="$LDFLAGS $LAPACK_LDFLAGS"
        CPPFLAGS="$CPPFLAGS $LAPACK_INCLUDES"
        AC_CHECK_LIB([clapack], [main], [LIBLAPACKC="-lclapack"], AC_MSG_ERROR([Library clapack not found]))
        LIBS="$LIBS $LIBLAPACKC"
        LIBLAPACK="$LIBLAPACKC"
    else
        AC_MSG_RESULT([disabled])
        AC_MSG_WARN([lapack checks have been disabled! This package may not build!])
        LAPACK_INCLUDES=""
        LAPACK_LDFLAGS=""
        LIBLAPACK=""
    fi

    # To be removed after CPL switched to lapack
    LAPACK_INCLUDES="$LAPACK_INCLUDES"
    LAPACK_LDFLAGS="$LAPACK_LDFLAGS"
    LIBLAPACK="$LIBLAPACK"

    AC_SUBST(LAPACK_INCLUDES)
    AC_SUBST(LAPACK_LDFLAGS)
    AC_SUBST(LIBLAPACK)

])


# XSH_SET_PREFIX(PREFIX)
#---------------------------
AC_DEFUN([XSH_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])


# XSH_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([XSH_SET_VERSION_INFO],
[
    xsh_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    xsh_major_version=`echo "$xsh_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    xsh_minor_version=`echo "$xsh_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    xsh_micro_version=`echo "$xsh_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$xsh_major_version"; then xsh_major_version=0
    fi

    if test -z "$xsh_minor_version"; then xsh_minor_version=0
    fi

    if test -z "$xsh_micro_version"; then xsh_micro_version=0
    fi

    XSH_VERSION="$xsh_version"
    XSH_MAJOR_VERSION=$xsh_major_version
    XSH_MINOR_VERSION=$xsh_minor_version
    XSH_MICRO_VERSION=$xsh_micro_version

    if test -z "$4"; then XSH_INTERFACE_AGE=0
    else XSH_INTERFACE_AGE="$4"
    fi

    XSH_BINARY_AGE=`expr 100 '*' $XSH_MINOR_VERSION + $XSH_MICRO_VERSION`
    XSH_BINARY_VERSION=`expr 10000 '*' $XSH_MAJOR_VERSION + \
                          $XSH_BINARY_AGE`

    AC_SUBST(XSH_VERSION)
    AC_SUBST(XSH_MAJOR_VERSION)
    AC_SUBST(XSH_MINOR_VERSION)
    AC_SUBST(XSH_MICRO_VERSION)
    AC_SUBST(XSH_INTERFACE_AGE)
    AC_SUBST(XSH_BINARY_VERSION)
    AC_SUBST(XSH_BINARY_AGE)

    AC_DEFINE_UNQUOTED(XSH_MAJOR_VERSION, $XSH_MAJOR_VERSION,
                       [XSH major version number])
    AC_DEFINE_UNQUOTED(XSH_MINOR_VERSION, $XSH_MINOR_VERSION,
                       [XSH minor version number])
    AC_DEFINE_UNQUOTED(XSH_MICRO_VERSION, $XSH_MICRO_VERSION,
                       [XSH micro version number])
    AC_DEFINE_UNQUOTED(XSH_INTERFACE_AGE, $XSH_INTERFACE_AGE,
                       [XSH interface age])
    AC_DEFINE_UNQUOTED(XSH_BINARY_VERSION, $XSH_BINARY_VERSION,
                       [XSH binary version number])
    AC_DEFINE_UNQUOTED(XSH_BINARY_AGE, $XSH_BINARY_AGE,
                       [XSH binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# XSH_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([XSH_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$privatelibdir"; then
        privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi
 
    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}'
    fi

    htmldir='${pipedocsdir}/html'

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$wkfextradir"; then
        wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
        wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    testpath=`cd $srcdir/xsh && pwd`/tests/data

    AC_SUBST(plugindir)
    AC_SUBST(privatelibdir)
    AC_SUBST(htmldir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)
    AC_SUBST(testsdir)

    # Define a preprocesor symbol for the plugin search paths

    AC_DEFINE_UNQUOTED(XSH_PLUGIN_DIR, "esopipes-plugins",
                       [Plugin directory tree prefix])

    eval plugin_dir="$plugindir"
    plugin_path=`eval echo $plugin_dir | \
                sed -e "s/\/${PACKAGE}-${VERSION}.*$//"`

    AC_DEFINE_UNQUOTED(XSH_PLUGIN_PATH, "$plugin_path",
                       [Absolute path to the plugin directory tree])

    AC_DEFINE_UNQUOTED(XSH_TEST_DATA_PATH,"$testpath",
                       [Absolute path to the tests data directory tree])
])


# XSH_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([XSH_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    XSH_INCLUDES='-I$(top_srcdir)/xsh'
    XSH_LDFLAGS='-L$(top_builddir)/xsh'

    # Library aliases
    LIBXSH='$(top_builddir)/xsh/libxsh.la'

    # Substitute the defined symbols

    AC_SUBST(XSH_INCLUDES)
    AC_SUBST(XSH_LDFLAGS)
    AC_SUBST(LIBXSH)

    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(XSH_INCLUDES) $(CPL_INCLUDES)  $(GSL_INCLUDES) $(EXTRA_INCLUDES) $(CFITSIO_INCLUDES)  $(LAPACK_INCLUDES)'
    all_ldflags='$(XSH_LDFLAGS) $(CPL_LDFLAGS) $(GSL_LDFLAGS) $(EXTRA_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
