///////////////////////////////////////////////////////////////////////////////
// Name:        pdfcodepagedata.inc
// Purpose:     Definition of codepage tables
// Author:      Ulrich Telle
// Created:     2009-06-24
// Copyright:   (c) Ulrich Telle
// Licence:     wxWindows licence
///////////////////////////////////////////////////////////////////////////////

/// \file pdfcodepagedata.inc Definition of codepage tables.

typedef struct _wxUniRangeDesc
{
  wxUint16 uni1;
  wxUint16 uni2;
}
wxUniRangeDesc;

// Codepage stdenc
static const wxUniRangeDesc gs_standard_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a5 },
  { 0x00a7, 0x00a8 },
  { 0x00aa, 0x00ab },
  { 0x00ad, 0x00ad },
  { 0x00af, 0x00af },
  { 0x00b4, 0x00b4 },
  { 0x00b6, 0x00b8 },
  { 0x00ba, 0x00bb },
  { 0x00bf, 0x00bf },
  { 0x00c6, 0x00c6 },
  { 0x00d8, 0x00d8 },
  { 0x00df, 0x00df },
  { 0x00e6, 0x00e6 },
  { 0x00f8, 0x00f8 },
  { 0x0131, 0x0131 },
  { 0x0141, 0x0142 },
  { 0x0152, 0x0153 },
  { 0x0192, 0x0192 },
  { 0x02c6, 0x02c7 },
  { 0x02c9, 0x02c9 },
  { 0x02d8, 0x02dd },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x2044, 0x2044 },
  { 0x2215, 0x2215 },
  { 0x2219, 0x2219 },
  { 0xfb01, 0xfb02 },
  { 0xffff, 0xffff }
};

static const int gs_standard_tableSize = 34;

// Codepage macroman
static const wxUniRangeDesc gs_macroman_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a5 },
  { 0x00a7, 0x00ac },
  { 0x00ae, 0x00b1 },
  { 0x00b4, 0x00b8 },
  { 0x00ba, 0x00bb },
  { 0x00bf, 0x00cf },
  { 0x00d1, 0x00d6 },
  { 0x00d8, 0x00dc },
  { 0x00df, 0x00ef },
  { 0x00f1, 0x00fc },
  { 0x00ff, 0x00ff },
  { 0x0131, 0x0131 },
  { 0x0152, 0x0153 },
  { 0x0178, 0x0178 },
  { 0x0192, 0x0192 },
  { 0x02c6, 0x02c7 },
  { 0x02d8, 0x02dd },
  { 0x03c0, 0x03c0 },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x2044, 0x2044 },
  { 0x2122, 0x2122 },
  { 0x2126, 0x2126 },
  { 0x2202, 0x2202 },
  { 0x2206, 0x2206 },
  { 0x220f, 0x220f },
  { 0x2211, 0x2211 },
  { 0x221a, 0x221a },
  { 0x221e, 0x221e },
  { 0x222b, 0x222b },
  { 0x2248, 0x2248 },
  { 0x2260, 0x2260 },
  { 0x2264, 0x2265 },
  { 0x25ca, 0x25ca },
  { 0xfb01, 0xfb02 },
  { 0xffff, 0xffff }
};

static const int gs_macroman_tableSize = 42;

// Codepage symbol
static const wxUniRangeDesc gs_symbol_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x00ac, 0x00ac },
  { 0x00b0, 0x00b1 },
  { 0x00b5, 0x00b5 },
  { 0x00d7, 0x00d7 },
  { 0x00f7, 0x00f7 },
  { 0x0192, 0x0192 },
  { 0x0391, 0x03a1 },
  { 0x03a3, 0x03a9 },
  { 0x03b1, 0x03c9 },
  { 0x03d1, 0x03d2 },
  { 0x03d5, 0x03d6 },
  { 0x2022, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2032, 0x2033 },
  { 0x2044, 0x2044 },
  { 0x20ac, 0x20ac },
  { 0x2111, 0x2111 },
  { 0x2118, 0x2118 },
  { 0x211c, 0x211c },
  { 0x2126, 0x2126 },
  { 0x2135, 0x2135 },
  { 0x2190, 0x2194 },
  { 0x21b5, 0x21b5 },
  { 0x21d0, 0x21d4 },
  { 0x2200, 0x2200 },
  { 0x2202, 0x2203 },
  { 0x2205, 0x2209 },
  { 0x220b, 0x220b },
  { 0x220f, 0x220f },
  { 0x2211, 0x2212 },
  { 0x2215, 0x2215 },
  { 0x2217, 0x2217 },
  { 0x221a, 0x221a },
  { 0x221d, 0x221e },
  { 0x2220, 0x2220 },
  { 0x2227, 0x222b },
  { 0x2234, 0x2234 },
  { 0x223c, 0x223c },
  { 0x2245, 0x2245 },
  { 0x2248, 0x2248 },
  { 0x2260, 0x2261 },
  { 0x2264, 0x2265 },
  { 0x2282, 0x2284 },
  { 0x2286, 0x2287 },
  { 0x2295, 0x2295 },
  { 0x2297, 0x2297 },
  { 0x22a5, 0x22a5 },
  { 0x22c5, 0x22c5 },
  { 0x2320, 0x2321 },
  { 0x2329, 0x232a },
  { 0x25ca, 0x25ca },
  { 0x2660, 0x2660 },
  { 0x2663, 0x2663 },
  { 0x2665, 0x2666 },
  { 0xf6d9, 0xf6db },
  { 0xf8e5, 0xf8fe },
  { 0xffff, 0xffff }
};

static const int gs_symbol_tableSize = 59;

// Codepage zdingbat2
static const wxUniRangeDesc gs_zdb_table[] =
{
  { 0x0000, 0x00ff },
  { 0x2192, 0x2192 },
  { 0x2194, 0x2195 },
  { 0x2460, 0x2469 },
  { 0x25a0, 0x25a0 },
  { 0x25b2, 0x25b2 },
  { 0x25bc, 0x25bc },
  { 0x25c6, 0x25c6 },
  { 0x25cf, 0x25cf },
  { 0x25d7, 0x25d7 },
  { 0x2605, 0x2605 },
  { 0x260e, 0x260e },
  { 0x261b, 0x261b },
  { 0x261e, 0x261e },
  { 0x2660, 0x2660 },
  { 0x2663, 0x2663 },
  { 0x2665, 0x2666 },
  { 0x2701, 0x2704 },
  { 0x2706, 0x2709 },
  { 0x270c, 0x2727 },
  { 0x2729, 0x274b },
  { 0x274d, 0x274d },
  { 0x274f, 0x2752 },
  { 0x2756, 0x2756 },
  { 0x2758, 0x275e },
  { 0x2761, 0x2794 },
  { 0x2798, 0x27af },
  { 0x27b1, 0x27be },
  { 0xffff, 0xffff }
};

static const int gs_zdb_tableSize = 29;

// Codepage 8859_1
static const wxUniRangeDesc gs_8859_1_table[] =
{
  { 0x0000, 0x00ff },
  { 0xffff, 0xffff }
};

static const int gs_8859_1_tableSize = 2;

// Codepage 8859_2
static const wxUniRangeDesc gs_8859_2_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a4, 0x00a4 },
  { 0x00a7, 0x00a8 },
  { 0x00ad, 0x00ad },
  { 0x00b0, 0x00b0 },
  { 0x00b4, 0x00b4 },
  { 0x00b8, 0x00b8 },
  { 0x00c1, 0x00c2 },
  { 0x00c4, 0x00c4 },
  { 0x00c7, 0x00c7 },
  { 0x00c9, 0x00c9 },
  { 0x00cb, 0x00cb },
  { 0x00cd, 0x00ce },
  { 0x00d3, 0x00d4 },
  { 0x00d6, 0x00d7 },
  { 0x00da, 0x00da },
  { 0x00dc, 0x00dd },
  { 0x00df, 0x00df },
  { 0x00e1, 0x00e2 },
  { 0x00e4, 0x00e4 },
  { 0x00e7, 0x00e7 },
  { 0x00e9, 0x00e9 },
  { 0x00eb, 0x00eb },
  { 0x00ed, 0x00ee },
  { 0x00f3, 0x00f4 },
  { 0x00f6, 0x00f7 },
  { 0x00fa, 0x00fa },
  { 0x00fc, 0x00fd },
  { 0x0102, 0x0107 },
  { 0x010c, 0x0111 },
  { 0x0118, 0x011b },
  { 0x0139, 0x013a },
  { 0x013d, 0x013e },
  { 0x0141, 0x0144 },
  { 0x0147, 0x0148 },
  { 0x0150, 0x0151 },
  { 0x0154, 0x0155 },
  { 0x0158, 0x015b },
  { 0x015e, 0x0165 },
  { 0x016e, 0x0171 },
  { 0x0179, 0x017e },
  { 0x02c7, 0x02c7 },
  { 0x02d8, 0x02d9 },
  { 0x02db, 0x02db },
  { 0x02dd, 0x02dd },
  { 0xffff, 0xffff }
};

static const int gs_8859_2_tableSize = 46;

// Codepage 8859_3
static const wxUniRangeDesc gs_8859_3_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a3, 0x00a4 },
  { 0x00a7, 0x00a8 },
  { 0x00ad, 0x00ad },
  { 0x00b0, 0x00b0 },
  { 0x00b2, 0x00b5 },
  { 0x00b7, 0x00b8 },
  { 0x00bd, 0x00bd },
  { 0x00c0, 0x00c2 },
  { 0x00c4, 0x00c4 },
  { 0x00c7, 0x00cf },
  { 0x00d1, 0x00d4 },
  { 0x00d6, 0x00d7 },
  { 0x00d9, 0x00dc },
  { 0x00df, 0x00e2 },
  { 0x00e4, 0x00e4 },
  { 0x00e7, 0x00ef },
  { 0x00f1, 0x00f4 },
  { 0x00f6, 0x00f7 },
  { 0x00f9, 0x00fc },
  { 0x0108, 0x010b },
  { 0x011c, 0x0121 },
  { 0x0124, 0x0127 },
  { 0x0130, 0x0131 },
  { 0x0134, 0x0135 },
  { 0x015c, 0x015f },
  { 0x016c, 0x016d },
  { 0x017b, 0x017c },
  { 0x02d8, 0x02d9 },
  { 0xffff, 0xffff }
};

static const int gs_8859_3_tableSize = 30;

// Codepage 8859_4
static const wxUniRangeDesc gs_8859_4_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a4, 0x00a4 },
  { 0x00a7, 0x00a8 },
  { 0x00ad, 0x00ad },
  { 0x00af, 0x00b0 },
  { 0x00b4, 0x00b4 },
  { 0x00b8, 0x00b8 },
  { 0x00c1, 0x00c6 },
  { 0x00c9, 0x00c9 },
  { 0x00cb, 0x00cb },
  { 0x00cd, 0x00ce },
  { 0x00d4, 0x00d8 },
  { 0x00da, 0x00dc },
  { 0x00df, 0x00df },
  { 0x00e1, 0x00e6 },
  { 0x00e9, 0x00e9 },
  { 0x00eb, 0x00eb },
  { 0x00ed, 0x00ee },
  { 0x00f4, 0x00f8 },
  { 0x00fa, 0x00fc },
  { 0x0100, 0x0101 },
  { 0x0104, 0x0105 },
  { 0x010c, 0x010d },
  { 0x0110, 0x0113 },
  { 0x0116, 0x0119 },
  { 0x0122, 0x0123 },
  { 0x0128, 0x012b },
  { 0x012e, 0x012f },
  { 0x0136, 0x0138 },
  { 0x013b, 0x013c },
  { 0x0145, 0x0146 },
  { 0x014a, 0x014d },
  { 0x0156, 0x0157 },
  { 0x0160, 0x0161 },
  { 0x0166, 0x016b },
  { 0x0172, 0x0173 },
  { 0x017d, 0x017e },
  { 0x02c7, 0x02c7 },
  { 0x02d9, 0x02d9 },
  { 0x02db, 0x02db },
  { 0xffff, 0xffff }
};

static const int gs_8859_4_tableSize = 41;

// Codepage 8859_5
static const wxUniRangeDesc gs_8859_5_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a7, 0x00a7 },
  { 0x00ad, 0x00ad },
  { 0x0401, 0x040c },
  { 0x040e, 0x044f },
  { 0x0451, 0x045c },
  { 0x045e, 0x045f },
  { 0x2116, 0x2116 },
  { 0xffff, 0xffff }
};

static const int gs_8859_5_tableSize = 9;

// Codepage 8859_6
static const wxUniRangeDesc gs_8859_6_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a4, 0x00a4 },
  { 0x00ad, 0x00ad },
  { 0x060c, 0x060c },
  { 0x061b, 0x061b },
  { 0x061f, 0x061f },
  { 0x0621, 0x063a },
  { 0x0640, 0x0652 },
  { 0xffff, 0xffff }
};

static const int gs_8859_6_tableSize = 9;

// Codepage 8859_7
static const wxUniRangeDesc gs_8859_7_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a3, 0x00a3 },
  { 0x00a6, 0x00a9 },
  { 0x00ab, 0x00ad },
  { 0x00b0, 0x00b3 },
  { 0x00b7, 0x00b7 },
  { 0x00bb, 0x00bb },
  { 0x00bd, 0x00bd },
  { 0x037a, 0x037a },
  { 0x0384, 0x0386 },
  { 0x0388, 0x038a },
  { 0x038c, 0x038c },
  { 0x038e, 0x03a1 },
  { 0x03a3, 0x03ce },
  { 0x2015, 0x2015 },
  { 0x2018, 0x2019 },
  { 0x20ac, 0x20ac },
  { 0x20af, 0x20af },
  { 0xffff, 0xffff }
};

static const int gs_8859_7_tableSize = 19;

// Codepage 8859_8
static const wxUniRangeDesc gs_8859_8_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a2, 0x00a9 },
  { 0x00ab, 0x00b9 },
  { 0x00bb, 0x00be },
  { 0x00d7, 0x00d7 },
  { 0x00f7, 0x00f7 },
  { 0x05d0, 0x05ea },
  { 0x200e, 0x200f },
  { 0x2017, 0x2017 },
  { 0xffff, 0xffff }
};

static const int gs_8859_8_tableSize = 10;

// Codepage 8859_9
static const wxUniRangeDesc gs_8859_9_table[] =
{
  { 0x0000, 0x00cf },
  { 0x00d1, 0x00dc },
  { 0x00df, 0x00ef },
  { 0x00f1, 0x00fc },
  { 0x00ff, 0x00ff },
  { 0x011e, 0x011f },
  { 0x0130, 0x0131 },
  { 0x015e, 0x015f },
  { 0xffff, 0xffff }
};

static const int gs_8859_9_tableSize = 9;

// Codepage 8859_10
static const wxUniRangeDesc gs_8859_10_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a7, 0x00a7 },
  { 0x00ad, 0x00ad },
  { 0x00b0, 0x00b0 },
  { 0x00b7, 0x00b7 },
  { 0x00c1, 0x00c6 },
  { 0x00c9, 0x00c9 },
  { 0x00cb, 0x00cb },
  { 0x00cd, 0x00d0 },
  { 0x00d3, 0x00d6 },
  { 0x00d8, 0x00d8 },
  { 0x00da, 0x00df },
  { 0x00e1, 0x00e6 },
  { 0x00e9, 0x00e9 },
  { 0x00eb, 0x00eb },
  { 0x00ed, 0x00f0 },
  { 0x00f3, 0x00f6 },
  { 0x00f8, 0x00f8 },
  { 0x00fa, 0x00fe },
  { 0x0100, 0x0101 },
  { 0x0104, 0x0105 },
  { 0x010c, 0x010d },
  { 0x0110, 0x0113 },
  { 0x0116, 0x0119 },
  { 0x0122, 0x0123 },
  { 0x0128, 0x012b },
  { 0x012e, 0x012f },
  { 0x0136, 0x0138 },
  { 0x013b, 0x013c },
  { 0x0145, 0x0146 },
  { 0x014a, 0x014d },
  { 0x0160, 0x0161 },
  { 0x0166, 0x016b },
  { 0x0172, 0x0173 },
  { 0x017d, 0x017e },
  { 0x2015, 0x2015 },
  { 0xffff, 0xffff }
};

static const int gs_8859_10_tableSize = 37;

// Codepage 8859_11
static const wxUniRangeDesc gs_8859_11_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x0e01, 0x0e3a },
  { 0x0e3f, 0x0e5b },
  { 0xffff, 0xffff }
};

static const int gs_8859_11_tableSize = 4;

// Codepage 8859_13
static const wxUniRangeDesc gs_8859_13_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a2, 0x00a4 },
  { 0x00a6, 0x00a7 },
  { 0x00a9, 0x00a9 },
  { 0x00ab, 0x00ae },
  { 0x00b0, 0x00b3 },
  { 0x00b5, 0x00b7 },
  { 0x00b9, 0x00b9 },
  { 0x00bb, 0x00be },
  { 0x00c4, 0x00c6 },
  { 0x00c9, 0x00c9 },
  { 0x00d3, 0x00d3 },
  { 0x00d5, 0x00d8 },
  { 0x00dc, 0x00dc },
  { 0x00df, 0x00df },
  { 0x00e4, 0x00e6 },
  { 0x00e9, 0x00e9 },
  { 0x00f3, 0x00f3 },
  { 0x00f5, 0x00f8 },
  { 0x00fc, 0x00fc },
  { 0x0100, 0x0101 },
  { 0x0104, 0x0107 },
  { 0x010c, 0x010d },
  { 0x0112, 0x0113 },
  { 0x0116, 0x0119 },
  { 0x0122, 0x0123 },
  { 0x012a, 0x012b },
  { 0x012e, 0x012f },
  { 0x0136, 0x0137 },
  { 0x013b, 0x013c },
  { 0x0141, 0x0146 },
  { 0x014c, 0x014d },
  { 0x0156, 0x0157 },
  { 0x015a, 0x015b },
  { 0x0160, 0x0161 },
  { 0x016a, 0x016b },
  { 0x0172, 0x0173 },
  { 0x0179, 0x017e },
  { 0x2019, 0x2019 },
  { 0x201c, 0x201e },
  { 0xffff, 0xffff }
};

static const int gs_8859_13_tableSize = 41;

// Codepage 8859_14
static const wxUniRangeDesc gs_8859_14_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a3, 0x00a3 },
  { 0x00a7, 0x00a7 },
  { 0x00a9, 0x00a9 },
  { 0x00ad, 0x00ae },
  { 0x00b6, 0x00b6 },
  { 0x00c0, 0x00cf },
  { 0x00d1, 0x00d6 },
  { 0x00d8, 0x00dd },
  { 0x00df, 0x00ef },
  { 0x00f1, 0x00f6 },
  { 0x00f8, 0x00fd },
  { 0x00ff, 0x00ff },
  { 0x010a, 0x010b },
  { 0x0120, 0x0121 },
  { 0x0174, 0x0178 },
  { 0x1e02, 0x1e03 },
  { 0x1e0a, 0x1e0b },
  { 0x1e1e, 0x1e1f },
  { 0x1e40, 0x1e41 },
  { 0x1e56, 0x1e57 },
  { 0x1e60, 0x1e61 },
  { 0x1e6a, 0x1e6b },
  { 0x1e80, 0x1e85 },
  { 0x1ef2, 0x1ef3 },
  { 0xffff, 0xffff }
};

static const int gs_8859_14_tableSize = 26;

// Codepage 8859_15
static const wxUniRangeDesc gs_8859_15_table[] =
{
  { 0x0000, 0x00a3 },
  { 0x00a5, 0x00a5 },
  { 0x00a7, 0x00a7 },
  { 0x00a9, 0x00b3 },
  { 0x00b5, 0x00b7 },
  { 0x00b9, 0x00bb },
  { 0x00bf, 0x00ff },
  { 0x0152, 0x0153 },
  { 0x0160, 0x0161 },
  { 0x0178, 0x0178 },
  { 0x017d, 0x017e },
  { 0x20ac, 0x20ac },
  { 0xffff, 0xffff }
};

static const int gs_8859_15_tableSize = 13;

// Codepage 8859_16
static const wxUniRangeDesc gs_8859_16_table[] =
{
  { 0x0000, 0x00a0 },
  { 0x00a7, 0x00a7 },
  { 0x00a9, 0x00a9 },
  { 0x00ab, 0x00ab },
  { 0x00ad, 0x00ad },
  { 0x00b0, 0x00b1 },
  { 0x00b6, 0x00b7 },
  { 0x00bb, 0x00bb },
  { 0x00c0, 0x00c2 },
  { 0x00c4, 0x00c4 },
  { 0x00c6, 0x00cf },
  { 0x00d2, 0x00d4 },
  { 0x00d6, 0x00d6 },
  { 0x00d9, 0x00dc },
  { 0x00df, 0x00e2 },
  { 0x00e4, 0x00e4 },
  { 0x00e6, 0x00ef },
  { 0x00f2, 0x00f4 },
  { 0x00f6, 0x00f6 },
  { 0x00f9, 0x00fc },
  { 0x00ff, 0x00ff },
  { 0x0102, 0x0107 },
  { 0x010c, 0x010d },
  { 0x0110, 0x0111 },
  { 0x0118, 0x0119 },
  { 0x0141, 0x0144 },
  { 0x0150, 0x0153 },
  { 0x015a, 0x015b },
  { 0x0160, 0x0161 },
  { 0x0170, 0x0171 },
  { 0x0178, 0x017e },
  { 0x0218, 0x021b },
  { 0x201d, 0x201e },
  { 0x20ac, 0x20ac },
  { 0xffff, 0xffff }
};

static const int gs_8859_16_tableSize = 35;

// Codepage cp1250
static const wxUniRangeDesc gs_cp1250_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x00a4, 0x00a4 },
  { 0x00a6, 0x00a9 },
  { 0x00ab, 0x00ae },
  { 0x00b0, 0x00b1 },
  { 0x00b4, 0x00b8 },
  { 0x00bb, 0x00bb },
  { 0x00c1, 0x00c2 },
  { 0x00c4, 0x00c4 },
  { 0x00c7, 0x00c7 },
  { 0x00c9, 0x00c9 },
  { 0x00cb, 0x00cb },
  { 0x00cd, 0x00ce },
  { 0x00d3, 0x00d4 },
  { 0x00d6, 0x00d7 },
  { 0x00da, 0x00da },
  { 0x00dc, 0x00dd },
  { 0x00df, 0x00df },
  { 0x00e1, 0x00e2 },
  { 0x00e4, 0x00e4 },
  { 0x00e7, 0x00e7 },
  { 0x00e9, 0x00e9 },
  { 0x00eb, 0x00eb },
  { 0x00ed, 0x00ee },
  { 0x00f3, 0x00f4 },
  { 0x00f6, 0x00f7 },
  { 0x00fa, 0x00fa },
  { 0x00fc, 0x00fd },
  { 0x0102, 0x0107 },
  { 0x010c, 0x0111 },
  { 0x0118, 0x011b },
  { 0x0139, 0x013a },
  { 0x013d, 0x013e },
  { 0x0141, 0x0144 },
  { 0x0147, 0x0148 },
  { 0x0150, 0x0151 },
  { 0x0154, 0x0155 },
  { 0x0158, 0x015b },
  { 0x015e, 0x0165 },
  { 0x016e, 0x0171 },
  { 0x0179, 0x017e },
  { 0x02c7, 0x02c7 },
  { 0x02d8, 0x02d9 },
  { 0x02db, 0x02db },
  { 0x02dd, 0x02dd },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20ac, 0x20ac },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1250_tableSize = 56;

// Codepage cp1251
static const wxUniRangeDesc gs_cp1251_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x00a4, 0x00a4 },
  { 0x00a6, 0x00a7 },
  { 0x00a9, 0x00a9 },
  { 0x00ab, 0x00ae },
  { 0x00b0, 0x00b1 },
  { 0x00b5, 0x00b7 },
  { 0x00bb, 0x00bb },
  { 0x0401, 0x040c },
  { 0x040e, 0x044f },
  { 0x0451, 0x045c },
  { 0x045e, 0x045f },
  { 0x0490, 0x0491 },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20ac, 0x20ac },
  { 0x2116, 0x2116 },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1251_tableSize = 25;

// Codepage cp1252
static const wxUniRangeDesc gs_cp1252_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00ff },
  { 0x0152, 0x0153 },
  { 0x0160, 0x0161 },
  { 0x0178, 0x0178 },
  { 0x017d, 0x017e },
  { 0x0192, 0x0192 },
  { 0x02c6, 0x02c6 },
  { 0x02dc, 0x02dc },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20ac, 0x20ac },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1252_tableSize = 19;

// Codepage cp1253
static const wxUniRangeDesc gs_cp1253_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x00a3, 0x00a9 },
  { 0x00ab, 0x00ae },
  { 0x00b0, 0x00b3 },
  { 0x00b5, 0x00b7 },
  { 0x00bb, 0x00bb },
  { 0x00bd, 0x00bd },
  { 0x0192, 0x0192 },
  { 0x0384, 0x0386 },
  { 0x0388, 0x038a },
  { 0x038c, 0x038c },
  { 0x038e, 0x03a1 },
  { 0x03a3, 0x03ce },
  { 0x2013, 0x2015 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20ac, 0x20ac },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1253_tableSize = 24;

// Codepage cp1254
static const wxUniRangeDesc gs_cp1254_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00cf },
  { 0x00d1, 0x00dc },
  { 0x00df, 0x00ef },
  { 0x00f1, 0x00fc },
  { 0x00ff, 0x00ff },
  { 0x011e, 0x011f },
  { 0x0130, 0x0131 },
  { 0x0152, 0x0153 },
  { 0x015e, 0x0161 },
  { 0x0178, 0x0178 },
  { 0x0192, 0x0192 },
  { 0x02c6, 0x02c6 },
  { 0x02dc, 0x02dc },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20ac, 0x20ac },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1254_tableSize = 24;

// Codepage cp1255
static const wxUniRangeDesc gs_cp1255_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a3 },
  { 0x00a5, 0x00a9 },
  { 0x00ab, 0x00b9 },
  { 0x00bb, 0x00bf },
  { 0x00d7, 0x00d7 },
  { 0x00f7, 0x00f7 },
  { 0x0192, 0x0192 },
  { 0x02c6, 0x02c6 },
  { 0x02dc, 0x02dc },
  { 0x05b0, 0x05b9 },
  { 0x05bb, 0x05c3 },
  { 0x05d0, 0x05ea },
  { 0x05f0, 0x05f4 },
  { 0x200e, 0x200f },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20aa, 0x20aa },
  { 0x20ac, 0x20ac },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1255_tableSize = 26;

// Codepage cp1256
static const wxUniRangeDesc gs_cp1256_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x00a2, 0x00a9 },
  { 0x00ab, 0x00b9 },
  { 0x00bb, 0x00be },
  { 0x00d7, 0x00d7 },
  { 0x00e0, 0x00e0 },
  { 0x00e2, 0x00e2 },
  { 0x00e7, 0x00eb },
  { 0x00ee, 0x00ef },
  { 0x00f4, 0x00f4 },
  { 0x00f7, 0x00f7 },
  { 0x00f9, 0x00f9 },
  { 0x00fb, 0x00fc },
  { 0x0152, 0x0153 },
  { 0x0192, 0x0192 },
  { 0x02c6, 0x02c6 },
  { 0x060c, 0x060c },
  { 0x061b, 0x061b },
  { 0x061f, 0x061f },
  { 0x0621, 0x063a },
  { 0x0640, 0x0652 },
  { 0x0679, 0x0679 },
  { 0x067e, 0x067e },
  { 0x0686, 0x0686 },
  { 0x0688, 0x0688 },
  { 0x0691, 0x0691 },
  { 0x0698, 0x0698 },
  { 0x06a9, 0x06a9 },
  { 0x06af, 0x06af },
  { 0x06ba, 0x06ba },
  { 0x06be, 0x06be },
  { 0x06c1, 0x06c1 },
  { 0x06d2, 0x06d2 },
  { 0x200c, 0x200f },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20ac, 0x20ac },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1256_tableSize = 45;

// Codepage cp1257
static const wxUniRangeDesc gs_cp1257_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x00a2, 0x00a4 },
  { 0x00a6, 0x00a9 },
  { 0x00ab, 0x00b9 },
  { 0x00bb, 0x00be },
  { 0x00c4, 0x00c6 },
  { 0x00c9, 0x00c9 },
  { 0x00d3, 0x00d3 },
  { 0x00d5, 0x00d8 },
  { 0x00dc, 0x00dc },
  { 0x00df, 0x00df },
  { 0x00e4, 0x00e6 },
  { 0x00e9, 0x00e9 },
  { 0x00f3, 0x00f3 },
  { 0x00f5, 0x00f8 },
  { 0x00fc, 0x00fc },
  { 0x0100, 0x0101 },
  { 0x0104, 0x0107 },
  { 0x010c, 0x010d },
  { 0x0112, 0x0113 },
  { 0x0116, 0x0119 },
  { 0x0122, 0x0123 },
  { 0x012a, 0x012b },
  { 0x012e, 0x012f },
  { 0x0136, 0x0137 },
  { 0x013b, 0x013c },
  { 0x0141, 0x0146 },
  { 0x014c, 0x014d },
  { 0x0156, 0x0157 },
  { 0x015a, 0x015b },
  { 0x0160, 0x0161 },
  { 0x016a, 0x016b },
  { 0x0172, 0x0173 },
  { 0x0179, 0x017e },
  { 0x02c7, 0x02c7 },
  { 0x02d9, 0x02d9 },
  { 0x02db, 0x02db },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20ac, 0x20ac },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1257_tableSize = 48;

// Codepage cp1258
static const wxUniRangeDesc gs_cp1258_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00c2 },
  { 0x00c4, 0x00cb },
  { 0x00cd, 0x00cf },
  { 0x00d1, 0x00d1 },
  { 0x00d3, 0x00d4 },
  { 0x00d6, 0x00dc },
  { 0x00df, 0x00e2 },
  { 0x00e4, 0x00eb },
  { 0x00ed, 0x00ef },
  { 0x00f1, 0x00f1 },
  { 0x00f3, 0x00f4 },
  { 0x00f6, 0x00fc },
  { 0x00ff, 0x00ff },
  { 0x0102, 0x0103 },
  { 0x0110, 0x0111 },
  { 0x0152, 0x0153 },
  { 0x0178, 0x0178 },
  { 0x0192, 0x0192 },
  { 0x01a0, 0x01a1 },
  { 0x01af, 0x01b0 },
  { 0x02c6, 0x02c6 },
  { 0x02dc, 0x02dc },
  { 0x0300, 0x0301 },
  { 0x0303, 0x0303 },
  { 0x0309, 0x0309 },
  { 0x0323, 0x0323 },
  { 0x2013, 0x2014 },
  { 0x2018, 0x201a },
  { 0x201c, 0x201e },
  { 0x2020, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x2030, 0x2030 },
  { 0x2039, 0x203a },
  { 0x20ab, 0x20ac },
  { 0x2122, 0x2122 },
  { 0xffff, 0xffff }
};

static const int gs_cp1258_tableSize = 37;

// Codepage cp874
static const wxUniRangeDesc gs_cp874_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x0e01, 0x0e3a },
  { 0x0e3f, 0x0e5b },
  { 0x2013, 0x2014 },
  { 0x2018, 0x2019 },
  { 0x201c, 0x201d },
  { 0x2022, 0x2022 },
  { 0x2026, 0x2026 },
  { 0x20ac, 0x20ac },
  { 0xffff, 0xffff }
};

static const int gs_cp874_tableSize = 11;

// Codepage koi8_r
static const wxUniRangeDesc gs_koi8_r_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x00a9, 0x00a9 },
  { 0x00b0, 0x00b0 },
  { 0x00b2, 0x00b2 },
  { 0x00b7, 0x00b7 },
  { 0x00f7, 0x00f7 },
  { 0x0401, 0x0401 },
  { 0x0410, 0x044f },
  { 0x0451, 0x0451 },
  { 0x2219, 0x221a },
  { 0x2248, 0x2248 },
  { 0x2264, 0x2265 },
  { 0x2320, 0x2321 },
  { 0x2500, 0x2500 },
  { 0x2502, 0x2502 },
  { 0x250c, 0x250c },
  { 0x2510, 0x2510 },
  { 0x2514, 0x2514 },
  { 0x2518, 0x2518 },
  { 0x251c, 0x251c },
  { 0x2524, 0x2524 },
  { 0x252c, 0x252c },
  { 0x2534, 0x2534 },
  { 0x253c, 0x253c },
  { 0x2550, 0x256c },
  { 0x2580, 0x2580 },
  { 0x2584, 0x2584 },
  { 0x2588, 0x2588 },
  { 0x258c, 0x258c },
  { 0x2590, 0x2593 },
  { 0x25a0, 0x25a0 },
  { 0xffff, 0xffff }
};

static const int gs_koi8_r_tableSize = 33;

// Codepage koi8_u
static const wxUniRangeDesc gs_koi8_u_table[] =
{
  { 0x0000, 0x007f },
  { 0x00a0, 0x00a0 },
  { 0x00a9, 0x00a9 },
  { 0x00b0, 0x00b0 },
  { 0x00b2, 0x00b2 },
  { 0x00b7, 0x00b7 },
  { 0x00f7, 0x00f7 },
  { 0x0401, 0x0401 },
  { 0x0404, 0x0404 },
  { 0x0406, 0x0407 },
  { 0x0410, 0x044f },
  { 0x0451, 0x0451 },
  { 0x0454, 0x0454 },
  { 0x0456, 0x0457 },
  { 0x0490, 0x0491 },
  { 0x2219, 0x221a },
  { 0x2248, 0x2248 },
  { 0x2264, 0x2265 },
  { 0x2320, 0x2321 },
  { 0x2500, 0x2500 },
  { 0x2502, 0x2502 },
  { 0x250c, 0x250c },
  { 0x2510, 0x2510 },
  { 0x2514, 0x2514 },
  { 0x2518, 0x2518 },
  { 0x251c, 0x251c },
  { 0x2524, 0x2524 },
  { 0x252c, 0x252c },
  { 0x2534, 0x2534 },
  { 0x253c, 0x253c },
  { 0x2550, 0x2552 },
  { 0x2554, 0x2554 },
  { 0x2557, 0x255b },
  { 0x255d, 0x2561 },
  { 0x2563, 0x2563 },
  { 0x2566, 0x256a },
  { 0x256c, 0x256c },
  { 0x2580, 0x2580 },
  { 0x2584, 0x2584 },
  { 0x2588, 0x2588 },
  { 0x258c, 0x258c },
  { 0x2590, 0x2593 },
  { 0x25a0, 0x25a0 },
  { 0xffff, 0xffff }
};

static const int gs_koi8_u_tableSize = 44;

// Codepage cp932
static const unsigned char gs_cp932_table[] =
{
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0xca, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7f, 0xff, 0xdf, 0xc0, 0x7f, 0xff, 0xdf, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x40, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x84, 0xcc, 0xc6, 0x00, 0xb0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x02, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0xff, 0xc0,
  0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xb1, 0x90, 0x40, 0x27, 0x85, 0xfa, 0x0c, 0x04, 0x00, 0x00, 0x20, 0x00, 0xc3, 0x30, 0x00, 0x00,
  0x33, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xf0, 0x09, 0x99, 0x9c, 0x9c, 0x99, 0x99, 0x99, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x30, 0x0c, 0x03, 0x13, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xf7, 0xff, 0xfc, 0x05, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf0, 0x1e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1e,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x04, 0x08, 0x80, 0x33, 0x10, 0x02, 0x10, 0x00, 0x64, 0x41, 0x00, 0x00, 0x00, 0x00, 0x1e,
  0x00, 0x03, 0x00, 0x0e, 0x40, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xd1, 0xf6, 0xcf, 0xc2, 0x42, 0xa4, 0x62, 0xd9, 0x34, 0x17, 0x07, 0xc7, 0x20, 0x00, 0x50, 0x02,
  0xa6, 0xfa, 0x6c, 0xdb, 0xee, 0x9e, 0x92, 0x20, 0xeb, 0x37, 0x0f, 0xc7, 0x5c, 0x06, 0xa3, 0x18,
  0xd0, 0x67, 0xc0, 0x2c, 0x00, 0x01, 0x8a, 0xec, 0x13, 0x07, 0xd7, 0x7e, 0x00, 0x41, 0x96, 0x19,
  0x12, 0xb5, 0x6a, 0xb4, 0xc0, 0x17, 0x06, 0x01, 0x38, 0x66, 0xc9, 0xb5, 0x5c, 0x03, 0x16, 0xa3,
  0x06, 0x55, 0x6a, 0x63, 0x7e, 0xfc, 0x02, 0x40, 0xb3, 0xc1, 0x86, 0x28, 0x04, 0x08, 0xae, 0x84,
  0x84, 0x04, 0x48, 0xe0, 0x00, 0x0c, 0x3d, 0x02, 0x24, 0x65, 0x46, 0xa2, 0x15, 0x06, 0x0c, 0x50,
  0xe8, 0x40, 0x2e, 0xa1, 0x40, 0x20, 0x21, 0x39, 0xdf, 0xfe, 0xa8, 0x28, 0x2c, 0xfe, 0x47, 0x88,
  0xa6, 0x6d, 0xf7, 0x44, 0xae, 0xf8, 0xff, 0x06, 0x0e, 0x5c, 0x02, 0x1c, 0xc3, 0x6c, 0xc6, 0xe6,
  0x9b, 0xb2, 0x4d, 0x04, 0x0d, 0x62, 0x93, 0xf0, 0x19, 0x3d, 0x0a, 0x12, 0x1c, 0x61, 0xfc, 0x05,
  0x11, 0xc4, 0x68, 0x19, 0x92, 0x7d, 0x4c, 0x4a, 0xd5, 0x44, 0x25, 0xd7, 0xbb, 0x00, 0x34, 0xe3,
  0xe7, 0x85, 0x87, 0x64, 0xd8, 0x21, 0x50, 0xf1, 0xd7, 0xe4, 0x79, 0xaa, 0x82, 0x43, 0xfd, 0x91,
  0x28, 0x00, 0x12, 0xa1, 0x86, 0xc6, 0xb2, 0x10, 0x30, 0xfe, 0x0b, 0x55, 0x7c, 0xff, 0xf3, 0xa0,
  0x58, 0xff, 0xc0, 0x15, 0x82, 0x5e, 0x02, 0xde, 0xa2, 0xe2, 0x40, 0x01, 0x00, 0xa0, 0xd7, 0x1c,
  0x8a, 0x3b, 0xa0, 0x08, 0x2c, 0xd9, 0x30, 0x8e, 0xe9, 0xc0, 0x00, 0x80, 0x66, 0xc6, 0x20, 0x25,
  0x0b, 0x01, 0x8a, 0x00, 0x00, 0x03, 0x50, 0xc2, 0x8e, 0x09, 0x13, 0x0c, 0x10, 0x00, 0x00, 0x1a,
  0x9b, 0x70, 0x00, 0xef, 0x01, 0xfa, 0x82, 0x00, 0x0d, 0x00, 0x08, 0x29, 0x18, 0x00, 0x01, 0x46,
  0x02, 0x40, 0x0b, 0x90, 0x00, 0x41, 0x6a, 0x80, 0x20, 0x0a, 0x80, 0x10, 0x08, 0xb8, 0x08, 0xa0,
  0x83, 0x21, 0x08, 0x00, 0xa4, 0x02, 0x0a, 0x08, 0xf0, 0x82, 0x51, 0xb2, 0x90, 0x02, 0xb0, 0x65,
  0x98, 0xd5, 0x32, 0x89, 0x03, 0x84, 0x81, 0x90, 0xa1, 0x23, 0xc0, 0x40, 0x4e, 0x60, 0x00, 0x01,
  0x20, 0xd0, 0x10, 0x00, 0xb8, 0x28, 0x90, 0x00, 0x93, 0x92, 0x3a, 0x09, 0x90, 0x00, 0x09, 0x68,
  0xa6, 0x30, 0x04, 0x44, 0x48, 0x21, 0xcc, 0x24, 0xc0, 0x30, 0x69, 0xe2, 0x20, 0x50, 0xa4, 0x42,
  0x14, 0x00, 0x11, 0x0b, 0x00, 0x92, 0x30, 0xf2, 0x45, 0x28, 0x55, 0xcb, 0x0c, 0x1b, 0xe1, 0x7c,
  0x20, 0x71, 0x86, 0xf8, 0x25, 0x7e, 0x61, 0x82, 0x09, 0xc3, 0xdd, 0xb4, 0xb5, 0xea, 0x18, 0x84,
  0x78, 0x24, 0x12, 0x54, 0x1c, 0x88, 0x20, 0x72, 0x02, 0x50, 0xd8, 0x68, 0x06, 0xb0, 0x02, 0x11,
  0x50, 0x40, 0x40, 0xa9, 0x84, 0x41, 0x06, 0x08, 0xc2, 0x40, 0x00, 0x20, 0x22, 0x28, 0x00, 0x01,
  0x00, 0x00, 0x20, 0x30, 0x00, 0x00, 0x00, 0x0e, 0x60, 0x58, 0x83, 0x00, 0x52, 0x40, 0x00, 0x30,
  0x00, 0x58, 0x02, 0x00, 0x20, 0x28, 0xa2, 0x02, 0x94, 0x00, 0xcf, 0xbd, 0x1e, 0x50, 0xd4, 0xa0,
  0x95, 0xdd, 0x05, 0xfd, 0x3e, 0x02, 0x9e, 0xc1, 0xbf, 0x48, 0xb8, 0x97, 0x6f, 0xda, 0x96, 0xa3,
  0x6f, 0xf7, 0x52, 0x22, 0xa8, 0x84, 0x40, 0xff, 0xc6, 0xb7, 0xd4, 0x02, 0xcc, 0x0b, 0x42, 0x40,
  0x00, 0x08, 0xc8, 0x00, 0x42, 0xd8, 0x53, 0xba, 0x05, 0x00, 0x00, 0x40, 0xc0, 0xe5, 0x86, 0x34,
  0x01, 0x12, 0x4f, 0xf1, 0x21, 0x40, 0x00, 0x00, 0x20, 0x1a, 0xb0, 0x08, 0x00, 0x4d, 0x12, 0x00,
  0x29, 0x18, 0x80, 0x04, 0x20, 0x0a, 0x01, 0xec, 0x00, 0x4c, 0xb2, 0x16, 0x57, 0x92, 0x7d, 0x16,
  0x32, 0x18, 0x42, 0x74, 0x04, 0x15, 0x93, 0x84, 0x9d, 0x0a, 0x0d, 0x01, 0x78, 0x00, 0x3e, 0xff,
  0x59, 0x21, 0x07, 0x28, 0x83, 0x14, 0x07, 0x80, 0x70, 0xe1, 0x92, 0x35, 0xf0, 0xc8, 0xdb, 0xbb,
  0x58, 0x7d, 0xdf, 0x91, 0x47, 0x45, 0x4d, 0x8a, 0x44, 0xaa, 0x53, 0x4c, 0x63, 0x7c, 0xd1, 0x49,
  0xfd, 0xb8, 0xf1, 0xc2, 0xc0, 0xe6, 0x19, 0x4c, 0x14, 0x0c, 0x03, 0xce, 0x88, 0x10, 0xc4, 0x95,
  0x00, 0x03, 0xa6, 0x5c, 0xc7, 0xf1, 0x40, 0x20, 0x72, 0x34, 0xa4, 0x65, 0xbc, 0xfd, 0x85, 0x00,
  0x5c, 0x7c, 0x2b, 0x31, 0x93, 0x60, 0x3e, 0x8c, 0x07, 0x00, 0x54, 0xab, 0xd1, 0x80, 0xfb, 0x70,
  0xd2, 0xc7, 0x44, 0x31, 0xc1, 0x88, 0x89, 0x0f, 0x29, 0xbe, 0x14, 0xe5, 0x35, 0x93, 0xdf, 0x02,
  0x21, 0x22, 0xca, 0xe0, 0x09, 0x5a, 0x22, 0x22, 0x13, 0xfc, 0x80, 0x00, 0x12, 0x00, 0x2b, 0xaf,
  0x80, 0xee, 0xfa, 0x37, 0x42, 0x23, 0xb8, 0x91, 0xc1, 0xd6, 0x14, 0x92, 0x90, 0x82, 0x42, 0x4b,
  0xb8, 0x60, 0x7f, 0x9a, 0x02, 0x18, 0x44, 0x5c, 0x27, 0xed, 0xf9, 0xdc, 0xc0, 0x0f, 0x57, 0x03,
  0x61, 0xc8, 0x40, 0x41, 0x01, 0x91, 0x00, 0x27, 0x00, 0x4d, 0x85, 0x08, 0x01, 0xd2, 0x23, 0x30,
  0x90, 0xcb, 0x22, 0x91, 0xf5, 0xf8, 0x2c, 0x12, 0x9a, 0x41, 0xa2, 0x30, 0x50, 0x42, 0x0e, 0x20,
  0x02, 0x05, 0x13, 0x08, 0x02, 0x8c, 0x0a, 0x22, 0x20, 0x02, 0x00, 0x80, 0x81, 0x41, 0x02, 0xa0,
  0x10, 0x80, 0x34, 0x26, 0x0c, 0x56, 0xa0, 0x58, 0x65, 0x06, 0x28, 0xa0, 0xf3, 0x09, 0x6a, 0x26,
  0x84, 0x00, 0x00, 0x8c, 0x18, 0x39, 0x0f, 0xd3, 0x04, 0x87, 0x47, 0xc6, 0x32, 0x08, 0xad, 0x80,
  0x31, 0xca, 0xc1, 0x59, 0x4d, 0x1d, 0x81, 0x4c, 0x5e, 0x19, 0x21, 0x50, 0xe7, 0xcc, 0x40, 0x30,
  0xb3, 0x6b, 0x1c, 0x0b, 0x8d, 0x87, 0x4e, 0x19, 0x78, 0x51, 0x21, 0x47, 0x2f, 0xc3, 0x9a, 0x20,
  0x59, 0xc2, 0x43, 0xc4, 0xa2, 0x12, 0x28, 0xcb, 0x49, 0x40, 0x02, 0x6c, 0x82, 0x40, 0xbd, 0xff,
  0x90, 0xd7, 0x0f, 0x17, 0x03, 0xbe, 0x4b, 0xa5, 0x42, 0x43, 0xd2, 0x4b, 0xfe, 0x25, 0xf5, 0x0b,
  0x05, 0x58, 0x85, 0x2c, 0xe2, 0x41, 0x1b, 0xd0, 0xca, 0x23, 0xd8, 0xa6, 0x29, 0x4b, 0x5c, 0x13,
  0x78, 0x00, 0x13, 0x02, 0x60, 0x70, 0x28, 0xcc, 0xfa, 0x86, 0xf8, 0x4d, 0x11, 0x00, 0x0b, 0x03,
  0x54, 0x05, 0x19, 0x15, 0xa3, 0x85, 0xd6, 0x68, 0x0a, 0xf5, 0x2d, 0xa1, 0xd1, 0x03, 0x20, 0x60,
  0xcc, 0x9f, 0x20, 0x78, 0x76, 0xa0, 0x8a, 0x45, 0x00, 0x20, 0x1c, 0x6e, 0xe0, 0xb7, 0x1d, 0xce,
  0x60, 0x22, 0x4c, 0x98, 0x81, 0x02, 0x68, 0x13, 0x51, 0x3e, 0x90, 0xc6, 0x21, 0x94, 0x20, 0x55,
  0x24, 0x38, 0x39, 0x53, 0x70, 0x72, 0x86, 0xe4, 0x0b, 0x90, 0x00, 0xc1, 0x62, 0x10, 0x30, 0x83,
  0x88, 0x06, 0x81, 0x08, 0xb0, 0x2a, 0x10, 0x90, 0x70, 0x00, 0x50, 0x33, 0x28, 0xa0, 0x00, 0x30,
  0x0c, 0x20, 0x22, 0x05, 0xd1, 0x00, 0x21, 0xe6, 0x11, 0x4a, 0x98, 0x51, 0x7a, 0x61, 0x18, 0xd1,
  0x9a, 0x74, 0x06, 0x82, 0x08, 0x31, 0x7d, 0x39, 0x86, 0x16, 0x3a, 0x91, 0x00, 0x19, 0x10, 0x00,
  0x00, 0x81, 0x59, 0x10, 0x18, 0x00, 0x09, 0x83, 0xe0, 0x02, 0x85, 0x2f, 0xa0, 0xa1, 0xb0, 0x26,
  0x72, 0x8c, 0xb2, 0x70, 0x60, 0x12, 0x50, 0xff, 0x4c, 0x68, 0x15, 0x74, 0x74, 0xa1, 0xd0, 0x00,
  0x08, 0x18, 0x21, 0x53, 0x04, 0x70, 0x36, 0x96, 0x4c, 0x00, 0x00, 0x68, 0x1a, 0x6b, 0x09, 0xc0,
  0x05, 0x8a, 0x16, 0x58, 0x00, 0x09, 0x24, 0x88, 0x87, 0x19, 0x64, 0xc2, 0x4a, 0xba, 0x75, 0xf8,
  0x05, 0xf0, 0x14, 0x75, 0xdf, 0x5f, 0x00, 0xea, 0x10, 0x26, 0x02, 0x99, 0x01, 0x13, 0x22, 0x03,
  0xa0, 0x09, 0x82, 0x8d, 0x24, 0x21, 0x23, 0x25, 0x2c, 0x58, 0x5c, 0x06, 0x00, 0x09, 0x29, 0x83,
  0x62, 0x41, 0x5c, 0x00, 0xb0, 0x18, 0x60, 0x83, 0x44, 0x00, 0x08, 0x99, 0x0a, 0x07, 0x88, 0xa8,
  0xea, 0x82, 0x41, 0x00, 0x58, 0x20, 0x54, 0x40, 0xf2, 0x00, 0x0c, 0x91, 0xc8, 0x1b, 0x56, 0x22,
  0x45, 0x51, 0x44, 0xb7, 0x03, 0x88, 0xa0, 0x02, 0x00, 0x08, 0x40, 0x80, 0x10, 0x11, 0x80, 0x8c,
  0x04, 0x62, 0x20, 0x40, 0x00, 0x1f, 0x10, 0xf0, 0x00, 0x91, 0x00, 0x45, 0x00, 0x00, 0x40, 0x44,
  0x08, 0x41, 0x08, 0x68, 0x42, 0x00, 0x02, 0x08, 0x03, 0x4a, 0x06, 0x48, 0x2f, 0x4a, 0x00, 0x04,
  0x08, 0xa1, 0x0c, 0x41, 0x00, 0x88, 0x40, 0x42, 0x50, 0xc2, 0xad, 0x01, 0x87, 0x0e, 0x04, 0x5b,
  0x02, 0x04, 0x80, 0x10, 0x00, 0xac, 0xa6, 0x3f, 0x83, 0x98, 0x20, 0xd5, 0x61, 0x40, 0x28, 0x46,
  0xe1, 0x00, 0x22, 0x00, 0xa1, 0x09, 0x62, 0x42, 0x3a, 0x02, 0xa1, 0x50, 0xe0, 0x4c, 0x01, 0xcc,
  0x00, 0x20, 0x03, 0x1d, 0x0c, 0x73, 0x0b, 0x03, 0x0c, 0x03, 0x01, 0x00, 0x10, 0xa0, 0xa5, 0xb0,
  0x09, 0x50, 0x02, 0x00, 0x00, 0x40, 0x30, 0x14, 0xa0, 0xe6, 0x22, 0x02, 0x94, 0x26, 0x44, 0x82,
  0x17, 0x40, 0x00, 0x00, 0x26, 0x62, 0x3e, 0x21, 0x40, 0x00, 0x04, 0x7b, 0xb8, 0x61, 0x92, 0x02,
  0x10, 0x50, 0x00, 0x03, 0x21, 0x00, 0x80, 0x04, 0x00, 0x21, 0x08, 0x08, 0xb3, 0x42, 0xe3, 0x80,
  0x5c, 0x0e, 0x54, 0xab, 0x16, 0x99, 0xf1, 0xb8, 0x0a, 0x7d, 0x48, 0x7c, 0xaf, 0x75, 0x9b, 0x81,
  0x23, 0x73, 0x48, 0x24, 0x14, 0x10, 0x74, 0xce, 0x35, 0x24, 0x2c, 0xd2, 0x30, 0x40, 0xb8, 0x2b,
  0x40, 0x54, 0x00, 0x01, 0xe9, 0x00, 0x88, 0x10, 0x23, 0x88, 0x22, 0x88, 0x61, 0xe8, 0xa2, 0xbe,
  0xbb, 0x92, 0x92, 0x7a, 0x02, 0x02, 0x89, 0xe1, 0x32, 0xa4, 0x23, 0x1b, 0x5d, 0x22, 0x28, 0x92,
  0x49, 0xd8, 0x00, 0x13, 0x8e, 0x40, 0x01, 0xa8, 0x83, 0x00, 0x00, 0x30, 0x56, 0x90, 0x00, 0x43,
  0x00, 0x12, 0x40, 0x02, 0x84, 0x0c, 0x92, 0x5d, 0x01, 0x04, 0x01, 0x38, 0x35, 0x47, 0x10, 0x08,
  0x20, 0x08, 0x2c, 0x00, 0xc7, 0x00, 0x28, 0x21, 0x04, 0x02, 0x00, 0x04, 0x08, 0x19, 0x28, 0x28,
  0x43, 0x0e, 0x55, 0x20, 0x11, 0x61, 0x04, 0x2a, 0x46, 0x30, 0xc8, 0x20, 0x01, 0x89, 0x08, 0x04,
  0x41, 0x02, 0x60, 0x40, 0x02, 0x38, 0x80, 0x2a, 0xc1, 0xc0, 0x97, 0x27, 0xa4, 0x84, 0x01, 0x21,
  0xcc, 0x27, 0x08, 0x14, 0x03, 0x22, 0x90, 0x67, 0xc0, 0x50, 0x64, 0x81, 0x5b, 0x48, 0x80, 0x10,
  0x80, 0x96, 0x09, 0xe9, 0x80, 0x02, 0x61, 0x1f, 0xb2, 0x47, 0x81, 0x00, 0x70, 0x50, 0x8a, 0x65,
  0x58, 0x80, 0x37, 0x81, 0x00, 0x63, 0x82, 0x21, 0x1d, 0xb5, 0x74, 0x6d, 0xf7, 0x35, 0x82, 0xe1,
  0x2a, 0xb1, 0x40, 0xd2, 0x86, 0x88, 0x16, 0x40, 0x06, 0xdd, 0xea, 0x04, 0x05, 0x0a, 0xcc, 0x20,
  0x03, 0x15, 0x2d, 0xef, 0x40, 0x24, 0x48, 0x80, 0xcb, 0x59, 0x00, 0x04, 0x8e, 0x44, 0x13, 0x00,
  0x81, 0x04, 0x79, 0x01, 0x51, 0x30, 0x01, 0x87, 0x90, 0x0d, 0x8a, 0x81, 0x8c, 0x08, 0x14, 0x02,
  0x70, 0x54, 0xa5, 0x91, 0x6d, 0x96, 0x70, 0x46, 0xa4, 0x22, 0x22, 0x8b, 0xa1, 0x01, 0x2a, 0xb2,
  0xae, 0x34, 0x8d, 0xf8, 0xe0, 0x1b, 0xb4, 0x61, 0x3e, 0x9b, 0x82, 0x1a, 0x72, 0x82, 0x76, 0x44,
  0x00, 0x41, 0x10, 0x79, 0xb0, 0x1f, 0xed, 0xb7, 0x01, 0x31, 0x66, 0xae, 0xc8, 0xc9, 0x28, 0x10,
  0x4c, 0x70, 0x20, 0x13, 0x72, 0x12, 0x65, 0x76, 0x52, 0x34, 0x2e, 0x66, 0x03, 0x64, 0x80, 0x5d,
  0x30, 0xeb, 0xba, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa0, 0x05, 0x0e, 0xcc, 0x81, 0x81, 0xf2, 0xa5, 0xc0,
  0x37, 0xaa, 0x08, 0x26, 0x58, 0xc3, 0x22, 0xc4, 0x46, 0x28, 0x2c, 0x00, 0xc2, 0x50, 0x90, 0x58,
  0xde, 0x18, 0xa5, 0xc8, 0x40, 0x80, 0x12, 0x15, 0x02, 0x20, 0x22, 0xa3, 0x60, 0x81, 0xbb, 0x47,
  0x0f, 0x58, 0x12, 0xb4, 0x64, 0x6d, 0x68, 0x20, 0x1a, 0x0a, 0x02, 0x76, 0x4c, 0x01, 0x48, 0x8c,
  0x27, 0xe0, 0x00, 0x30, 0x10, 0x41, 0x50, 0x42, 0x02, 0x12, 0xdc, 0x01, 0x06, 0x12, 0xc8, 0xe1,
  0xb0, 0xa1, 0x14, 0x2c, 0x98, 0xc0, 0x94, 0xa7, 0xa2, 0xc4, 0x50, 0xe1, 0x95, 0xa4, 0x18, 0x3a,
  0x65, 0xee, 0xa3, 0x9b, 0x00, 0x7a, 0x17, 0xc0, 0x81, 0x00, 0x00, 0xe5, 0x2a, 0xb3, 0x63, 0x82,
  0x00, 0x14, 0x20, 0x45, 0x06, 0x1d, 0x50, 0xd4, 0x04, 0x00, 0x79, 0x5b, 0x57, 0x10, 0x58, 0x70,
  0x7e, 0x42, 0x03, 0x88, 0x10, 0x91, 0x6e, 0xc0, 0x84, 0x61, 0xa0, 0x80, 0x20, 0x00, 0x15, 0x19,
  0x05, 0x62, 0x12, 0x23, 0xa0, 0xb0, 0x44, 0x04, 0x45, 0x2a, 0x12, 0x89, 0x80, 0x51, 0xeb, 0x14,
  0x19, 0x1e, 0x10, 0x00, 0xa0, 0x68, 0x44, 0x8c, 0x02, 0xc2, 0x01, 0x10, 0x72, 0x5f, 0x45, 0x60,
  0x28, 0x10, 0x88, 0x49, 0x40, 0x04, 0x28, 0xd9, 0x4a, 0x74, 0xc2, 0x68, 0x00, 0x0a, 0x08, 0x09,
  0x82, 0x00, 0x5d, 0xa1, 0x42, 0x0c, 0x04, 0x04, 0xd0, 0xf2, 0x15, 0xe0, 0x10, 0xf4, 0x01, 0x02,
  0x89, 0xa0, 0xc9, 0x58, 0x0a, 0xfb, 0x80, 0x60, 0x40, 0x45, 0x84, 0x0c, 0x0c, 0x60, 0x01, 0x72,
  0x23, 0x30, 0x13, 0x20, 0x20, 0x05, 0x80, 0x01, 0x00, 0x06, 0x8c, 0x2b, 0x01, 0x10, 0x40, 0x50,
  0x00, 0x38, 0x14, 0x00, 0x18, 0x71, 0x82, 0x00, 0x0b, 0x56, 0x08, 0x53, 0x08, 0x4f, 0x00, 0xd2,
  0xb2, 0xe4, 0x60, 0xa8, 0x04, 0x40, 0x09, 0x11, 0x00, 0x5a, 0x15, 0x41, 0x92, 0xa2, 0x0a, 0x81,
  0x20, 0x04, 0x00, 0x01, 0x20, 0x11, 0x10, 0x34, 0x8b, 0x10, 0xa0, 0x00, 0x80, 0x01, 0x23, 0x52,
  0x05, 0x07, 0x46, 0x00, 0x71, 0x00, 0x42, 0x50, 0xaa, 0x0c, 0x31, 0x56, 0x70, 0x90, 0xa5, 0x07,
  0x60, 0x94, 0x23, 0x42, 0x28, 0x12, 0xcd, 0x01, 0x7c, 0x01, 0x0c, 0xcd, 0x40, 0x80, 0x3c, 0xce,
  0x29, 0x28, 0xb0, 0x0e, 0x04, 0x30, 0x02, 0x90, 0x58, 0x0c, 0x02, 0x03, 0x8a, 0x25, 0x29, 0x03,
  0x53, 0xb1, 0x13, 0xa0, 0x43, 0x69, 0x30, 0x25, 0x80, 0x00, 0x20, 0x2c, 0x13, 0x00, 0x08, 0x80,
  0xb0, 0xaa, 0xb3, 0x95, 0x14, 0x24, 0x5b, 0x38, 0x42, 0x80, 0xec, 0x12, 0xb2, 0x5e, 0xf0, 0x48,
  0x2d, 0x4c, 0x54, 0xa2, 0xdf, 0x8c, 0xa0, 0x4b, 0x29, 0x1d, 0x22, 0x3b, 0xeb, 0x16, 0x53, 0xa2,
  0xe9, 0x0a, 0x8b, 0x74, 0xc2, 0x98, 0x10, 0x42, 0x40, 0x4b, 0x12, 0xb9, 0x02, 0x19, 0xe9, 0x05,
  0x90, 0x2a, 0xb2, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x21, 0x42, 0xaa, 0x84, 0x20, 0x60, 0x38, 0x00, 0xe8,
  0x24, 0x6e, 0x08, 0x86, 0xe1, 0xff, 0xbb, 0x9d, 0xf9, 0xa6, 0x50, 0x3a, 0xba, 0x24, 0x88, 0x3c,
  0x0d, 0xb5, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x14, 0xdb, 0x00,
  0x44, 0x20, 0x00, 0x40, 0x10, 0x80, 0x10, 0x22, 0x20, 0x19, 0x02, 0x35, 0x50, 0xb1, 0x14, 0x09,
  0x00, 0xe1, 0x80, 0x07, 0x00, 0x20, 0x8c, 0x00, 0x29, 0xe8, 0x84, 0x41, 0x98, 0x00, 0x2a, 0x08,
  0x4d, 0x34, 0x58, 0x40, 0x40, 0x39, 0xc0, 0x02, 0x06, 0xbd, 0x20, 0x11, 0x30, 0x10, 0x00, 0x9e,
  0x14, 0x68, 0x3c, 0x5d, 0x02, 0x61, 0x10, 0xd3, 0x2e, 0x4e, 0x01, 0x09, 0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1b, 0x11, 0x87, 0xe1, 0x39, 0x2c, 0x02, 0x48, 0x20, 0x26, 0x75, 0x89, 0xe4,
  0xd6, 0x17, 0xdf, 0x67, 0xf1, 0x02, 0x66, 0xca, 0x65, 0x77, 0xfe, 0xca, 0xd5, 0xc7, 0x27, 0xad,
  0xf9, 0x61, 0x40, 0x00, 0x12, 0xa1, 0x44, 0x80, 0x40, 0x22, 0x00, 0x12, 0x68, 0x84, 0x05, 0x04,
  0x20, 0x00, 0x24, 0x40, 0x01, 0x04, 0xa0, 0x00, 0x00, 0x7e, 0x2a, 0x80, 0x34, 0x68, 0x35, 0x80,
  0x21, 0x54, 0xa1, 0x08, 0x28, 0x31, 0x0c, 0xa0, 0xc3, 0xdf, 0xc3, 0xbf, 0x5f, 0x06, 0x06, 0x09,
  0x02, 0x26, 0xcc, 0x02, 0x00, 0x48, 0x09, 0x69, 0x8c, 0xd2, 0xc1, 0x72, 0x2b, 0x00, 0x41, 0x82,
  0x94, 0x80, 0x56, 0xb8, 0x01, 0x04, 0x01, 0x40, 0x00, 0x01, 0xb5, 0x40, 0x89, 0x64, 0x30, 0xf9,
  0x22, 0x01, 0x80, 0xe6, 0xf6, 0x9b, 0x24, 0x30, 0x08, 0x94, 0x0b, 0x18, 0x80, 0x0a, 0x84, 0x0a,
  0x00, 0x08, 0x0b, 0x20, 0x09, 0x0e, 0x80, 0x40, 0x12, 0x80, 0xc3, 0x86, 0x4c, 0x80, 0x00, 0x80,
  0x11, 0x00, 0x98, 0xe0, 0x40, 0x10, 0x46, 0xa0, 0x4c, 0x80, 0x70, 0x32, 0xa0, 0x20, 0x85, 0x0f,
  0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0xb1, 0x71, 0x7a, 0xc0, 0xbd, 0x84, 0x20, 0x5a, 0x11, 0x2c, 0x0e, 0x88, 0x64, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x40, 0xa3, 0x20, 0x11, 0xa8, 0x1d, 0x80, 0x1f, 0x3e, 0x28, 0xb7, 0xa4,
  0x06, 0xb7, 0x0d, 0xdc, 0x91, 0xa1, 0xeb, 0xd8, 0xcf, 0x5e, 0x46, 0x58, 0x30, 0xb0, 0xa3, 0x50,
  0x8b, 0xa7, 0x52, 0x4a, 0x09, 0x20, 0xb0, 0xd6, 0x3a, 0xc5, 0x66, 0x4a, 0xea, 0xd4, 0x48, 0x68,
  0x4e, 0x15, 0x80, 0x88, 0x92, 0x94, 0x18, 0x00, 0x12, 0x90, 0x10, 0x08, 0x00, 0x06, 0x36, 0x11,
  0x76, 0x89, 0xf1, 0xa0, 0x48, 0x0c, 0x09, 0x9c, 0x02, 0x1f, 0x0d, 0x92, 0x05, 0x11, 0xd8, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x42, 0x00, 0x1a, 0x00, 0x00, 0x19, 0x20, 0x57, 0x28, 0x0e,
  0x14, 0x68, 0xb8, 0x86, 0xc9, 0x8a, 0x00, 0x06, 0x24, 0x58, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xc2, 0x04, 0x8e, 0x18, 0x08, 0x4e, 0x80, 0xe4, 0x95, 0x20, 0x06, 0x60, 0x91,
  0x44, 0x03, 0x30, 0x40, 0x00, 0x90, 0x81, 0x02, 0xb4, 0x06, 0x05, 0x31, 0x2c, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x80, 0x88, 0x88, 0x01, 0x58, 0xcb, 0x32, 0x37, 0x49, 0x10,
  0x02, 0x00, 0x00, 0xa1, 0x35, 0xe3, 0x60, 0x18, 0x7c, 0x07, 0x48, 0xa0, 0x00, 0x01, 0x2c, 0x00,
  0x10, 0x03, 0x73, 0x01, 0x80, 0xb6, 0x48, 0x50, 0x82, 0x61, 0x6a, 0x10, 0x78, 0x80, 0xe4, 0x00,
  0x8a, 0xec, 0xbc, 0x10, 0x4c, 0x07, 0xa0, 0x72, 0x03, 0x80, 0x21, 0x20, 0x81, 0x00, 0x02, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x58, 0x9a, 0x00,
  0x13, 0xc2, 0x24, 0x11, 0x12, 0xb8, 0x00, 0x13, 0x4a, 0x80, 0xc0, 0x4e, 0xc8, 0x19, 0xa0, 0x20,
  0x01, 0x41, 0x00, 0x20, 0x08, 0x51, 0x28, 0xb0, 0x6a, 0x01, 0x10, 0x40, 0x02, 0x05, 0x20, 0xe4,
  0x00, 0x00, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xc5,
  0x40, 0x98, 0x75, 0x05, 0x06, 0x64, 0x00, 0xfb, 0x08, 0x0f, 0xe8, 0xde, 0x84, 0x81, 0x0b, 0x5c,
  0x01, 0x82, 0x14, 0x00, 0xc0, 0x08, 0x00, 0x12, 0x00, 0x33, 0x28, 0x01, 0xf3, 0x28, 0x23, 0x00,
  0x00, 0x04, 0x04, 0x0c, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00,
  0x00
}; // n=7517

// Codepage cp936
static const unsigned char gs_cp936_table[] =
{
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x09, 0x80, 0xc1, 0x00, 0x00, 0x00, 0x01, 0x00, 0xc0, 0xec, 0x31, 0x68,
  0x40, 0x00, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x08, 0x84, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xaa, 0xa8, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x70, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7f, 0xff, 0xdf, 0xc0, 0x7f, 0xff, 0xdf, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x40, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x9e, 0xcc, 0x06, 0x00, 0xb4, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x40, 0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0xff, 0xc0,
  0x00, 0x00, 0xf3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x81, 0x44, 0x27, 0x95, 0xf2, 0x0f, 0x04, 0x00, 0x88, 0x20, 0x00, 0xcf, 0x03, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x40, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x0f, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00,
  0x7f, 0xff, 0x1c, 0x00, 0xc0, 0x00, 0x30, 0x0c, 0x03, 0x13, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
  0x06, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xf7, 0xff, 0xff, 0x06, 0x7f, 0xc0, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf0, 0x1e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0e,
  0x07, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x00, 0x0e, 0x40, 0x00, 0x00, 0x00, 0x08, 0x02, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x40, 0x00,
  0x00, 0x0f, 0x58, 0x81, 0xd9, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xf8, 0x7f, 0xef, 0x7f, 0xfe, 0xf0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00,
  0x00
}; // n=21920

// Codepage cp949
static const unsigned char gs_cp949_table[] =
{
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x49, 0xa6, 0xfb, 0xef, 0x02, 0x00, 0x81, 0x83, 0x02, 0x00, 0x81, 0x82,
  0x00, 0x00, 0x40, 0x00, 0x03, 0x00, 0x70, 0x81, 0xe0, 0x70, 0x30, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x80, 0xf4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7f, 0xff, 0xdf, 0xc0, 0x7f, 0xff, 0xdf, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x40, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xcc, 0xc6, 0x00, 0xb0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01,
  0x78, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x40, 0x12, 0x00, 0x62, 0x10, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1e, 0xff, 0xc0, 0xff, 0xc0,
  0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xb1, 0x91, 0x40, 0x26, 0x85, 0xfa, 0x0c, 0x0c, 0x00, 0x00, 0x20, 0x00, 0xcc, 0x30, 0x00, 0x00,
  0x33, 0x00, 0x00, 0x40, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfe, 0x0f, 0xff,
  0xe0, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,
  0xf0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x00, 0xdf, 0xc0, 0x33, 0x0c, 0xc3, 0x93, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x03, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xdd, 0xec, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xf0, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf0, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf1,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xd1, 0xf4, 0x4e, 0xc2, 0x00, 0x04, 0x20, 0xd0, 0x34, 0x17, 0x02, 0xc7, 0x00, 0x14, 0x13, 0x02,
  0x22, 0x9a, 0xec, 0x92, 0x6e, 0x9e, 0x02, 0x20, 0xc9, 0x34, 0x0f, 0xc5, 0x1c, 0x00, 0xa3, 0x10,
  0x40, 0x77, 0xc0, 0x00, 0x00, 0x01, 0x0a, 0xac, 0x13, 0x87, 0xc4, 0x78, 0x00, 0x41, 0x92, 0x23,
  0x5a, 0xb5, 0x42, 0x94, 0x00, 0x03, 0x06, 0x01, 0x38, 0x62, 0x59, 0x25, 0xc0, 0x03, 0x54, 0xa0,
  0x22, 0x54, 0x62, 0x6b, 0x5b, 0xbc, 0x00, 0x10, 0x11, 0xc1, 0x04, 0x28, 0x04, 0x00, 0x0e, 0x80,
  0x84, 0x04, 0x40, 0xc0, 0x00, 0x0c, 0x35, 0x02, 0x04, 0x61, 0x46, 0x22, 0x05, 0x04, 0x00, 0x51,
  0xca, 0x40, 0x20, 0x01, 0x40, 0x20, 0x21, 0x28, 0xdf, 0xde, 0x20, 0x08, 0x25, 0xfe, 0x47, 0x88,
  0x82, 0x24, 0x25, 0x00, 0x84, 0x28, 0x03, 0x04, 0x0a, 0x5c, 0x00, 0x0e, 0x40, 0x00, 0xc2, 0xe4,
  0x93, 0xa2, 0x41, 0x04, 0x0c, 0x62, 0x83, 0xf0, 0x11, 0x3c, 0x0a, 0x14, 0x40, 0x61, 0x24, 0x05,
  0x11, 0xc4, 0x60, 0x11, 0x98, 0x70, 0x00, 0x02, 0x55, 0x44, 0x26, 0xd7, 0x38, 0x00, 0x14, 0xb3,
  0x04, 0x85, 0x87, 0x40, 0xd0, 0x21, 0x00, 0x41, 0xd9, 0xe4, 0x79, 0x2a, 0x82, 0x81, 0xcd, 0x05,
  0x08, 0x00, 0x10, 0xa1, 0x86, 0x04, 0x00, 0x10, 0x10, 0xf4, 0x0b, 0x10, 0x7c, 0x7d, 0xf0, 0x80,
  0x18, 0xef, 0xc0, 0x15, 0x82, 0x50, 0x10, 0xda, 0x20, 0xa0, 0x40, 0x00, 0x00, 0xa0, 0x54, 0x1c,
  0x82, 0x0a, 0x80, 0x00, 0x08, 0x98, 0x10, 0x84, 0xc8, 0xc0, 0x00, 0x00, 0x44, 0x86, 0x20, 0x20,
  0x0b, 0x02, 0x80, 0x08, 0x00, 0x01, 0x44, 0x02, 0x0a, 0x01, 0x12, 0x02, 0x10, 0x00, 0x00, 0x08,
  0x8b, 0x60, 0x00, 0xec, 0x01, 0x7a, 0x00, 0x00, 0x05, 0x00, 0x08, 0x29, 0x18, 0x00, 0x00, 0x06,
  0x02, 0x40, 0x09, 0x00, 0x00, 0x01, 0x2a, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x90, 0x08, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x04, 0x0a, 0x08, 0x08, 0x00, 0x24, 0x40, 0x32, 0x80, 0x00, 0x80, 0x60,
  0x18, 0x94, 0x32, 0x81, 0x00, 0x84, 0x80, 0x10, 0xa1, 0x26, 0xc0, 0x00, 0x4a, 0x22, 0x84, 0x08,
  0x20, 0x90, 0x10, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x11, 0x92, 0x00, 0x01, 0x80, 0x00, 0x89, 0x68,
  0xa6, 0xe0, 0x00, 0x02, 0x49, 0x21, 0xcc, 0x20, 0x00, 0x31, 0x49, 0xa2, 0x68, 0x00, 0x04, 0x4a,
  0x14, 0x40, 0x10, 0x0b, 0x00, 0xc2, 0x10, 0x32, 0x45, 0x02, 0x54, 0xc3, 0x08, 0x19, 0x00, 0x74,
  0x00, 0x01, 0x0e, 0x68, 0x21, 0x76, 0x41, 0x02, 0x09, 0xc3, 0xcd, 0x20, 0xa1, 0x3e, 0x18, 0x84,
  0x38, 0x20, 0x13, 0x40, 0x04, 0x88, 0x00, 0x52, 0x12, 0x50, 0xd8, 0x6c, 0x02, 0xaa, 0x00, 0x91,
  0x50, 0x00, 0x40, 0x99, 0x84, 0x40, 0x02, 0x08, 0x42, 0x40, 0x00, 0x20, 0x22, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x30, 0x08, 0x00, 0x00, 0x00, 0x68, 0x48, 0x00, 0x00, 0x42, 0x40, 0x00, 0x00,
  0x04, 0x58, 0x02, 0x00, 0x00, 0x20, 0x00, 0x00, 0x90, 0x00, 0xcd, 0xad, 0x18, 0x50, 0xc4, 0xa8,
  0x05, 0xd9, 0x17, 0xf8, 0x3e, 0x0a, 0x9e, 0xc1, 0xbf, 0x08, 0xb9, 0x03, 0x6f, 0xdb, 0x06, 0xa0,
  0x49, 0xf7, 0x42, 0x40, 0x08, 0x80, 0x40, 0xfb, 0x86, 0x96, 0x44, 0x10, 0xac, 0x09, 0x40, 0x40,
  0x00, 0x00, 0xc0, 0x00, 0x40, 0x58, 0x55, 0xa2, 0x80, 0x00, 0x00, 0x40, 0x80, 0x81, 0x8a, 0x14,
  0x01, 0x06, 0x4b, 0x40, 0x01, 0x40, 0x00, 0x00, 0x00, 0x18, 0x80, 0x00, 0x00, 0x49, 0x00, 0x00,
  0x01, 0x10, 0x00, 0x04, 0xa0, 0x20, 0x00, 0xac, 0x00, 0x04, 0x22, 0x06, 0x67, 0x92, 0x79, 0x06,
  0x32, 0x08, 0x42, 0x54, 0x04, 0x14, 0x12, 0x85, 0x8d, 0x08, 0x04, 0x01, 0x70, 0x00, 0x39, 0xde,
  0x09, 0x21, 0x05, 0x28, 0x83, 0x14, 0x07, 0x82, 0x20, 0xe0, 0x92, 0x31, 0xb0, 0x08, 0x13, 0x30,
  0x48, 0x21, 0x5d, 0x91, 0x03, 0x40, 0x44, 0x28, 0x00, 0xaa, 0x03, 0x50, 0x23, 0x7c, 0xc1, 0x49,
  0xc5, 0x38, 0xe1, 0xc2, 0xc0, 0xe2, 0x05, 0x44, 0x14, 0x0c, 0x03, 0xc0, 0x80, 0x10, 0x04, 0x05,
  0x00, 0x01, 0x22, 0x0c, 0xc5, 0xa1, 0x00, 0x00, 0x70, 0x04, 0xa4, 0x44, 0x3c, 0xed, 0x80, 0x00,
  0x04, 0x4c, 0x0a, 0x31, 0x99, 0x00, 0xba, 0x8c, 0x05, 0x00, 0x40, 0x29, 0xc0, 0x00, 0xd2, 0x70,
  0x42, 0xc7, 0x04, 0x31, 0x01, 0x00, 0x89, 0x0b, 0x29, 0xb8, 0x14, 0xc5, 0x39, 0x92, 0x83, 0x06,
  0x60, 0x22, 0xc8, 0xe0, 0x09, 0x5a, 0x22, 0x22, 0x11, 0xf0, 0x00, 0x00, 0x02, 0x00, 0x23, 0xa9,
  0x81, 0xae, 0xe2, 0x21, 0x40, 0x22, 0xca, 0x03, 0xc1, 0xd4, 0x10, 0x80, 0x00, 0x02, 0x42, 0x49,
  0x88, 0x60, 0x65, 0x90, 0x00, 0x10, 0x44, 0x4c, 0x21, 0xcd, 0xbb, 0xd8, 0x00, 0x0f, 0x51, 0x03,
  0x41, 0x40, 0x40, 0x00, 0x00, 0x11, 0x00, 0x36, 0x00, 0x49, 0x84, 0x00, 0x01, 0x82, 0x21, 0x31,
  0x10, 0xc8, 0x22, 0x90, 0xe5, 0xe0, 0x00, 0x00, 0x8a, 0x01, 0x82, 0x30, 0x40, 0x06, 0x0b, 0x00,
  0x00, 0x05, 0x0b, 0x08, 0x20, 0x0c, 0x00, 0x22, 0x00, 0x00, 0x00, 0x80, 0x80, 0x41, 0x00, 0xe0,
  0x00, 0x80, 0x70, 0x22, 0x0c, 0x16, 0xa0, 0x10, 0x4d, 0x26, 0x28, 0xa0, 0x67, 0x08, 0x28, 0x22,
  0x88, 0x00, 0x00, 0x84, 0x10, 0x39, 0x03, 0xd3, 0x04, 0x87, 0x43, 0x02, 0x32, 0x0c, 0x2d, 0x82,
  0x35, 0x08, 0xc1, 0x59, 0x4d, 0x19, 0x81, 0x4c, 0x44, 0x19, 0x21, 0x00, 0x96, 0xcc, 0x48, 0x3d,
  0x03, 0x6b, 0xdc, 0x03, 0x85, 0x85, 0xca, 0x30, 0x78, 0x51, 0x00, 0x57, 0x0f, 0xd3, 0x1b, 0xa0,
  0x09, 0xc2, 0xc3, 0x84, 0xa0, 0x12, 0x38, 0x52, 0x0b, 0x40, 0x02, 0x4c, 0x82, 0x00, 0xb9, 0xeb,
  0x90, 0xd4, 0x0d, 0x17, 0x03, 0xbe, 0x4a, 0x24, 0x02, 0x43, 0xd2, 0x0b, 0x00, 0x05, 0xd5, 0x13,
  0x01, 0x51, 0x95, 0x2c, 0x00, 0x01, 0x93, 0x82, 0x08, 0x01, 0xf8, 0x24, 0x00, 0x49, 0xde, 0x12,
  0x00, 0x00, 0x33, 0x00, 0x60, 0x21, 0x00, 0xcc, 0xf0, 0x82, 0xd8, 0x00, 0x00, 0x04, 0x02, 0x01,
  0x44, 0x01, 0x19, 0x05, 0x61, 0x85, 0xd6, 0x00, 0x0c, 0x54, 0x25, 0xa1, 0x81, 0x82, 0x20, 0x60,
  0x84, 0x06, 0x20, 0x00, 0x01, 0x00, 0x80, 0x05, 0x00, 0x20, 0x1d, 0x62, 0xf0, 0x97, 0x05, 0xc0,
  0x00, 0x00, 0x04, 0x18, 0x05, 0x02, 0x08, 0x10, 0x50, 0x1c, 0x80, 0x00, 0x00, 0xa0, 0x00, 0x15,
  0x20, 0x20, 0x51, 0x43, 0x50, 0x00, 0x04, 0xe4, 0x08, 0x90, 0x30, 0xc1, 0x40, 0x10, 0x00, 0x00,
  0x88, 0x46, 0x01, 0x08, 0x30, 0x00, 0x10, 0x10, 0x30, 0x00, 0x10, 0x30, 0x00, 0x00, 0x02, 0x10,
  0x08, 0x28, 0x22, 0x00, 0xd0, 0x00, 0x20, 0x26, 0x03, 0x0a, 0x80, 0x01, 0x7e, 0x20, 0x21, 0x91,
  0x1a, 0x60, 0x02, 0x82, 0x00, 0x03, 0x25, 0x29, 0x46, 0x15, 0x3b, 0x90, 0x00, 0x18, 0x00, 0x00,
  0x00, 0x81, 0x50, 0x00, 0x10, 0x00, 0x09, 0x82, 0xe0, 0x02, 0x85, 0x27, 0x80, 0xa4, 0xa2, 0x26,
  0x77, 0x88, 0xbe, 0x70, 0x00, 0x12, 0x10, 0xdf, 0x68, 0x68, 0x15, 0x10, 0x74, 0x93, 0x90, 0x00,
  0x00, 0x18, 0x41, 0x52, 0x05, 0x60, 0x26, 0xd6, 0x40, 0x00, 0x00, 0x68, 0x12, 0x6a, 0x09, 0xc1,
  0x05, 0xce, 0x54, 0x00, 0x00, 0x01, 0x24, 0x00, 0x9f, 0x11, 0x40, 0xe2, 0x40, 0xb2, 0x55, 0xf0,
  0x00, 0x00, 0x01, 0x71, 0xde, 0x1d, 0x2a, 0xae, 0x18, 0x24, 0x02, 0x9b, 0x01, 0x13, 0x30, 0x20,
  0x00, 0x00, 0x82, 0x0d, 0x24, 0x31, 0x42, 0x20, 0x2c, 0x5a, 0x58, 0x00, 0x00, 0x01, 0x08, 0x83,
  0x62, 0x01, 0x4c, 0x00, 0xb0, 0x18, 0x60, 0x81, 0x40, 0x00, 0x49, 0xb3, 0x28, 0x06, 0x80, 0x2e,
  0x48, 0x86, 0x89, 0x00, 0x19, 0x03, 0x50, 0x42, 0xf0, 0x20, 0x04, 0x21, 0xc8, 0x59, 0x40, 0x02,
  0x46, 0x51, 0x44, 0xbf, 0x11, 0x81, 0x01, 0x02, 0x00, 0x08, 0xc0, 0x84, 0x10, 0x10, 0x80, 0x8c,
  0x04, 0x22, 0x20, 0xe0, 0x48, 0x1d, 0x11, 0xc0, 0x00, 0x91, 0x00, 0xc5, 0x00, 0x00, 0x40, 0x44,
  0x08, 0x48, 0x00, 0x62, 0x42, 0x00, 0x82, 0x00, 0x01, 0x6a, 0x82, 0x4a, 0x0f, 0x4a, 0x00, 0x04,
  0x08, 0x61, 0x28, 0x41, 0x20, 0x08, 0x40, 0x62, 0x50, 0xc2, 0xac, 0x01, 0x07, 0x06, 0x00, 0x1b,
  0x82, 0x00, 0x80, 0x10, 0x00, 0x2c, 0xa6, 0x36, 0x83, 0x88, 0x20, 0xd5, 0x61, 0x40, 0x20, 0x44,
  0xc0, 0x00, 0x00, 0x00, 0x21, 0x09, 0x00, 0x00, 0xa8, 0x02, 0x81, 0x40, 0x40, 0x40, 0x00, 0xcc,
  0x00, 0x20, 0x02, 0x1c, 0x04, 0x70, 0x03, 0x03, 0x0c, 0x00, 0xa1, 0x00, 0x00, 0xa0, 0xa4, 0xb0,
  0x0b, 0x52, 0x0b, 0x81, 0x01, 0x44, 0x30, 0x40, 0xa0, 0x6d, 0x02, 0x46, 0x9e, 0x64, 0x01, 0x46,
  0x57, 0x40, 0x10, 0x10, 0xe6, 0xbb, 0x9e, 0xa1, 0xd8, 0x10, 0x05, 0x7b, 0xac, 0xe1, 0x00, 0x02,
  0x31, 0x50, 0x00, 0x8b, 0x55, 0xa0, 0xa4, 0x45, 0x02, 0x21, 0x08, 0xa8, 0xb2, 0x02, 0x01, 0x00,
  0x48, 0x00, 0x44, 0xb1, 0x16, 0x98, 0xf1, 0xa0, 0x01, 0x09, 0x58, 0x5c, 0x26, 0x21, 0x86, 0xa1,
  0x03, 0x33, 0x40, 0x04, 0x04, 0x10, 0x74, 0xce, 0x25, 0x04, 0x2c, 0xd0, 0x20, 0x00, 0xa8, 0x28,
  0x80, 0x04, 0x00, 0x41, 0xea, 0x00, 0x00, 0x10, 0x20, 0x0a, 0x22, 0x00, 0x48, 0x48, 0xa0, 0x9e,
  0x0b, 0x02, 0x90, 0x00, 0x00, 0x02, 0x00, 0x21, 0x32, 0xa0, 0x22, 0x1b, 0x59, 0x02, 0x28, 0x8a,
  0x48, 0xd0, 0x00, 0x02, 0x80, 0x40, 0x01, 0xa8, 0x80, 0x04, 0x00, 0x10, 0x52, 0x10, 0x00, 0x43,
  0x00, 0x10, 0x40, 0x02, 0x04, 0x0c, 0x90, 0x19, 0x00, 0x00, 0x01, 0x18, 0x34, 0x47, 0x10, 0x00,
  0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x28, 0x00, 0x04, 0x01, 0x00, 0x04, 0x00, 0x19, 0x00, 0x08,
  0x41, 0x0e, 0x41, 0x00, 0x11, 0x40, 0x00, 0x38, 0x44, 0x32, 0x80, 0x00, 0x00, 0x89, 0x04, 0x10,
  0x40, 0x02, 0x02, 0x00, 0x00, 0x38, 0x00, 0x22, 0xc1, 0xc0, 0x83, 0x3e, 0x84, 0x84, 0x00, 0x21,
  0x40, 0x07, 0x40, 0x00, 0x03, 0x22, 0x50, 0x47, 0xc0, 0x70, 0x64, 0x81, 0x0b, 0x40, 0x00, 0x10,
  0x84, 0x94, 0x09, 0x69, 0x80, 0x02, 0x43, 0x1d, 0x82, 0x46, 0x01, 0x00, 0x60, 0x50, 0x8a, 0x65,
  0x48, 0x80, 0x34, 0x81, 0x00, 0x63, 0x00, 0x20, 0x0d, 0x30, 0x01, 0x45, 0x94, 0x25, 0x02, 0x61,
  0x00, 0x01, 0x40, 0x52, 0x82, 0x0c, 0x00, 0x40, 0x02, 0x5d, 0xea, 0x00, 0x80, 0x0a, 0x04, 0x04,
  0x01, 0x11, 0x0d, 0x24, 0x40, 0x04, 0x48, 0x80, 0xcb, 0x40, 0x20, 0x00, 0x88, 0x40, 0x00, 0x00,
  0x01, 0x00, 0x20, 0x02, 0x41, 0x30, 0x00, 0x07, 0x10, 0x0c, 0x00, 0x00, 0x88, 0x08, 0x10, 0x00,
  0x10, 0x40, 0x25, 0x81, 0x05, 0x02, 0x70, 0x42, 0x00, 0x20, 0x02, 0x03, 0x81, 0x00, 0x00, 0x12,
  0xaf, 0xb4, 0x89, 0xf0, 0xe0, 0x1b, 0x94, 0x60, 0x3e, 0x00, 0x80, 0x02, 0x62, 0xa2, 0x72, 0x41,
  0x00, 0x03, 0x10, 0x08, 0xa0, 0x0c, 0x6c, 0xb7, 0x01, 0x30, 0x02, 0xa6, 0xd0, 0xc9, 0x08, 0x10,
  0x00, 0x60, 0x04, 0x17, 0x50, 0x13, 0x41, 0x06, 0x53, 0x00, 0x2c, 0x02, 0x40, 0x74, 0x80, 0x48,
  0x20, 0x09, 0x12, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xa0, 0x00, 0x08, 0x8c, 0x00, 0x00, 0x32, 0xa5, 0x40,
  0x04, 0xaa, 0x08, 0x22, 0x08, 0xc0, 0x20, 0xc4, 0x44, 0x2a, 0x2c, 0x01, 0xc0, 0x50, 0x80, 0x48,
  0xd6, 0x48, 0x85, 0x80, 0x00, 0x04, 0x12, 0x05, 0x12, 0x20, 0x02, 0xa2, 0x00, 0x01, 0xb1, 0x07,
  0x0f, 0x58, 0x02, 0x14, 0x64, 0x61, 0x68, 0x20, 0x18, 0x0a, 0x00, 0x32, 0x4c, 0x00, 0x48, 0x84,
  0x27, 0xa0, 0x00, 0xb0, 0x10, 0x51, 0x00, 0x42, 0x00, 0x12, 0xcc, 0x00, 0x06, 0x10, 0xc0, 0xe1,
  0x80, 0xa1, 0x00, 0x2c, 0x90, 0x80, 0x14, 0x27, 0xa2, 0x04, 0x00, 0x81, 0x15, 0xa4, 0x18, 0x3a,
  0x05, 0xac, 0x20, 0x1b, 0x40, 0x38, 0x07, 0x40, 0x85, 0x00, 0x00, 0x40, 0x0a, 0x03, 0x62, 0x82,
  0x00, 0x16, 0x20, 0x65, 0x06, 0x4f, 0x51, 0xdd, 0x00, 0x00, 0x6d, 0x13, 0x47, 0x00, 0x40, 0x06,
  0x7c, 0x40, 0x01, 0x00, 0x00, 0x91, 0x4e, 0xc0, 0x81, 0x61, 0x60, 0x00, 0x00, 0x00, 0x11, 0x10,
  0x00, 0x62, 0x02, 0x82, 0x20, 0x70, 0x00, 0x04, 0x44, 0x68, 0x12, 0x08, 0x00, 0x51, 0xe8, 0x44,
  0x18, 0x2e, 0x00, 0x00, 0x00, 0x48, 0x40, 0x84, 0x00, 0x40, 0x01, 0x10, 0x52, 0x19, 0x04, 0x20,
  0x00, 0x00, 0x88, 0x48, 0x40, 0x00, 0x20, 0x99, 0xaa, 0x54, 0x40, 0x20, 0x00, 0x0a, 0x08, 0x08,
  0x00, 0x00, 0x59, 0xa2, 0x54, 0x0d, 0x00, 0x05, 0x50, 0x42, 0x10, 0x40, 0x10, 0xe4, 0x00, 0x00,
  0x09, 0x01, 0x48, 0x10, 0x02, 0xe1, 0x80, 0x20, 0x40, 0x47, 0x04, 0x0c, 0x0c, 0x60, 0x01, 0x31,
  0x23, 0x20, 0x03, 0x20, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x8c, 0x1b, 0x01, 0x00, 0x00, 0x40,
  0x00, 0x28, 0x10, 0x00, 0x18, 0x40, 0x00, 0x00, 0x01, 0x10, 0x08, 0x51, 0x08, 0x04, 0x00, 0x02,
  0xb0, 0x80, 0x00, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x01, 0x02, 0x80, 0x0a, 0x80,
  0x20, 0x04, 0x00, 0x01, 0x20, 0x00, 0x10, 0x20, 0x08, 0x00, 0x00, 0x00, 0x80, 0x09, 0x20, 0x52,
  0x04, 0x00, 0x00, 0x01, 0x30, 0x00, 0x42, 0x10, 0x82, 0x0c, 0x31, 0x54, 0x70, 0x90, 0xa1, 0x03,
  0x60, 0x94, 0x23, 0x02, 0x00, 0x10, 0x08, 0x00, 0x60, 0x01, 0x0c, 0x4d, 0x40, 0x80, 0x1c, 0x84,
  0x01, 0x00, 0xb0, 0xc0, 0x04, 0x20, 0x02, 0x90, 0x48, 0x00, 0x00, 0x01, 0x08, 0x20, 0x20, 0x01,
  0x53, 0x11, 0x12, 0x00, 0x40, 0x60, 0x20, 0x24, 0x80, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x80,
  0xb0, 0xaa, 0x13, 0x95, 0x14, 0x24, 0x4a, 0x30, 0x00, 0x00, 0x8c, 0x12, 0xb2, 0x46, 0xf4, 0x40,
  0x05, 0x0c, 0x14, 0x82, 0xde, 0xa0, 0xa0, 0x4b, 0x29, 0x15, 0x22, 0x18, 0x43, 0x36, 0x43, 0xa2,
  0xe8, 0x02, 0x8b, 0x74, 0x80, 0x98, 0x10, 0x40, 0x40, 0x43, 0x00, 0xa8, 0x02, 0x09, 0x89, 0x04,
  0x80, 0x20, 0xb2, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x42, 0xa8, 0x04, 0x20, 0x40, 0x30, 0x00, 0x60,
  0x20, 0x28, 0x00, 0x06, 0xe1, 0xf9, 0x9b, 0x9d, 0xf9, 0xa0, 0x50, 0x2a, 0xba, 0x24, 0x08, 0x1c,
  0x0d, 0xa4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x10, 0x99, 0x00,
  0x04, 0x20, 0x00, 0x40, 0x10, 0x80, 0x10, 0x22, 0x02, 0x19, 0x00, 0x14, 0x50, 0x81, 0x10, 0x00,
  0x00, 0x21, 0x80, 0x02, 0x00, 0x20, 0x84, 0x00, 0x29, 0xe0, 0x00, 0x41, 0x80, 0x00, 0x0a, 0x00,
  0x41, 0x24, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x80, 0x3c, 0x20, 0x01, 0x00, 0x10, 0x00, 0x92,
  0x14, 0x40, 0x3c, 0x1f, 0x03, 0x61, 0x10, 0xd3, 0x0c, 0x46, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x18, 0x12, 0x85, 0xe0, 0x00, 0x24, 0x02, 0x48, 0x00, 0x02, 0x34, 0xa1, 0x44,
  0xf6, 0x95, 0xcd, 0x67, 0xf0, 0x02, 0x64, 0x8a, 0x61, 0x36, 0xdc, 0x4e, 0xd0, 0x47, 0x25, 0xad,
  0xf9, 0xa1, 0x44, 0x40, 0x32, 0xa1, 0xc4, 0x80, 0x40, 0x20, 0x00, 0x02, 0x40, 0x84, 0x04, 0x04,
  0x20, 0x00, 0x24, 0x40, 0x01, 0x04, 0x20, 0x00, 0x00, 0x7e, 0x20, 0x00, 0x20, 0x68, 0x05, 0x80,
  0x01, 0x54, 0x20, 0x08, 0x00, 0x1b, 0x4c, 0x00, 0x81, 0x5f, 0xc1, 0x8c, 0x11, 0x20, 0x04, 0x00,
  0x00, 0x04, 0xe1, 0x02, 0x00, 0x00, 0x08, 0x21, 0x84, 0x40, 0x01, 0x12, 0x2e, 0x00, 0x00, 0x00,
  0x94, 0x00, 0x52, 0x88, 0x00, 0x00, 0x13, 0x40, 0x00, 0x09, 0x20, 0x00, 0x08, 0x20, 0x00, 0x88,
  0x08, 0x00, 0x80, 0xa3, 0xea, 0x93, 0x00, 0x00, 0x00, 0xb4, 0x08, 0x10, 0x00, 0x02, 0x04, 0x0a,
  0x00, 0x08, 0x0a, 0x20, 0x11, 0x0c, 0x80, 0x00, 0x10, 0x00, 0x40, 0x02, 0x48, 0x00, 0x02, 0x00,
  0x08, 0x00, 0x00, 0x80, 0x04, 0x10, 0x04, 0x80, 0x08, 0x00, 0x60, 0x10, 0x00, 0x00, 0x00, 0x05,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x90, 0x51, 0x78, 0x80, 0x1c, 0x84, 0x40, 0x18, 0x01, 0x20, 0x0e, 0x08, 0x60, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x40, 0x22, 0x20, 0x11, 0xa8, 0x1c, 0x80, 0x1f, 0x38, 0x20, 0x97, 0x84,
  0x06, 0x36, 0x0c, 0xd8, 0x11, 0xa0, 0x41, 0x10, 0xcf, 0x5e, 0x06, 0x58, 0x30, 0xe1, 0xa3, 0x50,
  0x83, 0x00, 0x52, 0x4a, 0x01, 0x00, 0xa0, 0x44, 0x28, 0x80, 0x42, 0x0a, 0x60, 0x44, 0x09, 0x20,
  0x00, 0x15, 0x00, 0x00, 0x80, 0x94, 0x00, 0x00, 0x02, 0x10, 0x10, 0x08, 0x00, 0x00, 0x12, 0x11,
  0xf6, 0xa8, 0xf1, 0x80, 0x00, 0x04, 0x80, 0xd0, 0x02, 0x0e, 0x08, 0xa2, 0x05, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x40, 0x00, 0x09, 0x00, 0x00, 0x19, 0x60, 0x07, 0x08, 0x0e,
  0x10, 0x68, 0x90, 0x82, 0x80, 0x80, 0x00, 0x00, 0x04, 0x5c, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x44, 0x04, 0x8e, 0x58, 0x40, 0x40, 0x00, 0xe4, 0x45, 0x00, 0x04, 0x40, 0x01,
  0x40, 0x83, 0x00, 0x40, 0x00, 0x10, 0x83, 0x00, 0x94, 0x04, 0x05, 0x31, 0x24, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x18, 0x80, 0x04, 0x02, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x20, 0x01, 0x20, 0x40, 0x08, 0x7c, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00,
  0x00, 0x02, 0x40, 0x01, 0x00, 0x12, 0x00, 0x00, 0x00, 0x40, 0x02, 0x00, 0x08, 0x80, 0x00, 0x00,
  0x00, 0x04, 0xa4, 0x00, 0x04, 0x00, 0x20, 0x10, 0x01, 0x40, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x40, 0x1a, 0x00,
  0x00, 0x40, 0x00, 0x10, 0x02, 0x80, 0x00, 0x10, 0x00, 0x00, 0x40, 0x04, 0xc0, 0x08, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x08, 0x00, 0x08, 0x00, 0x01, 0x00, 0x00, 0x00, 0x20, 0xe0,
  0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x45,
  0x00, 0x00, 0x31, 0x05, 0x04, 0x00, 0x0c, 0x12, 0x10, 0x06, 0x48, 0x9a, 0x00, 0x80, 0x08, 0x00,
  0x01, 0x82, 0x10, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x32, 0x20, 0x01, 0x41, 0x28, 0x01, 0x00,
  0x00, 0x04, 0x84, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x00, 0x00, 0x00,
  0x00
}; // n=17176

// Codepage cp950
static const unsigned char gs_cp950_table[] =
{
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0xc1, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x74, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7f, 0xff, 0xdf, 0xc0, 0x7f, 0xff, 0xdf, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x18, 0xcc, 0x07, 0x00, 0x24, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00,
  0x00, 0x00, 0xf3, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x23, 0x94, 0x72, 0x0c, 0x00, 0x00, 0x00, 0x20, 0x00, 0xc3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x40, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xa0, 0x08, 0x88, 0x88, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00,
  0x7f, 0xff, 0x1c, 0x00, 0xc0, 0x00, 0x30, 0x0c, 0x03, 0x13, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xf0, 0xff, 0xec, 0x06, 0x7f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x00, 0x0e, 0x40, 0x00, 0x00, 0x00, 0x08, 0x02, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xd1, 0xff, 0xce, 0xc3, 0x02, 0x16, 0xf0, 0xd8, 0x35, 0x97, 0x32, 0xcf, 0x00, 0x40, 0x10, 0x03,
  0x3a, 0x9e, 0x7c, 0x53, 0x6e, 0x9e, 0x12, 0x60, 0xfb, 0xf4, 0x0f, 0xef, 0x5c, 0xc0, 0xff, 0x15,
  0xec, 0xf7, 0xfc, 0xc4, 0x20, 0x0d, 0x9a, 0xbf, 0x53, 0xcf, 0xff, 0xff, 0xf9, 0x7b, 0x9f, 0xff,
  0xff, 0xd5, 0xef, 0xbe, 0x00, 0x03, 0x37, 0x71, 0xfd, 0x77, 0xdb, 0xff, 0xc0, 0x0b, 0x5f, 0xa2,
  0x87, 0x5f, 0x7f, 0xfb, 0xf7, 0xfd, 0xd5, 0x08, 0xd7, 0xff, 0x55, 0x3f, 0xfc, 0xf7, 0xbf, 0x24,
  0xb5, 0x1e, 0x6e, 0xfe, 0x30, 0x0f, 0xff, 0xb7, 0x6f, 0xf3, 0x5f, 0x34, 0x9f, 0xef, 0xd6, 0xd7,
  0xbf, 0xf8, 0xfd, 0xa9, 0xee, 0x66, 0xfd, 0xfd, 0xdf, 0xdc, 0x2d, 0x7f, 0x75, 0xde, 0x47, 0x88,
  0x81, 0x65, 0x7d, 0x82, 0xac, 0x28, 0xc3, 0x4e, 0x0e, 0xbe, 0x89, 0x8e, 0xc0, 0x00, 0xd6, 0xe4,
  0xd3, 0xea, 0xf3, 0x0e, 0x4c, 0xe2, 0xf7, 0xb0, 0x5b, 0x7e, 0x2e, 0x3f, 0x60, 0x7f, 0x2d, 0xbd,
  0xf9, 0xfc, 0x53, 0xd1, 0x92, 0x7e, 0x00, 0x1a, 0xf1, 0x44, 0x37, 0xd7, 0x3a, 0x51, 0xdd, 0xbb,
  0x06, 0xf7, 0xe7, 0x6d, 0xf0, 0x25, 0xc9, 0x4f, 0xdd, 0xec, 0x79, 0x2a, 0xd2, 0x0b, 0xf5, 0xd9,
  0x28, 0x23, 0x2b, 0xef, 0x0d, 0x0c, 0x28, 0x50, 0x10, 0xf4, 0x0b, 0x11, 0x7e, 0xff, 0xf4, 0x98,
  0x5b, 0xff, 0xe0, 0xdf, 0x8f, 0xfe, 0xd7, 0xde, 0xf7, 0xa3, 0x08, 0x00, 0xff, 0x99, 0xff, 0xbf,
  0xeb, 0x9e, 0xe6, 0xa0, 0xe7, 0xff, 0xd3, 0xbf, 0xff, 0xc3, 0x02, 0x02, 0xef, 0xf6, 0x71, 0xbd,
  0x5f, 0xfb, 0xe9, 0x20, 0x03, 0x2f, 0xff, 0xda, 0xde, 0xb7, 0xe7, 0x0b, 0x7e, 0x20, 0x07, 0x1f,
  0xf9, 0xff, 0x7c, 0xed, 0x7f, 0xbe, 0x74, 0x11, 0xbf, 0xff, 0xfe, 0x7d, 0x7f, 0xc1, 0x23, 0x6f,
  0xea, 0xcf, 0xbf, 0x1d, 0x01, 0x6b, 0xbe, 0xf7, 0xe6, 0xea, 0x11, 0xe2, 0xbe, 0xff, 0xfb, 0xc3,
  0xff, 0x0f, 0x95, 0xec, 0x07, 0xbe, 0x3f, 0x0e, 0xf6, 0xfc, 0x59, 0x37, 0xcd, 0x32, 0x81, 0x61,
  0x79, 0xfc, 0x3a, 0xbb, 0xb0, 0xef, 0x98, 0x12, 0xc5, 0x7f, 0xe0, 0x00, 0x6a, 0xf5, 0xff, 0x1c,
  0xb0, 0x19, 0x1d, 0xf7, 0xbc, 0x02, 0x06, 0xed, 0x73, 0x1b, 0xac, 0x09, 0xfd, 0x4e, 0xff, 0xfc,
  0xef, 0xfe, 0x88, 0x5e, 0xdd, 0xef, 0xff, 0xd5, 0x00, 0xff, 0x7d, 0xf6, 0x3c, 0x95, 0x4e, 0x7f,
  0xf7, 0xf3, 0xd8, 0x8f, 0xd6, 0xdb, 0x50, 0x3f, 0x67, 0xc3, 0x7e, 0xf7, 0x39, 0xd9, 0x08, 0x6f,
  0x12, 0x0f, 0x2f, 0x68, 0xad, 0x7f, 0x41, 0x8a, 0x8d, 0xe3, 0xdd, 0xa8, 0xe1, 0x76, 0xfb, 0xdf,
  0xfc, 0x27, 0xb3, 0xc6, 0xff, 0x83, 0x7e, 0x7e, 0xd7, 0xbf, 0xfa, 0xbe, 0xde, 0xee, 0x7f, 0x3f,
  0xd0, 0x69, 0x57, 0xdb, 0x94, 0x46, 0x17, 0xca, 0xfb, 0xec, 0xf7, 0xbf, 0xaf, 0x6c, 0x81, 0xbd,
  0x18, 0x3b, 0xbd, 0x3f, 0x27, 0x4b, 0xff, 0xff, 0xeb, 0xfc, 0x07, 0xff, 0xf6, 0xfe, 0x1f, 0xf5,
  0x75, 0xd9, 0x9b, 0x76, 0xdf, 0xaf, 0xa8, 0x8f, 0x95, 0x9e, 0xdf, 0xbd, 0x3c, 0x5a, 0xf5, 0xb5,
  0x5d, 0xdb, 0x35, 0xf8, 0x3f, 0x8e, 0x9e, 0xc1, 0xef, 0x3e, 0xfa, 0xc3, 0xff, 0xfb, 0xe6, 0xa0,
  0x59, 0xff, 0xe6, 0x21, 0x2c, 0xa8, 0xd1, 0xfb, 0xcf, 0x9f, 0xce, 0xcc, 0xbd, 0xef, 0x58, 0x7a,
  0x02, 0xfd, 0xfc, 0x05, 0xff, 0xff, 0xd7, 0x80, 0x03, 0xfb, 0xbb, 0xf3, 0x00, 0xae, 0xcb, 0xd5,
  0xc3, 0x1f, 0x6b, 0x77, 0xbf, 0xc2, 0xff, 0xed, 0xf5, 0x7a, 0xe4, 0x42, 0x35, 0xd9, 0x61, 0x6f,
  0xeb, 0xe4, 0x3d, 0x6f, 0xe1, 0xef, 0xed, 0xac, 0xb3, 0x55, 0x6e, 0x87, 0xe7, 0x92, 0xf9, 0x47,
  0x3a, 0x2a, 0x4f, 0xf5, 0xfc, 0xd4, 0x1b, 0x86, 0xdc, 0x3f, 0x1d, 0xdd, 0xf3, 0xff, 0xbe, 0xde,
  0xa9, 0xfd, 0x07, 0x38, 0xbf, 0xbe, 0xff, 0xc2, 0x6f, 0xfa, 0x7f, 0xff, 0xf7, 0xcb, 0x73, 0x23,
  0x6d, 0xb1, 0x3d, 0xb5, 0x3b, 0xc6, 0xd7, 0x88, 0x9a, 0xfb, 0x0b, 0xc4, 0x2d, 0x7d, 0xdb, 0xcf,
  0xe7, 0xf8, 0xe3, 0xdb, 0xc6, 0xff, 0x27, 0x5f, 0xd4, 0x4d, 0xef, 0xc6, 0xdc, 0xb7, 0x5d, 0xb5,
  0x80, 0x7f, 0xff, 0x7e, 0xef, 0xff, 0x3d, 0x40, 0xff, 0x4c, 0xbc, 0xf7, 0x3f, 0xff, 0xa0, 0x01,
  0xdf, 0xee, 0xaf, 0x3d, 0xb0, 0x80, 0xef, 0xff, 0xdf, 0xff, 0x5c, 0xfd, 0xea, 0x00, 0xff, 0xfb,
  0xde, 0xf7, 0xbe, 0xbd, 0x11, 0xdb, 0x2b, 0x13, 0xcf, 0xff, 0x3e, 0xb7, 0x77, 0xba, 0xff, 0x6a,
  0xb0, 0x7e, 0xfa, 0x35, 0x69, 0xff, 0xfe, 0xab, 0x77, 0xfc, 0x02, 0x83, 0x9f, 0xf6, 0xe7, 0xff,
  0xd9, 0xee, 0xee, 0x71, 0xfd, 0x76, 0xba, 0x27, 0xf3, 0xf6, 0xf8, 0xfa, 0xfe, 0x07, 0xfb, 0x7f,
  0xdb, 0xeb, 0x7f, 0x80, 0x00, 0xff, 0xde, 0xdf, 0x2b, 0xff, 0xfb, 0xf8, 0x00, 0x1f, 0xff, 0xff,
  0xf1, 0xdf, 0xde, 0x00, 0x00, 0xfd, 0x3a, 0xfe, 0xff, 0xff, 0xcf, 0xe0, 0x05, 0xd7, 0xe7, 0xbc,
  0xfd, 0xef, 0xeb, 0xdf, 0xfd, 0xff, 0xc0, 0x06, 0xbf, 0xff, 0xb7, 0xfd, 0xdd, 0xf7, 0xfe, 0x40,
  0x02, 0x7f, 0xbf, 0xbb, 0xff, 0xbf, 0x9f, 0x47, 0xd0, 0x16, 0xf8, 0xdf, 0xc7, 0xdf, 0xbf, 0xf5,
  0x25, 0xf9, 0xb7, 0xef, 0xbe, 0x5e, 0xf0, 0x1f, 0x7d, 0x77, 0xab, 0xf0, 0xba, 0xdd, 0xf9, 0xbf,
  0xdb, 0x4f, 0x9f, 0xdc, 0xfe, 0x7f, 0x33, 0xd7, 0x56, 0xe1, 0x5f, 0xce, 0x3f, 0xa9, 0x3f, 0xf9,
  0xf9, 0x08, 0xef, 0x5f, 0xed, 0xbb, 0xb3, 0xdd, 0x7e, 0x1f, 0xb3, 0x37, 0x66, 0xcf, 0xfc, 0x3c,
  0xbf, 0xff, 0xfc, 0x0d, 0xef, 0x97, 0x7e, 0x60, 0x75, 0x69, 0x60, 0x7f, 0x6e, 0xab, 0xeb, 0xfa,
  0x8b, 0xfc, 0xcf, 0xc5, 0xe0, 0xf3, 0xed, 0xf6, 0x8b, 0xf9, 0x22, 0xfe, 0x9a, 0xde, 0xbb, 0xcb,
  0xdc, 0xf5, 0xbd, 0x95, 0xf3, 0xbe, 0x5c, 0xff, 0x07, 0xdf, 0xd7, 0x6f, 0x80, 0x2d, 0xff, 0xff,
  0x5f, 0x5e, 0xfd, 0xed, 0x00, 0x03, 0xbf, 0xf0, 0xfe, 0xff, 0xf8, 0xff, 0x3f, 0x7f, 0xff, 0xa9,
  0x00, 0x00, 0x3b, 0xad, 0xc6, 0xf7, 0x7c, 0xfc, 0xfe, 0xdf, 0xd8, 0x00, 0x00, 0x17, 0x6f, 0xdf,
  0xf7, 0x79, 0xfb, 0x1d, 0xf9, 0xff, 0xfc, 0x00, 0x0b, 0xde, 0xff, 0xaf, 0xdb, 0xfb, 0xff, 0xfc,
  0x0f, 0xbf, 0xfd, 0x00, 0x04, 0x21, 0xbd, 0xdd, 0xec, 0xfb, 0x7b, 0xff, 0xb6, 0xff, 0xcf, 0xf0,
  0x32, 0x06, 0xdf, 0x7a, 0xdf, 0xff, 0xdf, 0x5f, 0x7a, 0x7f, 0x98, 0x40, 0x2f, 0x9e, 0x7b, 0x9f,
  0xef, 0xe5, 0x5f, 0xd7, 0xd7, 0x80, 0x2c, 0xff, 0xcb, 0xd7, 0xce, 0xf7, 0xeb, 0xf5, 0x02, 0x03,
  0xdd, 0x4e, 0xff, 0x3b, 0xfe, 0x8f, 0x1b, 0xf4, 0x37, 0x1d, 0xd0, 0x7f, 0xc5, 0xbb, 0xd0, 0xf8,
  0xb8, 0xf1, 0xf3, 0xe2, 0xd4, 0x8d, 0x7b, 0xff, 0x77, 0xfe, 0xce, 0x5b, 0xff, 0x24, 0x23, 0xd3,
  0xba, 0xef, 0x4f, 0xd3, 0xbf, 0x37, 0xb7, 0x2d, 0x9f, 0xfd, 0xbb, 0xb2, 0xbb, 0x99, 0xb1, 0xdf,
  0xfe, 0xdd, 0xde, 0xf5, 0xdf, 0xbb, 0x9a, 0x93, 0xf2, 0x3f, 0xad, 0x5f, 0xc7, 0xf5, 0xfa, 0xb6,
  0xff, 0xff, 0xbe, 0xfc, 0x00, 0x1e, 0xdb, 0xff, 0xff, 0x6d, 0xff, 0x7e, 0xf5, 0xdf, 0xf4, 0x40,
  0xd9, 0xff, 0xe3, 0xf7, 0xa5, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0xe3, 0xff, 0xef, 0x8f, 0xff,
  0xbf, 0xfe, 0xfd, 0x80, 0x00, 0x3b, 0x3d, 0xbf, 0xaf, 0xfd, 0xff, 0xff, 0xfe, 0xff, 0xff, 0x7c,
  0x94, 0x00, 0x00, 0x7d, 0xff, 0x9f, 0xfe, 0xff, 0xdf, 0x76, 0x7e, 0xbf, 0xff, 0xd3, 0x79, 0xc0,
  0x00, 0xc7, 0xbb, 0xdf, 0xff, 0x33, 0xfb, 0x6f, 0xff, 0xff, 0xfe, 0x88, 0x00, 0x1f, 0x6f, 0xdf,
  0xf7, 0xe7, 0x3c, 0xeb, 0xf7, 0x7f, 0xf7, 0xfb, 0xd0, 0x03, 0xfd, 0xb7, 0xfb, 0x7f, 0xb3, 0xbf,
  0xaf, 0xde, 0xbf, 0x02, 0xff, 0xff, 0xfa, 0xed, 0xfb, 0xff, 0x0c, 0x9f, 0xfb, 0xdf, 0xe9, 0x3b,
  0xcf, 0x7f, 0x4f, 0xfd, 0xfb, 0xf1, 0xfd, 0xfb, 0xfe, 0xe8, 0x67, 0xb7, 0xfe, 0xf0, 0xca, 0xac,
  0x3e, 0x22, 0x7e, 0xe1, 0x48, 0x5f, 0xdd, 0xa2, 0x07, 0xb7, 0x79, 0xee, 0xe8, 0x01, 0x9b, 0xfd,
  0xaa, 0x7e, 0x91, 0x7b, 0xf6, 0x83, 0xe2, 0x20, 0x7b, 0x5e, 0xba, 0xef, 0xff, 0xea, 0xa0, 0x94,
  0xef, 0x61, 0xa9, 0x7f, 0xcd, 0xe9, 0xf4, 0xcf, 0xff, 0xf3, 0xae, 0xf9, 0xef, 0x8e, 0xe8, 0xdf,
  0x77, 0x2c, 0x98, 0x77, 0x33, 0xec, 0x86, 0xf7, 0x6b, 0xf9, 0x32, 0xf7, 0xf1, 0x6b, 0xbb, 0xdf,
  0xce, 0xde, 0xf7, 0xb6, 0x7f, 0xeb, 0x8c, 0x25, 0xfe, 0x7a, 0xeb, 0xe9, 0xda, 0xf0, 0x1b, 0xff,
  0xc1, 0xb9, 0x73, 0xde, 0x37, 0x44, 0xff, 0x3b, 0xbc, 0x6e, 0xe1, 0xf7, 0xe7, 0xfb, 0xb7, 0xbf,
  0xff, 0xf2, 0x3f, 0x05, 0xee, 0xdc, 0x3f, 0xdb, 0xb7, 0xbc, 0x3b, 0xfe, 0x95, 0xf6, 0x0e, 0xaf,
  0xdf, 0xfc, 0x02, 0x34, 0xfe, 0xff, 0xfe, 0x21, 0xea, 0x37, 0xed, 0x7b, 0x39, 0x67, 0xf4, 0x4f,
  0xd7, 0xf0, 0xad, 0xab, 0xd7, 0xf5, 0xe7, 0xb7, 0xf4, 0x31, 0x0f, 0xff, 0xfe, 0xca, 0x0f, 0x17,
  0xb9, 0x9d, 0xff, 0xad, 0x66, 0xff, 0xf1, 0xe7, 0x81, 0x9b, 0x08, 0x7d, 0x3e, 0x39, 0x83, 0xc7,
  0x8b, 0x39, 0xcc, 0xe4, 0x3d, 0x30, 0xb6, 0xff, 0xed, 0x3f, 0xed, 0xf7, 0xfb, 0x05, 0xff, 0xff,
  0xd0, 0xfd, 0xde, 0x7f, 0xff, 0xc5, 0xfc, 0xac, 0x33, 0xc8, 0xb3, 0xe9, 0xec, 0x6e, 0xe4, 0xdf,
  0x6b, 0xf3, 0x36, 0x7e, 0x0a, 0x37, 0x8c, 0xb7, 0x3e, 0xe6, 0x38, 0x3f, 0x5f, 0x6f, 0xfd, 0xfa,
  0x5d, 0xf0, 0xf4, 0x75, 0xb5, 0xc5, 0x7f, 0xfe, 0x0f, 0x3f, 0x2e, 0x7b, 0xf7, 0xff, 0x00, 0x4f,
  0xfd, 0xdf, 0x45, 0x7f, 0xf5, 0xbc, 0xff, 0x3d, 0x29, 0x6f, 0x9d, 0xfa, 0xb5, 0xcf, 0xf1, 0xfc,
  0x36, 0x4f, 0xf8, 0x05, 0xf7, 0xff, 0xfd, 0x80, 0x14, 0xee, 0xa0, 0x0e, 0xac, 0xff, 0xc0, 0x5b,
  0xdf, 0x4b, 0x5f, 0xe3, 0xfd, 0xfc, 0xb8, 0x3a, 0x5c, 0xff, 0xcc, 0x37, 0xf5, 0xed, 0x39, 0x7f,
  0x6c, 0x4a, 0xf9, 0x5e, 0x5f, 0xfd, 0x44, 0xe7, 0xef, 0xf9, 0xff, 0x3f, 0xdd, 0xf4, 0xb8, 0x6d,
  0x60, 0xb7, 0xbf, 0xb8, 0xeb, 0xbe, 0xfb, 0xf7, 0xc4, 0xd7, 0x66, 0x8f, 0x9b, 0x7e, 0x03, 0xb0,
  0xbc, 0xbc, 0xfd, 0xfb, 0xa2, 0x93, 0xc1, 0x5d, 0x8b, 0xbe, 0x0b, 0xb9, 0xe1, 0xde, 0xce, 0xf3,
  0xcf, 0xf9, 0xaf, 0xc3, 0xb0, 0xfb, 0x7f, 0xa3, 0xcd, 0x30, 0x40, 0xc1, 0x9e, 0x17, 0x03, 0x75,
  0xce, 0xe3, 0xf0, 0xf6, 0xbe, 0xbf, 0xfc, 0x90, 0x8f, 0xff, 0xea, 0x80, 0xdf, 0x46, 0xff, 0x80,
  0x2d, 0xbf, 0xcf, 0xdc, 0xc8, 0x0d, 0x4d, 0xc2, 0xcb, 0x7a, 0x0c, 0xff, 0xff, 0xf0, 0xf9, 0xd7,
  0xf7, 0x7f, 0xc0, 0x4f, 0xf7, 0xfc, 0x91, 0xdf, 0x95, 0xec, 0x99, 0x79, 0x9f, 0x7b, 0x34, 0xe5,
  0xcc, 0xec, 0x6f, 0x83, 0x75, 0x81, 0x7c, 0x7f, 0x04, 0xba, 0xef, 0x4f, 0xa1, 0xab, 0xeb, 0x96,
  0xff, 0xff, 0xff, 0xff, 0xe0, 0xdb, 0xf6, 0xff, 0xff, 0x23, 0xfe, 0x9b, 0x73, 0xf7, 0xf0, 0x7d,
  0xde, 0x8f, 0x7a, 0x0f, 0xf3, 0x6f, 0xed, 0xff, 0xef, 0x7a, 0x21, 0xf7, 0xd3, 0xeb, 0xfb, 0x70,
  0x10, 0xff, 0xff, 0x3f, 0xfc, 0x77, 0xff, 0xff, 0xff, 0xc8, 0xff, 0xeb, 0xf0, 0xf5, 0xbf, 0xfe,
  0xe3, 0xbd, 0x5f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xe7, 0x1c, 0xbd, 0xcc, 0x9f, 0xd7, 0xfe, 0xb7, 0x7f,
  0x17, 0xfe, 0x6e, 0x3e, 0xef, 0xcd, 0xf7, 0xff, 0xf5, 0x7f, 0xed, 0x1b, 0xf6, 0xff, 0xfd, 0xdf,
  0xdf, 0x1f, 0xef, 0xdb, 0x4a, 0xe8, 0x9f, 0x47, 0x13, 0xa1, 0xe2, 0xae, 0x09, 0x09, 0xf7, 0xc7,
  0x2f, 0x79, 0xb6, 0xfc, 0x74, 0x77, 0x6c, 0xa0, 0x3d, 0xef, 0xcf, 0xfe, 0xde, 0x05, 0xfc, 0xfe,
  0xe6, 0xa0, 0x06, 0xd7, 0x7d, 0x5d, 0x80, 0x66, 0x1b, 0x3f, 0xfc, 0x1a, 0xef, 0x53, 0xfb, 0xe1,
  0xb3, 0xfd, 0x05, 0xff, 0xb3, 0xda, 0xfd, 0x7f, 0xbf, 0x6d, 0xe5, 0xf7, 0xf7, 0xee, 0x39, 0xfb,
  0xed, 0xfc, 0xee, 0x1f, 0xe4, 0xb9, 0x3f, 0xed, 0xad, 0x53, 0xf7, 0xfb, 0x5a, 0xdf, 0x6d, 0x8f,
  0x9c, 0x37, 0xf8, 0xf7, 0xfd, 0xdf, 0xdf, 0xfe, 0xb0, 0x00, 0x7f, 0x5b, 0xdf, 0xbd, 0xfe, 0x72,
  0xff, 0xcc, 0x03, 0x5a, 0xaf, 0xfd, 0x7f, 0xf9, 0xfd, 0xff, 0xfa, 0x00, 0x00, 0x00, 0x1f, 0xbf,
  0x53, 0xff, 0xbf, 0xf6, 0xbf, 0xf3, 0x80, 0x05, 0xff, 0xfb, 0x4f, 0xdf, 0xfd, 0xfb, 0xfe, 0xff,
  0x5b, 0x7f, 0xf0, 0x10, 0x10, 0x5d, 0xff, 0xfd, 0xbf, 0x5e, 0xeb, 0x77, 0xd7, 0xdf, 0x9f, 0xe6,
  0x22, 0x07, 0xc9, 0xff, 0xe9, 0xfb, 0xea, 0xf9, 0xef, 0x7f, 0xfb, 0x10, 0x01, 0xfb, 0xfb, 0x7f,
  0xa3, 0xff, 0x7f, 0xef, 0xdf, 0xff, 0xc0, 0x16, 0xdf, 0xe6, 0x5f, 0xd6, 0xff, 0xfe, 0x47, 0xfa,
  0xff, 0xff, 0xce, 0xff, 0xfb, 0xe1, 0xdf, 0xe7, 0xbf, 0xd7, 0xe5, 0xef, 0x7e, 0xfd, 0xe3, 0xf7,
  0xcf, 0x78, 0x41, 0xfb, 0xff, 0x6e, 0x7e, 0xfb, 0x93, 0x9e, 0xbe, 0x5b, 0x7d, 0xf7, 0xd9, 0x78,
  0x07, 0x3e, 0xdf, 0xee, 0x7d, 0xe1, 0xdf, 0xff, 0xff, 0xd8, 0xdb, 0xff, 0x3a, 0xfc, 0x07, 0xf2,
  0xff, 0xfe, 0x70, 0xfa, 0xff, 0xee, 0xfd, 0xbb, 0xf2, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xf0,
  0x7d, 0xc5, 0xfb, 0xbf, 0x38, 0x3f, 0xbf, 0xff, 0xbe, 0xf8, 0x79, 0xdf, 0xff, 0xbd, 0x3b, 0x7b,
  0xf6, 0xfc, 0xdf, 0x5d, 0xfe, 0xfb, 0xf7, 0xdf, 0xd8, 0xbe, 0x37, 0x74, 0x71, 0xf5, 0xef, 0x4f,
  0xf0, 0xde, 0x77, 0xf3, 0x69, 0xb8, 0x63, 0xee, 0xe0, 0x7f, 0xaf, 0xff, 0x41, 0x9b, 0xfb, 0xfe,
  0x67, 0x7a, 0xff, 0xe3, 0x77, 0x7f, 0xf7, 0x9e, 0x6a, 0x59, 0xf3, 0xff, 0xfa, 0x7f, 0x7a, 0x7b,
  0x76, 0x91, 0x17, 0x9f, 0x7a, 0x2f, 0x23, 0x67, 0x80, 0x00, 0x3e, 0x7d, 0xfe, 0xdc, 0xfb, 0xbb,
  0xb9, 0xab, 0xf7, 0x97, 0x35, 0x2c, 0xca, 0x7b, 0xce, 0xaf, 0xef, 0xd2, 0xf2, 0xde, 0xff, 0x79,
  0x7f, 0x1d, 0x76, 0xe2, 0xdf, 0xb0, 0xa2, 0xff, 0xbf, 0xd5, 0x7f, 0xdf, 0xeb, 0x97, 0xff, 0xbb,
  0xef, 0xb7, 0xff, 0xfe, 0xbf, 0xbb, 0xd7, 0x7e, 0xe7, 0xf3, 0xff, 0xed, 0x97, 0xbd, 0x89, 0xf7,
  0xae, 0xba, 0x3e, 0xeb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5f, 0x77, 0xff, 0x8f, 0x2d, 0x6e, 0xfd, 0xf7, 0xf4,
  0xee, 0x6d, 0xfd, 0xee, 0xfd, 0xf9, 0xbf, 0xff, 0xfd, 0xa9, 0x75, 0x6f, 0xff, 0xae, 0xdc, 0xfe,
  0xaf, 0xe5, 0x9f, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0xdf, 0xbb, 0xd4,
  0xcc, 0x6f, 0xfe, 0x59, 0xd5, 0xbf, 0x3f, 0x6b, 0x67, 0x9f, 0xd7, 0xfd, 0xfb, 0xfb, 0xf8, 0x2f,
  0xbf, 0x65, 0xff, 0xff, 0xff, 0x52, 0xde, 0xcf, 0xed, 0xfe, 0x9f, 0x7f, 0xff, 0x6d, 0x3a, 0xb8,
  0x6f, 0xfe, 0xff, 0xa7, 0xde, 0xf8, 0x20, 0x24, 0xa0, 0x7d, 0x79, 0x9f, 0xc7, 0xdb, 0x4f, 0xfb,
  0xf7, 0xf6, 0xff, 0xbf, 0x9e, 0x6b, 0x3f, 0xd3, 0xbf, 0xd7, 0xff, 0xf7, 0xf8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x19, 0x12, 0x87, 0xe8, 0x01, 0x2e, 0x56, 0x7f, 0x00, 0xfe, 0xb6, 0x8f, 0xbf,
  0xfe, 0x1d, 0xcf, 0x7f, 0xf8, 0x07, 0x6e, 0x8f, 0x69, 0x77, 0xfc, 0xde, 0xb1, 0xd7, 0xbf, 0xff,
  0xff, 0xb5, 0xcd, 0xd3, 0xf7, 0x21, 0xfe, 0x87, 0x55, 0xb2, 0x0f, 0xfd, 0xfc, 0xfd, 0xfc, 0x7f,
  0xff, 0xd7, 0xeb, 0xff, 0xfb, 0xff, 0xfe, 0xf3, 0xdf, 0xff, 0xb7, 0xa1, 0xfc, 0xeb, 0x3d, 0xe0,
  0xff, 0x75, 0xf0, 0x7f, 0xf5, 0xbf, 0xfd, 0x6e, 0xf7, 0x5f, 0xdd, 0xec, 0x3b, 0xfe, 0x5d, 0xc5,
  0xff, 0x6d, 0xef, 0x6a, 0x1f, 0x06, 0xfb, 0xe7, 0x86, 0xff, 0xfb, 0x32, 0xdf, 0x0d, 0xa2, 0xff,
  0xb7, 0xbe, 0x5f, 0xfc, 0xff, 0xf8, 0x3f, 0x58, 0xff, 0xff, 0xf5, 0xc7, 0xcb, 0xe3, 0xc1, 0xfb,
  0xea, 0xdf, 0xbe, 0xf7, 0xff, 0xf7, 0x1e, 0xc8, 0x03, 0x7f, 0xef, 0xfa, 0xdd, 0x2c, 0xc7, 0x7a,
  0xb0, 0xef, 0x6f, 0xf7, 0x7f, 0xeb, 0xfd, 0x00, 0xb9, 0xaf, 0xef, 0xef, 0x7b, 0x8a, 0x07, 0xff,
  0x93, 0x7f, 0xfe, 0xc0, 0x80, 0xfa, 0xf7, 0xfd, 0x8f, 0xf9, 0xe5, 0x06, 0xb8, 0xf7, 0xff, 0x8f,
  0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3c,
  0xb2, 0xdf, 0xf8, 0x9b, 0x5c, 0xde, 0xc7, 0x7f, 0x97, 0xfc, 0xfe, 0x3b, 0xfc, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0a, 0xf8, 0xaf, 0xe0, 0x7d, 0xb8, 0x3f, 0xd8, 0x9f, 0x78, 0x3d, 0xff, 0x8e,
  0x9f, 0xf6, 0x7d, 0xda, 0x69, 0xea, 0xd8, 0xd9, 0xff, 0xfe, 0x3f, 0xff, 0x74, 0xe1, 0xe7, 0xf5,
  0xaf, 0xd7, 0xf2, 0xcf, 0xbf, 0xfb, 0xa4, 0xe7, 0x3b, 0xd0, 0x22, 0xba, 0xe2, 0xea, 0xbb, 0xbf,
  0xfc, 0xb7, 0x09, 0xee, 0xfe, 0xbe, 0x13, 0x51, 0x5f, 0x5f, 0x9f, 0xcf, 0x54, 0x04, 0xd2, 0xf7,
  0xff, 0xaf, 0xf3, 0x9e, 0xcb, 0xd5, 0xa5, 0xd0, 0x5e, 0xef, 0xf1, 0xdf, 0xbd, 0x71, 0xf8, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x72, 0xbf, 0xea, 0x58, 0x00, 0x11, 0x35, 0x75, 0x2a, 0x6e,
  0xb5, 0xe8, 0xff, 0xb3, 0x4d, 0xff, 0xf4, 0x2f, 0x55, 0xda, 0xff, 0xdb, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xce, 0x57, 0x9f, 0xfc, 0x74, 0x71, 0x5f, 0xff, 0xdd, 0x3d, 0x6e, 0xcb, 0xff,
  0x7f, 0x77, 0x4e, 0x7e, 0xbd, 0x7e, 0xef, 0xe7, 0xfe, 0xef, 0xbf, 0x73, 0xaf, 0xf0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x95, 0xd9, 0xdb, 0xe3, 0x25, 0xfe, 0x89, 0x53, 0x1f, 0x73, 0x7e,
  0x5e, 0xbe, 0xe7, 0xe3, 0xbd, 0xd3, 0x75, 0x3b, 0x7e, 0xbf, 0x6e, 0xf1, 0xcb, 0x89, 0xcf, 0x3e,
  0xa7, 0x80, 0xf4, 0x32, 0xee, 0xb7, 0x06, 0xc5, 0xdb, 0xe0, 0x1f, 0x7a, 0xef, 0xb8, 0x81, 0x84,
  0x07, 0xd6, 0x39, 0x0c, 0x5c, 0xdc, 0x7b, 0x5f, 0xca, 0xfe, 0xaf, 0xc3, 0xb3, 0x86, 0x5d, 0xe0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x64, 0x7f, 0x7d,
  0x9f, 0xc0, 0xad, 0xd7, 0xb6, 0xc7, 0xd3, 0x97, 0xf4, 0x39, 0x7b, 0xfd, 0xc1, 0xf9, 0xfd, 0xd5,
  0xef, 0xf8, 0xab, 0xff, 0xfb, 0xed, 0x7f, 0xfb, 0x75, 0xbf, 0xf7, 0xff, 0x7e, 0xdf, 0xbf, 0xf7,
  0xff, 0x55, 0xfd, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x6d,
  0xb3, 0xfe, 0x79, 0x7d, 0xcd, 0x46, 0x8f, 0x1a, 0xb0, 0x8f, 0xde, 0xbf, 0x8f, 0x97, 0xbf, 0x7d,
  0xc3, 0x63, 0xb6, 0xfa, 0xbc, 0xff, 0xff, 0x96, 0xf3, 0xff, 0x2f, 0xdf, 0xdf, 0x3b, 0xef, 0xf2,
  0x00, 0x04, 0xec, 0x88, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0xff, 0xf8, 0x7f, 0xef, 0x7f, 0xfe, 0xf0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe9, 0x7f, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00,
  0x00
}; // n=13621

static const struct wxPdfEncodingTableData
{
  const wxChar*         m_encodingName;
  const wxUniRangeDesc* m_encodingTable;
  int                   m_encodingTableSize;
  const unsigned char*  m_encodingBase;
} gs_encodingTableData[] =
{
  { wxS("standard"),     gs_standard_table,  gs_standard_tableSize,  NULL },
  { wxS("winansi"),      gs_cp1252_table,    gs_cp1252_tableSize,    NULL },
  { wxS("macroman"),     gs_macroman_table,  gs_macroman_tableSize,  NULL },
  { wxS("symbol"),       gs_symbol_table,    gs_symbol_tableSize,    NULL },
  { wxS("zapfdingbats"), gs_zdb_table,       gs_zdb_tableSize,       NULL },
  { wxS("iso-8859-1"),   gs_8859_1_table,    gs_8859_1_tableSize,    NULL },
  { wxS("iso-8859-2"),   gs_8859_2_table,    gs_8859_2_tableSize,    NULL },
  { wxS("iso-8859-3"),   gs_8859_3_table,    gs_8859_3_tableSize,    NULL },
  { wxS("iso-8859-4"),   gs_8859_4_table,    gs_8859_4_tableSize,    NULL },
  { wxS("iso-8859-5"),   gs_8859_5_table,    gs_8859_5_tableSize,    NULL },
  { wxS("iso-8859-6"),   gs_8859_6_table,    gs_8859_6_tableSize,    NULL },
  { wxS("iso-8859-7"),   gs_8859_7_table,    gs_8859_7_tableSize,    NULL },
  { wxS("iso-8859-8"),   gs_8859_8_table,    gs_8859_8_tableSize,    NULL },
  { wxS("iso-8859-9"),   gs_8859_9_table,    gs_8859_9_tableSize,    NULL },
  { wxS("iso-8859-10"),  gs_8859_10_table,   gs_8859_10_tableSize,   NULL },
  { wxS("iso-8859-11"),  gs_8859_11_table,   gs_8859_11_tableSize,   NULL },
  { wxS("iso-8859-13"),  gs_8859_13_table,   gs_8859_13_tableSize,   NULL },
  { wxS("iso-8859-14"),  gs_8859_14_table,   gs_8859_14_tableSize,   NULL },
  { wxS("iso-8859-15"),  gs_8859_15_table,   gs_8859_15_tableSize,   NULL },
  { wxS("iso-8859-16"),  gs_8859_16_table,   gs_8859_16_tableSize,   NULL },
  { wxS("cp-1250"),      gs_cp1250_table,    gs_cp1250_tableSize,    NULL },
  { wxS("cp-1251"),      gs_cp1251_table,    gs_cp1251_tableSize,    NULL },
  { wxS("cp-1252"),      gs_cp1252_table,    gs_cp1252_tableSize,    NULL },
  { wxS("cp-1253"),      gs_cp1253_table,    gs_cp1253_tableSize,    NULL },
  { wxS("cp-1254"),      gs_cp1254_table,    gs_cp1254_tableSize,    NULL },
  { wxS("cp-1255"),      gs_cp1255_table,    gs_cp1255_tableSize,    NULL },
  { wxS("cp-1256"),      gs_cp1256_table,    gs_cp1256_tableSize,    NULL },
  { wxS("cp-1257"),      gs_cp1257_table,    gs_cp1257_tableSize,    NULL },
  { wxS("cp-1258"),      gs_cp1258_table,    gs_cp1258_tableSize,    NULL },
  { wxS("cp-874"),       gs_cp874_table,     gs_cp874_tableSize,     NULL },
  { wxS("koi8-r"),       gs_koi8_r_table,    gs_koi8_r_tableSize,    NULL },
  { wxS("koi8-u"),       gs_koi8_u_table,    gs_koi8_u_tableSize,    NULL },
  { wxS("cp-932"),       NULL,               0,                      gs_cp932_table },
  { wxS("cp-936"),       NULL,               0,                      gs_cp936_table },
  { wxS("cp-949"),       NULL,               0,                      gs_cp949_table },
  { wxS("cp-950"),       NULL,               0,                      gs_cp950_table },
  { NULL,                NULL,               0,                      NULL } // sentinel empty entry
};
