/*
 * Copyright 2009 The Closure Compiler Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.javascript.jscomp;

import com.google.javascript.rhino.Node;

/**
 * A simple listener for code change events.
 * Records whether the code has changed since the last reset.
 * @author nicksantos@google.com (Nick Santos)
 * @author dimvar@google.com (Dimitris Vardoulakis)
 */
class CodeChangeHandler {
  private boolean hasChanged = false;

  /** Report a change to some unspecified node of the AST. */
  public void reportChange() {
    hasChanged = true;
  }

  /** Report a change to a specific function in the AST. */
  public void reportChangedFun(Node n) {
    hasChanged = true;
  }

  /** Report that a function node has been removed from the AST */
  public void reportDeletedFun(Node n) {
    hasChanged = true;
  }

  void reset() {
    hasChanged = false;
  }

  boolean hasCodeChanged() {
    return hasChanged;
  }
}
