%{?mingw_package_header}

# Cross-compilation platforms supported
%global mingw_build_win32    1
%global mingw_build_win64    1

%global mingw32_ldflags  "-Wl,--no-undefined -Wl,--enable-auto-import"
%global mingw64_ldflags  "-Wl,--no-undefined -Wl,--enable-auto-import"

%define		_pkg_name canl-c++

Name:		mingw-%{_pkg_name}
Version:	1.1.0
Release:	1%{?dist}
Summary:	EMI Common Authentication library - bindings for C++

Group:		Development/Libraries
License:	ASL 2.0
URL:		http://www.nordugrid.org/
Source0:	http://download.nordugrid.org/packages/%{_pkg_name}/releases/%{version}/src/%{_pkg_name}-%{version}.tar.gz
BuildRoot:	%(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

BuildArch:	noarch

# mingw32
%if %{mingw_build_win32}
BuildRequires:	mingw32-filesystem >= 65
BuildRequires:	mingw32-binutils
BuildRequires:	mingw32-gcc
BuildRequires:	mingw32-gcc-c++

BuildRequires:	mingw32-nss >= 3.10
BuildRequires:	mingw32-openssl
BuildRequires:	mingw32-cppunit
BuildRequires:	mingw32-glibmm24
BuildRequires:	mingw32-libdb
BuildRequires:	mingw32-pthreads
BuildRequires:	mingw32-libgnurx
%endif

# mingw64
%if %{mingw_build_win64}
BuildRequires:	mingw64-filesystem >= 65
BuildRequires:	mingw64-binutils
BuildRequires:	mingw64-gcc
BuildRequires:	mingw64-gcc-c++

BuildRequires:	mingw64-nss >= 3.10
BuildRequires:	mingw64-openssl
BuildRequires:	mingw64-cppunit
BuildRequires:	mingw64-glibmm24
BuildRequires:	mingw64-libdb
BuildRequires:	mingw64-pthreads
BuildRequires:	mingw64-libgnurx
%endif

%description
This is the C++ part of the EMI caNl -- the Common Authentication
Library.

%if %{mingw_build_win32}
%package -n mingw32-%{_pkg_name}
Group:		Development/Libraries
Summary:	EMI Common Authentication library - development files for C++

%description -n mingw32-%{_pkg_name}
%{description}
%endif

%if %{mingw_build_win64}
%package -n mingw64-%{_pkg_name}
Group:		Development/Libraries
Summary:	EMI Common Authentication library - development files for C++

%description -n mingw64-%{_pkg_name}
%{description}
%endif

%{?mingw_debug_package}

%prep
%setup -q -n %{_pkg_name}-%{version}

%build
%mingw_configure --disable-python-bindings
%mingw_make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%mingw_make_install DESTDIR=%{buildroot}
rm -f %{buildroot}%{mingw32_libdir}/libcanl_c++.la
rm -f %{buildroot}%{mingw64_libdir}/libcanl_c++.la

%clean
rm -rf %{buildroot}

%files -n mingw32-%{_pkg_name}
%defattr(-,root,root,-)
%doc README
%{mingw32_bindir}/libcanl_c++-*.dll
%{mingw32_libdir}/libcanl_c++.dll.a
%{mingw32_includedir}/%{_pkg_name}/canlxx.h
%{mingw32_libdir}/pkgconfig/%{_pkg_name}.pc

%files -n mingw64-%{_pkg_name}
%defattr(-,root,root,-)
%doc README
%{mingw64_bindir}/libcanl_c++-*.dll
%{mingw64_libdir}/libcanl_c++.dll.a
%{mingw64_includedir}/%{_pkg_name}/canlxx.h
%{mingw64_libdir}/pkgconfig/%{_pkg_name}.pc

%changelog
* Tue Apr 29 2014 Anders Waananen <waananen@nbi.dk> - 1.1.0-1
- Initial version
