// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __project_file__
#define __project_file__

#include <map>
using std::map;
#include <string>
using std::string;

#include "Puma/Filename.h"

namespace Puma {
 
// the project file abstraction is used to store all filenames relevant
// for a specific file that is managed by Puma.

class ProjectFile {
  Filename _nick_name;
  Filename _dest_path;
public:  
  ProjectFile (const Filename &nn) : _nick_name (nn) {}
  ProjectFile (const Filename &nn, const Filename &dp) :
    _nick_name (nn), _dest_path (dp) {}
  void dest (const Filename &dp) { _dest_path = dp; }
  Filename name () const { return _nick_name; }
  Filename dest () const { return _dest_path; }
};

typedef map<string, ProjectFile> PFMap;
typedef PFMap::value_type PFMPair;
typedef PFMap::const_iterator PFMConstIter;

} // namespace Puma

#endif // __project_file__
