/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 16:46:01 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.ComparisonData;
import uk.ac.sanger.artemis.ComparisonDataFactory;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.TextDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class ComparisonDataFactory_ESTest extends ComparisonDataFactory_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("cannot understand the comparison file format/cannot understand the comparison file format/cannot understand the comparison file format0cannot understand the comparison file format");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "z#K6mO0z");
      MockFile mockFile0 = new MockFile("cannot understand the comparison file format", "cannot understand the comparison file format");
      File file0 = MockFile.createTempFile("cannot understand the comparison file format", "cannot understand the comparison file format", (File) mockFile0);
      FileDocument fileDocument0 = new FileDocument(file0);
      try { 
        ComparisonDataFactory.readComparisonData(fileDocument0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading blast -m 8 data: not enough fields in this line: z#K6mO0z
         //
         verifyException("uk.ac.sanger.artemis.BlastM8ComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      // Undeclared exception!
      try { 
        ComparisonDataFactory.readComparisonData((Document) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ComparisonDataFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      MockFile mockFile0 = new MockFile("", "71~MRJ)");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      try { 
        ComparisonDataFactory.readComparisonData(fileDocument0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("cannot understand the comparison file format/cannot understand the comparison file format/cannot understand the comparison file format0cannot understand the comparison file format");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "B]:t34&Uz");
      MockFile mockFile0 = new MockFile("cannot understand the comparison file format", "cannot understand the comparison file format");
      File file0 = MockFile.createTempFile("cannot understand the comparison file format", "cannot understand the comparison file format", (File) mockFile0);
      FileDocument fileDocument0 = new FileDocument(file0);
      try { 
        ComparisonDataFactory.readComparisonData(fileDocument0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // cannot understand the comparison file format
         //
         verifyException("uk.ac.sanger.artemis.ComparisonDataFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      File file0 = MockFile.createTempFile("cnnot underst3nd the cbmparison file format", "cnnot underst3nd the cbmparison file format");
      FileDocument fileDocument0 = new FileDocument(file0);
      try { 
        ComparisonDataFactory.readComparisonData(fileDocument0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // End of file while reading from: org.evosuite.runtime.mock.java.io.MockFile@0000000006
         //
         verifyException("uk.ac.sanger.artemis.ComparisonDataFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/End of file while reading from: 0org.biojava.bio.seq.FeatureFilter$ByPairwiseScore");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "");
      File file0 = MockFile.createTempFile("End of file while reading from: ", "org.biojava.bio.seq.FeatureFilter$ByPairwiseScore");
      FileDocument fileDocument0 = new FileDocument(file0);
      ComparisonData comparisonData0 = ComparisonDataFactory.readComparisonData(fileDocument0);
      assertNotNull(comparisonData0);
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      ComparisonDataFactory comparisonDataFactory0 = new ComparisonDataFactory();
  }
}
