/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:40:13 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultStyledDocument;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.GenericDocument;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.emboss.jemboss.JembossParams;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.time.chrono.MockHijrahDate;
import org.junit.runner.RunWith;
import org.w3c.dom.DOMImplementation;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.circular.Block;
import uk.ac.sanger.artemis.circular.DNADraw;
import uk.ac.sanger.artemis.circular.Track;
import uk.ac.sanger.artemis.circular.TrackManager;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Block_ESTest extends Block_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Track track0 = new Track(0.4, "a9?C>m", "xF$EC", true, true, true, (Entry) null);
      Block block0 = new Block("a9?C>m", 259, 526, (Color) null, 0, track0);
      block0.getStrokeSize();
      assertEquals(526, block0.getBend());
      assertEquals(259, block0.getBstart());
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Track track0 = new Track(0.0, "Apply", "Apply", false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block(" Line width", 0, 0, (Color) null, 0, track0, dNADraw0);
      block0.getColour();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Vector<Canvas> vector0 = new Vector<Canvas>();
      DefaultTableModel defaultTableModel0 = new DefaultTableModel(vector0, 77);
      DefaultTableColumnModel defaultTableColumnModel0 = new DefaultTableColumnModel();
      JTable jTable0 = new JTable(defaultTableModel0, defaultTableColumnModel0);
      Color color0 = jTable0.getSelectionBackground();
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("ND6JR[l'l@m$mzMw1P+");
      Track track0 = new Track(2686.9307F, entry0);
      Block block0 = new Block("ND6JR[l'l@m$mzMw1P+", 77, 0, color0, 2686.9307F, track0);
      Color color1 = block0.getColour();
      assertNotNull(color1);
      assertFalse(block0.isDrawLabel());
      assertEquals(0, block0.getBend());
      assertEquals(77, block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      JEditorPane jEditorPane0 = new JEditorPane("N(W", "N(W");
      Color color0 = jEditorPane0.getCaretColor();
      Block block0 = new Block("N(W", 800, 800, color0, 800, (Track) null);
      int int0 = block0.getBstart();
      assertEquals(800, int0);
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Color color0 = new Color(0, 23, 23, 0);
      Bases bases0 = new Bases((Sequence) null);
      Entry entry0 = Entry.newEntry(bases0);
      Track track0 = new Track((-1726), entry0);
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPrivateServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block(">O$L+^xc*C/l1q%0z", (-1726), (-1726), color0, 0, track0, dNADraw0);
      int int0 = block0.getBstart();
      assertFalse(block0.isDrawLabel());
      assertEquals((-1726), int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Track track0 = new Track(0.0, "Apply", "Apply", false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block(" Line width", 0, 0, (Color) null, 0, track0, dNADraw0);
      block0.getBend();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.info;
      Block block0 = new Block("j}*m", 1569, (-576), systemColor0, (-543.7957F), (Track) null);
      int int0 = block0.getBend();
      assertEquals((-576), int0);
      assertEquals(1569, block0.getBstart());
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.textText;
      Bases bases0 = new Bases((Sequence) null);
      Entry entry0 = Entry.newEntry(bases0);
      Track track0 = new Track(0.8F, "APfq?IbHjJP..*B7", "", true, true, true, entry0);
      Block block0 = new Block("", 1351, 1351, systemColor0, 0.8F, track0);
      // Undeclared exception!
      try { 
        block0.setBlockLocation(0, 1, (TrackManager) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      JList<FileDialog> jList0 = new JList<FileDialog>();
      Color color0 = jList0.getSelectionForeground();
      Block block0 = new Block("", 1035, (-2007), color0, (-2007), (Track) null);
      // Undeclared exception!
      try { 
        block0.isOverMe((-2007), (-2007));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Track track0 = new Track(1328.060571, "nv_a{E`+AFhBbPXT0", true, false, (Entry) null);
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("B/ApDo8(", 0, 1546, (Color) null, 1546, track0, dNADraw0);
      // Undeclared exception!
      try { 
        block0.getTransferData((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.scrollbar;
      Track track0 = new Track(2.0F, "#_$h/u+$G[TsaZ", false, false, (Entry) null);
      Block block0 = new Block("#_$h/u+$G[TsaZ", 1925, 1925, systemColor0, 2.0F, track0);
      // Undeclared exception!
      try { 
        block0.getLinePoints(0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Track track0 = new Track(0.4, "a9?C>m", "xF$EC", true, true, true, (Entry) null);
      Block block0 = new Block("a9?C>m", 259, 526, (Color) null, 0, track0);
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("a9?C>m", "@qAyA]/DHo3!T.x<|", "sk_");
      DOMImplementation dOMImplementation0 = GenericDOMImplementation.getDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, dOMImplementation0);
      SVGGeneratorContext sVGGeneratorContext0 = SVGGeneratorContext.createDefault(genericDocument0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(sVGGeneratorContext0, true);
      // Undeclared exception!
      try { 
        block0.drawLinear(sVGGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Color color0 = Color.LIGHT_GRAY;
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Track track0 = new Track(130, "", false, false, entry0);
      Block block0 = new Block("", 130, 130, color0, 0.5F, track0);
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("", "", "sn)rRs<pTw&[w#v/");
      DOMImplementation dOMImplementation0 = GenericDOMImplementation.getDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, dOMImplementation0);
      SVGGeneratorContext sVGGeneratorContext0 = SVGGeneratorContext.createDefault(genericDocument0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(sVGGeneratorContext0, false);
      // Undeclared exception!
      try { 
        block0.draw(sVGGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Color color0 = Color.blue;
      Track track0 = new Track((-3713.411773178), (Entry) null);
      Block block0 = new Block("", 1198, 1198, color0, (-2134.4F), track0);
      Color color1 = block0.getColour();
      assertNotNull(color1);
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Track track0 = new Track(1328.060571, "nv_a{E`+AFhBbPXT0", true, false, (Entry) null);
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("B/ApDo8(", 0, 1546, (Color) null, 1546, track0, dNADraw0);
      block0.getAngEnd();
      assertFalse(block0.isDrawLabel());
      assertEquals(1546, block0.getBend());
      assertEquals(0, block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      DefaultStyledDocument defaultStyledDocument0 = new DefaultStyledDocument();
      JTextPane jTextPane0 = new JTextPane(defaultStyledDocument0);
      Color color0 = jTextPane0.getCaretColor();
      Block block0 = new Block("uk.ac.sanger.artemis.util.ByteBuffer", 1602, 1602, color0, 1602, (Track) null);
      block0.getBend();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Color color0 = Color.CYAN;
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      Track track0 = new Track((-2636.6067F), entry0);
      Block block0 = new Block("-,DN^~*[_+w>", 0, 0, color0, (-2636.6067F), track0);
      int int0 = block0.getBstart();
      assertEquals(0, int0);
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track((-360.0), (String) null, (String) null, false, false, false, (Entry) null);
      Block block0 = new Block((String) null, 2048, 2048, color0, (-191.7F), track0);
      block0.getTrack();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Color color0 = new Color(0, 23, 23, 0);
      Bases bases0 = new Bases((Sequence) null);
      Entry entry0 = Entry.newEntry(bases0);
      Track track0 = new Track((-1726), entry0);
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPrivateServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block(">O$L+^xc*C/l1q%0z", (-1726), (-1726), color0, 0, track0, dNADraw0);
      block0.getAngStart();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.windowBorder;
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("");
      Track track0 = new Track(3069.0F, "", "", true, false, true, entry0);
      Block block0 = new Block("Please answer y or n", 2172, 2172, systemColor0, 3069.0F, track0);
      block0.getLabel();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      JEditorPane jEditorPane0 = new JEditorPane("N(W", "N(W");
      Color color0 = jEditorPane0.getCaretColor();
      Block block0 = new Block("N(W", 800, 800, color0, 800, (Track) null);
      block0.getStrokeSize();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.menuText;
      Block block0 = new Block("", 1383, 801, systemColor0, 1383, (Track) null);
      Block block1 = (Block)block0.getTransferData(block0.BLOCK);
      assertEquals(801, block1.getBend());
      assertEquals(1383, block1.getBstart());
      assertFalse(block1.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Color color0 = Color.getColor("", 0);
      Track track0 = new Track(1374.4745F, (Entry) null);
      Block block0 = new Block("", 0, 4, color0, 1374.4745F, track0);
      DataFlavor dataFlavor0 = DataFlavor.allHtmlFlavor;
      try { 
        block0.getTransferData(dataFlavor0);
        fail("Expecting exception: UnsupportedFlavorException");
      
      } catch(UnsupportedFlavorException e) {
         //
         // text/html
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Track track0 = new Track(1328.060571, "nv_a{E`+AFhBbPXT0", true, false, (Entry) null);
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("B/ApDo8(", 0, 0, (Color) null, 0, track0, dNADraw0);
      DataFlavor dataFlavor0 = DataFlavor.fragmentHtmlFlavor;
      boolean boolean0 = block0.isDataFlavorSupported(dataFlavor0);
      assertFalse(block0.isDrawLabel());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      Track track0 = new Track(0, "@", "Apply", true, true, false, entry0);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("", 0, 1544, (Color) null, 1544, track0, dNADraw0);
      block0.isOverMe(0, 0);
      assertEquals(0, block0.getBstart());
      assertFalse(block0.isDrawLabel());
      assertEquals(1544, block0.getBend());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Track track0 = new Track(0.0, "Apply", "Apply", false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block(" Line width", 0, 0, (Color) null, 0, track0, dNADraw0);
      Point[] pointArray0 = block0.getLinePoints(65487);
      assertNotNull(pointArray0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Track track0 = new Track(1328.060571, "nv_a{E`+AFhBbPXT0", true, false, (Entry) null);
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("B/ApDo8(", 0, 1546, (Color) null, 1546, track0, dNADraw0);
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("ALIGNMENT", "B/ApDo8(", "nv_a{E`+AFhBbPXT0");
      DOMImplementation dOMImplementation0 = GenericDOMImplementation.getDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, dOMImplementation0);
      SVGGeneratorContext sVGGeneratorContext0 = SVGGeneratorContext.createDefault(genericDocument0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(sVGGeneratorContext0, true);
      block0.draw(sVGGraphics2D0);
      double double0 = block0.getAngEnd();
      assertEquals(-0.0, block0.getAngStart(), 0.01);
      assertEquals((-139.14), double0, 0.01);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Color color0 = Color.blue;
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("File", 2, 2, color0, 0.0F, (Track) null, dNADraw0);
      block0.getFeature();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      JEditorPane jEditorPane0 = new JEditorPane("N(W", "N(W");
      Color color0 = jEditorPane0.getCaretColor();
      Block block0 = new Block("N(W", 800, 800, color0, 800, (Track) null);
      block0.setStrokeSize(800);
      assertFalse(block0.isDrawLabel());
      assertEquals(800.0F, block0.getStrokeSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Track track0 = new Track(0.0, "Apply", "Apply", false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block(" Line width", 0, 0, (Color) null, 0, track0, dNADraw0);
      block0.isArrowHead();
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Track track0 = new Track(0.0, "Apply", "Apply", false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block(" Line width", 0, 0, (Color) null, 0, track0, dNADraw0);
      boolean boolean0 = block0.isDrawLabel();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      DefaultStyledDocument defaultStyledDocument0 = new DefaultStyledDocument();
      JTextPane jTextPane0 = new JTextPane(defaultStyledDocument0);
      Color color0 = jTextPane0.getCaretColor();
      Block block0 = new Block("uk.ac.sanger.artemis.util.ByteBuffer", 1602, 1602, color0, 1602, (Track) null);
      block0.setDrawLabel(false);
      assertEquals(1602.0F, block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      JEditorPane jEditorPane0 = new JEditorPane("N(W", "N(W");
      Color color0 = jEditorPane0.getCaretColor();
      Block block0 = new Block("N(W", 800, 800, color0, 800, (Track) null);
      block0.setArrowHead(false);
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertEquals(800.0F, block0.getStrokeSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.textHighlight;
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("rw", 270, (-5531), systemColor0, (-5531), (Track) null, dNADraw0);
      block0.getTransferDataFlavors();
      assertEquals((-5531), block0.getBend());
      assertEquals(270, block0.getBstart());
      assertEquals((-5531.0F), block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Color color0 = Color.CYAN;
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      Track track0 = new Track((-2636.6067F), entry0);
      Block block0 = new Block("-,DN^~*[_+w>", 0, 0, color0, (-2636.6067F), track0);
      block0.setTrack(track0);
      assertEquals((-2636.6067F), block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.text;
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block(",", (-332), (-332), systemColor0, 4.0F, (Track) null, dNADraw0);
      block0.setFeature((uk.ac.sanger.artemis.Feature) null);
      assertFalse(block0.isDrawLabel());
      assertEquals(4.0F, block0.getStrokeSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Color color0 = Color.green;
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("no existing sequence to annotate for ");
      Track track0 = new Track((-272.0), "no existing sequence to annotate for ", "no existing sequence to annotate for ", false, false, false, entry0);
      Block block0 = new Block("no existing sequence to annotate for ", 3, 3, color0, 3, track0);
      block0.setLabel("");
      assertFalse(block0.isDrawLabel());
      assertEquals(3.0F, block0.getStrokeSize(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Vector<MockHijrahDate> vector0 = new Vector<MockHijrahDate>();
      Color color0 = Color.green;
      Track track0 = new Track((-796.2779F), "", false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("", (-32), (-32), color0, (-796.2779F), track0, dNADraw0);
      assertEquals((-32), block0.getBend());
      assertEquals((-32), block0.getBstart());
      
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("", "", "");
      GenericDOMImplementation genericDOMImplementation0 = new GenericDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, genericDOMImplementation0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(genericDocument0);
      block0.drawLinear(sVGGraphics2D0);
      assertEquals((-796.2779F), block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Color color0 = Color.pink;
      Track track0 = new Track(226, "", false, false, (Entry) null);
      Block block0 = new Block("", 226, 226, color0, 226, track0);
      block0.setColour(color0);
      assertEquals(226.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(226, block0.getBstart());
      assertFalse(block0.isDrawLabel());
      assertEquals(226, block0.getBend());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Color color0 = Color.pink;
      Track track0 = new Track(226, "", false, false, (Entry) null);
      Block block0 = new Block("", 226, 226, color0, 226, track0);
      block0.setBend(120);
      assertEquals(120, block0.getBend());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Color color0 = Color.green;
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("no existing sequence to annotate for ");
      Track track0 = new Track((-272.0), "no existing sequence to annotate for ", "no existing sequence to annotate for ", false, false, false, entry0);
      Block block0 = new Block("no existing sequence to annotate for ", 3, 3, color0, 3, track0);
      block0.setAngEnd(1524.1361511626649);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Color color0 = Color.pink;
      Track track0 = new Track(226, "", false, false, (Entry) null);
      Block block0 = new Block("", 226, 226, color0, 226, track0);
      block0.setAngStart(0.0);
      assertFalse(block0.isDrawLabel());
      assertEquals(226, block0.getBend());
      assertEquals(226.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(226, block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      JEditorPane jEditorPane0 = new JEditorPane("N(W", "N(W");
      Color color0 = jEditorPane0.getCaretColor();
      Block block0 = new Block("N(W", 800, 800, color0, 800, (Track) null);
      block0.isArrowTail();
      assertEquals(800, block0.getBstart());
      assertEquals(800.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(800, block0.getBend());
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      Track track0 = new Track(0.0, "Apply", "Apply", false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block(" Line width", 0, 0, (Color) null, 0, track0, dNADraw0);
      double double0 = block0.getMidAngle();
      assertEquals(0, block0.getBstart());
      assertEquals(0.0, double0, 0.01);
      assertFalse(block0.isDrawLabel());
      assertEquals(0, block0.getBend());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      Color color0 = Color.blue;
      Track track0 = new Track((-3713.411773178), (Entry) null);
      Block block0 = new Block("", 1198, 1198, color0, (-2134.4F), track0);
      block0.setArrowTail(true);
      assertTrue(block0.isArrowTail());
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      DefaultStyledDocument defaultStyledDocument0 = new DefaultStyledDocument();
      JTextPane jTextPane0 = new JTextPane(defaultStyledDocument0);
      Color color0 = jTextPane0.getCaretColor();
      Block block0 = new Block("uk.ac.sanger.artemis.util.ByteBuffer", 1602, 1602, color0, 1602, (Track) null);
      block0.setBstart(1602);
      assertEquals(1602, block0.getBend());
      assertEquals(1602.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(1602, block0.getBstart());
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      Track track0 = new Track(0.0, "Apply", "Apply", false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block(" Line width", 0, 0, (Color) null, 0, track0, dNADraw0);
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("rWWcPGC'\"", " Line width", "Apply");
      DOMImplementation dOMImplementation0 = GenericDOMImplementation.getDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, dOMImplementation0);
      SVGGeneratorContext sVGGeneratorContext0 = SVGGeneratorContext.createDefault(genericDocument0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(sVGGeneratorContext0, false);
      block0.drawCircular(sVGGraphics2D0);
      assertEquals(-0.0, block0.getAngStart(), 0.01);
  }
}
