/* Generated by re2c 3.0 */
/*
  +----------------------------------------------------------------------+
  | Copyright (c) The PHP Group                                          |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | https://www.php.net/license/3_01.txt                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Jakub Zelenka <bukka@php.net>                                |
  +----------------------------------------------------------------------+
*/

#include "php.h"
#include "php_json_scanner.h"
#include "php_json_scanner_defs.h"
#include "php_json_parser.h"
#include "json_parser.tab.h"

#define	YYCTYPE     php_json_ctype
#define	YYCURSOR    s->cursor
#define	YYLIMIT     s->limit
#define	YYMARKER    s->marker
#define	YYCTXMARKER s->ctxmarker

#define YYGETCONDITION()        s->state
#define YYSETCONDITION(yystate) s->state = yystate

#define	YYFILL(n)

#define PHP_JSON_CONDITION_SET(condition) YYSETCONDITION(yyc##condition)
#define PHP_JSON_CONDITION_GOTO(condition) goto yyc_##condition
#define PHP_JSON_CONDITION_SET_AND_GOTO(condition) \
	PHP_JSON_CONDITION_SET(condition); \
	PHP_JSON_CONDITION_GOTO(condition)
#define PHP_JSON_CONDITION_GOTO_STR_P2() \
	do { \
		if (s->utf8_invalid) { \
			PHP_JSON_CONDITION_GOTO(STR_P2_BIN); \
		} else { \
			PHP_JSON_CONDITION_GOTO(STR_P2_UTF); \
		} \
	} while(0)


#define PHP_JSON_SCANNER_COPY_ESC() php_json_scanner_copy_string(s, 0)
#define PHP_JSON_SCANNER_COPY_UTF() php_json_scanner_copy_string(s, 5)
#define PHP_JSON_SCANNER_COPY_UTF_SP() php_json_scanner_copy_string(s, 11)

#define PHP_JSON_INT_MAX_LENGTH (MAX_LENGTH_OF_LONG - 1)


static void php_json_scanner_copy_string(php_json_scanner *s, int esc_size)
{
	size_t len = s->cursor - s->str_start - esc_size - 1;
	if (len) {
		memcpy(s->pstr, s->str_start, len);
		s->pstr += len;
	}
}

static int php_json_hex_to_int(char code)
{
	if (code >= '0' && code <= '9') {
		return code - '0';
	} else if (code >= 'A' && code <= 'F') {
		return code - ('A' - 10);
	} else if (code >= 'a' && code <= 'f') {
		return code - ('a' - 10);
	} else {
		/* this should never happened (just to suppress compiler warning) */
		return -1;
	}
}

static int php_json_ucs2_to_int_ex(php_json_scanner *s, int size, int start)
{
	int i, code = 0;
	php_json_ctype *pc = s->cursor - start;
	for (i = 0; i < size; i++) {
		code |= php_json_hex_to_int(*(pc--)) << (i * 4);
	}
	return code;
}

static int php_json_ucs2_to_int(php_json_scanner *s, int size)
{
	return php_json_ucs2_to_int_ex(s, size, 1);
}

void php_json_scanner_init(php_json_scanner *s, const char *str, size_t str_len, int options)
{
	s->cursor = (php_json_ctype *) str;
	s->limit = (php_json_ctype *) str + str_len;
	s->options = options;
	PHP_JSON_CONDITION_SET(JS);
}

int php_json_scan(php_json_scanner *s)
{
	ZVAL_NULL(&s->value);

std:
	s->token = s->cursor;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_JS;
			} else {
				goto yyc_STR_P1;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_STR_P2_BIN;
			} else {
				goto yyc_STR_P2_UTF;
			}
		}
/* *********************************** */
yyc_JS:
		{
			static const unsigned char yybm[] = {
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,  64,   0,   0,   0,  64,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				 64,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				128, 128, 128, 128, 128, 128, 128, 128, 
				128, 128,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
			};
			yych = *YYCURSOR;
			if (yych <= ']') {
				if (yych <= '"') {
					if (yych <= '\f') {
						if (yych <= 0x08) {
							if (yych >= 0x01) goto yy1;
						} else {
							if (yych <= '\t') goto yy2;
							if (yych <= '\n') goto yy5;
							goto yy1;
						}
					} else {
						if (yych <= 0x1F) {
							if (yych <= '\r') goto yy6;
							goto yy1;
						} else {
							if (yych <= ' ') goto yy2;
							if (yych <= '!') goto yy7;
							goto yy9;
						}
					}
				} else {
					if (yych <= '0') {
						if (yych <= ',') {
							if (yych <= '+') goto yy7;
							goto yy10;
						} else {
							if (yych <= '-') goto yy11;
							if (yych <= '/') goto yy7;
							goto yy12;
						}
					} else {
						if (yych <= 'Z') {
							if (yych <= '9') goto yy14;
							if (yych <= ':') goto yy15;
							goto yy7;
						} else {
							if (yych <= '[') goto yy16;
							if (yych <= '\\') goto yy7;
							goto yy17;
						}
					}
				}
			} else {
				if (yych <= '}') {
					if (yych <= 's') {
						if (yych <= 'f') {
							if (yych <= 'e') goto yy7;
							goto yy18;
						} else {
							if (yych == 'n') goto yy19;
							goto yy7;
						}
					} else {
						if (yych <= 'z') {
							if (yych <= 't') goto yy20;
							goto yy7;
						} else {
							if (yych <= '{') goto yy21;
							if (yych <= '|') goto yy7;
							goto yy22;
						}
					}
				} else {
					if (yych <= 0xEC) {
						if (yych <= 0xC1) {
							if (yych <= 0x7F) goto yy7;
							goto yy23;
						} else {
							if (yych <= 0xDF) goto yy25;
							if (yych <= 0xE0) goto yy26;
							goto yy27;
						}
					} else {
						if (yych <= 0xF0) {
							if (yych <= 0xED) goto yy28;
							if (yych <= 0xEF) goto yy27;
							goto yy29;
						} else {
							if (yych <= 0xF3) goto yy30;
							if (yych <= 0xF4) goto yy31;
							goto yy23;
						}
					}
				}
			}
			++YYCURSOR;
			{
		if (s->limit < s->cursor) {
			return PHP_JSON_T_EOI;
		} else {
			s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
			return PHP_JSON_T_ERROR;
		}
	}
yy1:
			++YYCURSOR;
			{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy2:
			yych = *++YYCURSOR;
yy3:
			if (yybm[0+yych] & 64) {
				goto yy2;
			}
yy4:
			{ goto std; }
yy5:
			++YYCURSOR;
			goto yy4;
yy6:
			yych = *++YYCURSOR;
			if (yych == '\n') goto yy5;
			goto yy3;
yy7:
			++YYCURSOR;
yy8:
			{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy9:
			++YYCURSOR;
			{
		s->str_start = s->cursor;
		s->str_esc = 0;
		s->utf8_invalid = 0;
		s->utf8_invalid_count = 0;
		PHP_JSON_CONDITION_SET_AND_GOTO(STR_P1);
	}
yy10:
			++YYCURSOR;
			{ return ','; }
yy11:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy8;
			if (yych <= '0') goto yy12;
			if (yych <= '9') goto yy14;
			goto yy8;
yy12:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych == '.') goto yy32;
			} else {
				if (yych <= 'E') goto yy34;
				if (yych == 'e') goto yy34;
			}
yy13:
			{
		bool bigint = 0, negative = s->token[0] == '-';
		size_t digits = (size_t) (s->cursor - s->token - negative);
		if (digits >= PHP_JSON_INT_MAX_LENGTH) {
			if (digits == PHP_JSON_INT_MAX_LENGTH) {
				int cmp = strncmp((char *) (s->token + negative), LONG_MIN_DIGITS, PHP_JSON_INT_MAX_LENGTH);
				if (!(cmp < 0 || (cmp == 0 && negative))) {
					bigint = 1;
				}
			} else {
				bigint = 1;
			}
		}
		if (!bigint) {
			ZVAL_LONG(&s->value, ZEND_STRTOL((char *) s->token, NULL, 10));
			return PHP_JSON_T_INT;
		} else if (s->options & PHP_JSON_BIGINT_AS_STRING) {
			ZVAL_STRINGL(&s->value, (char *) s->token, s->cursor - s->token);
			return PHP_JSON_T_STRING;
		} else {
			ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
			return PHP_JSON_T_DOUBLE;
		}
	}
yy14:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yybm[0+yych] & 128) {
				goto yy14;
			}
			if (yych <= 'D') {
				if (yych == '.') goto yy32;
				goto yy13;
			} else {
				if (yych <= 'E') goto yy34;
				if (yych == 'e') goto yy34;
				goto yy13;
			}
yy15:
			++YYCURSOR;
			{ return ':'; }
yy16:
			++YYCURSOR;
			{ return '['; }
yy17:
			++YYCURSOR;
			{ return ']'; }
yy18:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'a') goto yy35;
			goto yy8;
yy19:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'u') goto yy36;
			goto yy8;
yy20:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'r') goto yy37;
			goto yy8;
yy21:
			++YYCURSOR;
			{ return '{'; }
yy22:
			++YYCURSOR;
			{ return '}'; }
yy23:
			++YYCURSOR;
yy24:
			{
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy25:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy24;
			if (yych <= 0xBF) goto yy7;
			goto yy24;
yy26:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x9F) goto yy24;
			if (yych <= 0xBF) goto yy38;
			goto yy24;
yy27:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy24;
			if (yych <= 0xBF) goto yy38;
			goto yy24;
yy28:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy24;
			if (yych <= 0x9F) goto yy38;
			goto yy24;
yy29:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x8F) goto yy24;
			if (yych <= 0xBF) goto yy39;
			goto yy24;
yy30:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy24;
			if (yych <= 0xBF) goto yy39;
			goto yy24;
yy31:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy24;
			if (yych <= 0x8F) goto yy39;
			goto yy24;
yy32:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy33;
			if (yych <= '9') goto yy40;
yy33:
			YYCURSOR = YYMARKER;
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy13;
				} else {
					goto yy8;
				}
			} else {
				if (yyaccept == 2) {
					goto yy24;
				} else {
					goto yy41;
				}
			}
yy34:
			yych = *++YYCURSOR;
			if (yych <= ',') {
				if (yych == '+') goto yy42;
				goto yy33;
			} else {
				if (yych <= '-') goto yy42;
				if (yych <= '/') goto yy33;
				if (yych <= '9') goto yy43;
				goto yy33;
			}
yy35:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy44;
			goto yy33;
yy36:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy45;
			goto yy33;
yy37:
			yych = *++YYCURSOR;
			if (yych == 'u') goto yy46;
			goto yy33;
yy38:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy33;
			if (yych <= 0xBF) goto yy7;
			goto yy33;
yy39:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy33;
			if (yych <= 0xBF) goto yy38;
			goto yy33;
yy40:
			yyaccept = 3;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych <= '/') goto yy41;
				if (yych <= '9') goto yy40;
			} else {
				if (yych <= 'E') goto yy34;
				if (yych == 'e') goto yy34;
			}
yy41:
			{
		ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
		return PHP_JSON_T_DOUBLE;
	}
yy42:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy33;
			if (yych >= ':') goto yy33;
yy43:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy41;
			if (yych <= '9') goto yy43;
			goto yy41;
yy44:
			yych = *++YYCURSOR;
			if (yych == 's') goto yy47;
			goto yy33;
yy45:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy48;
			goto yy33;
yy46:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy49;
			goto yy33;
yy47:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy50;
			goto yy33;
yy48:
			++YYCURSOR;
			{
		ZVAL_NULL(&s->value);
		return PHP_JSON_T_NUL;
	}
yy49:
			++YYCURSOR;
			{
		ZVAL_TRUE(&s->value);
		return PHP_JSON_T_TRUE;
	}
yy50:
			++YYCURSOR;
			{
		ZVAL_FALSE(&s->value);
		return PHP_JSON_T_FALSE;
	}
		}
/* *********************************** */
yyc_STR_P1:
		yych = *YYCURSOR;
		if (yych <= 0xDF) {
			if (yych <= '[') {
				if (yych <= 0x1F) goto yy52;
				if (yych == '"') goto yy54;
				goto yy53;
			} else {
				if (yych <= '\\') goto yy55;
				if (yych <= 0x7F) goto yy53;
				if (yych <= 0xC1) goto yy57;
				goto yy59;
			}
		} else {
			if (yych <= 0xEF) {
				if (yych <= 0xE0) goto yy60;
				if (yych == 0xED) goto yy62;
				goto yy61;
			} else {
				if (yych <= 0xF0) goto yy63;
				if (yych <= 0xF3) goto yy64;
				if (yych <= 0xF4) goto yy65;
				goto yy57;
			}
		}
yy52:
		++YYCURSOR;
		{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy53:
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P1); }
yy54:
		++YYCURSOR;
		{
		zend_string *str;
		size_t len = s->cursor - s->str_start - s->str_esc - 1 + s->utf8_invalid_count;
		if (len == 0) {
			PHP_JSON_CONDITION_SET(JS);
			ZVAL_EMPTY_STRING(&s->value);
			return PHP_JSON_T_ESTRING;
		}
		str = zend_string_alloc(len, 0);
		ZSTR_VAL(str)[len] = '\0';
		ZVAL_STR(&s->value, str);
		if (s->str_esc || s->utf8_invalid) {
			s->pstr = (php_json_ctype *) Z_STRVAL(s->value);
			s->cursor = s->str_start;
			PHP_JSON_CONDITION_GOTO_STR_P2();
		} else {
			memcpy(Z_STRVAL(s->value), s->str_start, len);
			PHP_JSON_CONDITION_SET(JS);
			return PHP_JSON_T_STRING;
		}
	}
yy55:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'e') {
			if (yych <= '/') {
				if (yych == '"') goto yy66;
				if (yych >= '/') goto yy66;
			} else {
				if (yych <= '\\') {
					if (yych >= '\\') goto yy66;
				} else {
					if (yych == 'b') goto yy66;
				}
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy66;
				if (yych == 'n') goto yy66;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy66;
				} else {
					if (yych <= 't') goto yy66;
					if (yych <= 'u') goto yy67;
				}
			}
		}
yy56:
		{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy57:
		++YYCURSOR;
yy58:
		{
		if (s->options & (PHP_JSON_INVALID_UTF8_IGNORE | PHP_JSON_INVALID_UTF8_SUBSTITUTE)) {
			if (s->options & PHP_JSON_INVALID_UTF8_SUBSTITUTE) {
				if (s->utf8_invalid_count > INT_MAX - 2) {
					s->errcode = PHP_JSON_ERROR_UTF8;
					return PHP_JSON_T_ERROR;
				}
				s->utf8_invalid_count += 2;
			} else {
				s->utf8_invalid_count--;
			}
			s->utf8_invalid = 1;
			PHP_JSON_CONDITION_GOTO(STR_P1);
		}
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy59:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy58;
		if (yych <= 0xBF) goto yy53;
		goto yy58;
yy60:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x9F) goto yy58;
		if (yych <= 0xBF) goto yy69;
		goto yy58;
yy61:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy58;
		if (yych <= 0xBF) goto yy69;
		goto yy58;
yy62:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy58;
		if (yych <= 0x9F) goto yy69;
		goto yy58;
yy63:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x8F) goto yy58;
		if (yych <= 0xBF) goto yy70;
		goto yy58;
yy64:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy58;
		if (yych <= 0xBF) goto yy70;
		goto yy58;
yy65:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy58;
		if (yych <= 0x8F) goto yy70;
		goto yy58;
yy66:
		++YYCURSOR;
		{
		s->str_esc++;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy67:
		yych = *++YYCURSOR;
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych <= '/') goto yy68;
				if (yych <= '0') goto yy71;
				goto yy72;
			} else {
				if (yych <= '@') goto yy68;
				if (yych <= 'C') goto yy72;
				goto yy73;
			}
		} else {
			if (yych <= 'c') {
				if (yych <= 'F') goto yy72;
				if (yych >= 'a') goto yy72;
			} else {
				if (yych <= 'd') goto yy73;
				if (yych <= 'f') goto yy72;
			}
		}
yy68:
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy56;
			} else {
				goto yy58;
			}
		} else {
			goto yy88;
		}
yy69:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy68;
		if (yych <= 0xBF) goto yy53;
		goto yy68;
yy70:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy68;
		if (yych <= 0xBF) goto yy69;
		goto yy68;
yy71:
		yych = *++YYCURSOR;
		if (yych <= '9') {
			if (yych <= '/') goto yy68;
			if (yych <= '0') goto yy74;
			if (yych <= '7') goto yy75;
			goto yy76;
		} else {
			if (yych <= 'F') {
				if (yych <= '@') goto yy68;
				goto yy76;
			} else {
				if (yych <= '`') goto yy68;
				if (yych <= 'f') goto yy76;
				goto yy68;
			}
		}
yy72:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy76;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy76;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy76;
			goto yy68;
		}
yy73:
		yych = *++YYCURSOR;
		if (yych <= 'B') {
			if (yych <= '7') {
				if (yych <= '/') goto yy68;
				goto yy76;
			} else {
				if (yych <= '9') goto yy77;
				if (yych <= '@') goto yy68;
				goto yy77;
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'F') goto yy78;
				goto yy68;
			} else {
				if (yych <= 'b') goto yy77;
				if (yych <= 'f') goto yy78;
				goto yy68;
			}
		}
yy74:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '7') goto yy79;
			if (yych <= '9') goto yy80;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy80;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy80;
			goto yy68;
		}
yy75:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy80;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy80;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy80;
			goto yy68;
		}
yy76:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy81;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy81;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy81;
			goto yy68;
		}
yy77:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy82;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy82;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy82;
			goto yy68;
		}
yy78:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy83;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy83;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy83;
			goto yy68;
		}
yy79:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy84;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy84;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy84;
			goto yy68;
		}
yy80:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy85;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy85;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy85;
			goto yy68;
		}
yy81:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy86;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy86;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy86;
			goto yy68;
		}
yy82:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy87;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy87;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy87;
			goto yy68;
		}
yy83:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych <= '9') goto yy89;
			goto yy68;
		} else {
			if (yych <= 'F') goto yy89;
			if (yych <= '`') goto yy68;
			if (yych <= 'f') goto yy89;
			goto yy68;
		}
yy84:
		++YYCURSOR;
		{
		s->str_esc += 5;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy85:
		++YYCURSOR;
		{
		s->str_esc += 4;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy86:
		++YYCURSOR;
		{
		s->str_esc += 3;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy87:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '\\') goto yy90;
yy88:
		{
		s->errcode = PHP_JSON_ERROR_UTF16;
		return PHP_JSON_T_ERROR;
	}
yy89:
		++YYCURSOR;
		goto yy88;
yy90:
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy68;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy91;
		if (yych != 'd') goto yy68;
yy91:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy68;
		if (yych <= 'F') goto yy92;
		if (yych <= 'b') goto yy68;
		if (yych >= 'g') goto yy68;
yy92:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych >= ':') goto yy68;
		} else {
			if (yych <= 'F') goto yy93;
			if (yych <= '`') goto yy68;
			if (yych >= 'g') goto yy68;
		}
yy93:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy68;
			if (yych >= ':') goto yy68;
		} else {
			if (yych <= 'F') goto yy94;
			if (yych <= '`') goto yy68;
			if (yych >= 'g') goto yy68;
		}
yy94:
		++YYCURSOR;
		{
		s->str_esc += 8;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
/* *********************************** */
yyc_STR_P2_BIN:
		yych = *YYCURSOR;
		if (yych <= 0xDF) {
			if (yych <= '[') {
				if (yych == '"') goto yy97;
			} else {
				if (yych <= '\\') goto yy98;
				if (yych <= 0x7F) goto yy96;
				if (yych <= 0xC1) goto yy100;
				goto yy102;
			}
		} else {
			if (yych <= 0xEF) {
				if (yych <= 0xE0) goto yy103;
				if (yych == 0xED) goto yy105;
				goto yy104;
			} else {
				if (yych <= 0xF0) goto yy106;
				if (yych <= 0xF3) goto yy107;
				if (yych <= 0xF4) goto yy108;
				goto yy100;
			}
		}
yy96:
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P2_BIN); }
yy97:
		++YYCURSOR;
		YYSETCONDITION(yycJS);
		{
		PHP_JSON_SCANNER_COPY_ESC();
		return PHP_JSON_T_STRING;
	}
yy98:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'u') goto yy109;
yy99:
		{
		char esc;
		PHP_JSON_SCANNER_COPY_ESC();
		switch (*s->cursor) {
			case 'b':
				esc = '\b';
				break;
			case 'f':
				esc = '\f';				break;
			case 'n':
				esc = '\n';
				break;
			case 'r':
				esc = '\r';
				break;
			case 't':
				esc = '\t';
				break;
			case '\\':
			case '/':
			case '"':
				esc = *s->cursor;
				break;
			default:
				s->errcode = PHP_JSON_ERROR_SYNTAX;
				return PHP_JSON_T_ERROR;
		}
		*(s->pstr++) = esc;
		++YYCURSOR;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy100:
		++YYCURSOR;
yy101:
		{
		if (s->utf8_invalid) {
			PHP_JSON_SCANNER_COPY_ESC();
			if (s->options & PHP_JSON_INVALID_UTF8_SUBSTITUTE) {
				*(s->pstr++) = (char) (0xe0 | (0xfffd >> 12));
				*(s->pstr++) = (char) (0x80 | ((0xfffd >> 6) & 0x3f));
				*(s->pstr++) = (char) (0x80 | (0xfffd & 0x3f));
			}
			s->str_start = s->cursor;
		}
		PHP_JSON_CONDITION_GOTO(STR_P2_BIN);
	}
yy102:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy101;
		if (yych <= 0xBF) goto yy96;
		goto yy101;
yy103:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x9F) goto yy101;
		if (yych <= 0xBF) goto yy111;
		goto yy101;
yy104:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy101;
		if (yych <= 0xBF) goto yy111;
		goto yy101;
yy105:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy101;
		if (yych <= 0x9F) goto yy111;
		goto yy101;
yy106:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x8F) goto yy101;
		if (yych <= 0xBF) goto yy112;
		goto yy101;
yy107:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy101;
		if (yych <= 0xBF) goto yy112;
		goto yy101;
yy108:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy101;
		if (yych <= 0x8F) goto yy112;
		goto yy101;
yy109:
		yych = *++YYCURSOR;
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych <= '/') goto yy110;
				if (yych <= '0') goto yy113;
				goto yy114;
			} else {
				if (yych <= '@') goto yy110;
				if (yych <= 'C') goto yy114;
				goto yy115;
			}
		} else {
			if (yych <= 'c') {
				if (yych <= 'F') goto yy114;
				if (yych >= 'a') goto yy114;
			} else {
				if (yych <= 'd') goto yy115;
				if (yych <= 'f') goto yy114;
			}
		}
yy110:
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy99;
		} else {
			goto yy101;
		}
yy111:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy110;
		if (yych <= 0xBF) goto yy96;
		goto yy110;
yy112:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy110;
		if (yych <= 0xBF) goto yy111;
		goto yy110;
yy113:
		yych = *++YYCURSOR;
		if (yych <= '9') {
			if (yych <= '/') goto yy110;
			if (yych <= '0') goto yy116;
			if (yych <= '7') goto yy117;
			goto yy118;
		} else {
			if (yych <= 'F') {
				if (yych <= '@') goto yy110;
				goto yy118;
			} else {
				if (yych <= '`') goto yy110;
				if (yych <= 'f') goto yy118;
				goto yy110;
			}
		}
yy114:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '9') goto yy118;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy118;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy118;
			goto yy110;
		}
yy115:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '7') goto yy118;
			if (yych <= '9') goto yy119;
			goto yy110;
		} else {
			if (yych <= 'B') goto yy119;
			if (yych <= '`') goto yy110;
			if (yych <= 'b') goto yy119;
			goto yy110;
		}
yy116:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '7') goto yy120;
			if (yych <= '9') goto yy121;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy121;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy121;
			goto yy110;
		}
yy117:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '9') goto yy121;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy121;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy121;
			goto yy110;
		}
yy118:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '9') goto yy122;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy122;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy122;
			goto yy110;
		}
yy119:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '9') goto yy123;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy123;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy123;
			goto yy110;
		}
yy120:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '9') goto yy124;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy124;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy124;
			goto yy110;
		}
yy121:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '9') goto yy125;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy125;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy125;
			goto yy110;
		}
yy122:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '9') goto yy126;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy126;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy126;
			goto yy110;
		}
yy123:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych <= '9') goto yy127;
			goto yy110;
		} else {
			if (yych <= 'F') goto yy127;
			if (yych <= '`') goto yy110;
			if (yych <= 'f') goto yy127;
			goto yy110;
		}
yy124:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 2);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) utf16;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy125:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 3);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xc0 | (utf16 >> 6));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy126:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 4);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xe0 | (utf16 >> 12));
		*(s->pstr++) = (char) (0x80 | ((utf16 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy127:
		yych = *++YYCURSOR;
		if (yych != '\\') goto yy110;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy110;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy128;
		if (yych != 'd') goto yy110;
yy128:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy110;
		if (yych <= 'F') goto yy129;
		if (yych <= 'b') goto yy110;
		if (yych >= 'g') goto yy110;
yy129:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych >= ':') goto yy110;
		} else {
			if (yych <= 'F') goto yy130;
			if (yych <= '`') goto yy110;
			if (yych >= 'g') goto yy110;
		}
yy130:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy110;
			if (yych >= ':') goto yy110;
		} else {
			if (yych <= 'F') goto yy131;
			if (yych <= '`') goto yy110;
			if (yych >= 'g') goto yy110;
		}
yy131:
		++YYCURSOR;
		{
		int utf32, utf16_hi, utf16_lo;
		utf16_hi = php_json_ucs2_to_int(s, 4);
		utf16_lo = php_json_ucs2_to_int_ex(s, 4, 7);
		utf32 = ((utf16_lo & 0x3FF) << 10) + (utf16_hi & 0x3FF) + 0x10000;
		PHP_JSON_SCANNER_COPY_UTF_SP();
		*(s->pstr++) = (char) (0xf0 | (utf32 >> 18));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 12) & 0x3f));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf32 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
/* *********************************** */
yyc_STR_P2_UTF:
		yych = *YYCURSOR;
		if (yych == '"') goto yy133;
		if (yych == '\\') goto yy134;
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P2_UTF); }
yy133:
		++YYCURSOR;
		YYSETCONDITION(yycJS);
		{
		PHP_JSON_SCANNER_COPY_ESC();
		return PHP_JSON_T_STRING;
	}
yy134:
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'u') goto yy136;
yy135:
		{
		char esc;
		PHP_JSON_SCANNER_COPY_ESC();
		switch (*s->cursor) {
			case 'b':
				esc = '\b';
				break;
			case 'f':
				esc = '\f';				break;
			case 'n':
				esc = '\n';
				break;
			case 'r':
				esc = '\r';
				break;
			case 't':
				esc = '\t';
				break;
			case '\\':
			case '/':
			case '"':
				esc = *s->cursor;
				break;
			default:
				s->errcode = PHP_JSON_ERROR_SYNTAX;
				return PHP_JSON_T_ERROR;
		}
		*(s->pstr++) = esc;
		++YYCURSOR;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy136:
		yych = *++YYCURSOR;
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych <= '/') goto yy137;
				if (yych <= '0') goto yy138;
				goto yy139;
			} else {
				if (yych <= '@') goto yy137;
				if (yych <= 'C') goto yy139;
				goto yy140;
			}
		} else {
			if (yych <= 'c') {
				if (yych <= 'F') goto yy139;
				if (yych >= 'a') goto yy139;
			} else {
				if (yych <= 'd') goto yy140;
				if (yych <= 'f') goto yy139;
			}
		}
yy137:
		YYCURSOR = YYMARKER;
		goto yy135;
yy138:
		yych = *++YYCURSOR;
		if (yych <= '9') {
			if (yych <= '/') goto yy137;
			if (yych <= '0') goto yy141;
			if (yych <= '7') goto yy142;
			goto yy143;
		} else {
			if (yych <= 'F') {
				if (yych <= '@') goto yy137;
				goto yy143;
			} else {
				if (yych <= '`') goto yy137;
				if (yych <= 'f') goto yy143;
				goto yy137;
			}
		}
yy139:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '9') goto yy143;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy143;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy143;
			goto yy137;
		}
yy140:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '7') goto yy143;
			if (yych <= '9') goto yy144;
			goto yy137;
		} else {
			if (yych <= 'B') goto yy144;
			if (yych <= '`') goto yy137;
			if (yych <= 'b') goto yy144;
			goto yy137;
		}
yy141:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '7') goto yy145;
			if (yych <= '9') goto yy146;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy146;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy146;
			goto yy137;
		}
yy142:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '9') goto yy146;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy146;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy146;
			goto yy137;
		}
yy143:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '9') goto yy147;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy147;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy147;
			goto yy137;
		}
yy144:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '9') goto yy148;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy148;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy148;
			goto yy137;
		}
yy145:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '9') goto yy149;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy149;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy149;
			goto yy137;
		}
yy146:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '9') goto yy150;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy150;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy150;
			goto yy137;
		}
yy147:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '9') goto yy151;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy151;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy151;
			goto yy137;
		}
yy148:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych <= '9') goto yy152;
			goto yy137;
		} else {
			if (yych <= 'F') goto yy152;
			if (yych <= '`') goto yy137;
			if (yych <= 'f') goto yy152;
			goto yy137;
		}
yy149:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 2);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) utf16;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy150:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 3);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xc0 | (utf16 >> 6));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy151:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 4);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xe0 | (utf16 >> 12));
		*(s->pstr++) = (char) (0x80 | ((utf16 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy152:
		yych = *++YYCURSOR;
		if (yych != '\\') goto yy137;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy137;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy153;
		if (yych != 'd') goto yy137;
yy153:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy137;
		if (yych <= 'F') goto yy154;
		if (yych <= 'b') goto yy137;
		if (yych >= 'g') goto yy137;
yy154:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych >= ':') goto yy137;
		} else {
			if (yych <= 'F') goto yy155;
			if (yych <= '`') goto yy137;
			if (yych >= 'g') goto yy137;
		}
yy155:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy137;
			if (yych >= ':') goto yy137;
		} else {
			if (yych <= 'F') goto yy156;
			if (yych <= '`') goto yy137;
			if (yych >= 'g') goto yy137;
		}
yy156:
		++YYCURSOR;
		{
		int utf32, utf16_hi, utf16_lo;
		utf16_hi = php_json_ucs2_to_int(s, 4);
		utf16_lo = php_json_ucs2_to_int_ex(s, 4, 7);
		utf32 = ((utf16_lo & 0x3FF) << 10) + (utf16_hi & 0x3FF) + 0x10000;
		PHP_JSON_SCANNER_COPY_UTF_SP();
		*(s->pstr++) = (char) (0xf0 | (utf32 >> 18));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 12) & 0x3f));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf32 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
	}


}
