#
# Description: CDBS class for Lua related packages
#
# Copyright © 2009 Enrico Tassi <gareuselesinge@debian.org>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 51
# Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class
_ocaml_share_path ?= /usr/share/ocaml

ifndef _cdbs_class_lua
_cdbs_class_lua = 1

include $(_cdbs_class_path)/makefile.mk
include $(_cdbs_rules_path)/debhelper.mk

DEB_DESTDIR=$(shell pwd)/debian/tmp
LUA_POLICY_PATH           := /usr/share/lua5.1-policy-dev/
LUA_POLICY_MAKEFILE       := $(LUA_POLICY_PATH)/Makefile.Debian.multiple
DEB_MAKE_BUILD_TARGET     := all     -f $(LUA_POLICY_MAKEFILE) 
DEB_MAKE_CHECK_TARGET     := test    -f $(LUA_POLICY_MAKEFILE) 
DEB_MAKE_CLEAN_TARGET     := clean   -f $(LUA_POLICY_MAKEFILE) 
DEB_MAKE_INSTALL_TARGET   := install -f $(LUA_POLICY_MAKEFILE)  DESTDIR=$(DEB_DESTDIR)
DEB_DH_INSTALL_SOURCEDIR  := $(DEB_DESTDIR)

endif
