<?php
/////////////////////////////////////////
// File Name : Validate_Condition.php
// Creation Date : July 2007
// Description : This creates a table of all the valid according to the Conditions
//
// Modifications : -
//
/////////////////////////////////////////////////////////////////////////

	include_once "functions/getNodeFullPath.php";

	$tree = $_SESSION['tree'];
	$conform_cond = array();
	$valid_nodes = array();
	validate_condition( 0 );
	$_SESSION['valid_nodes'] = $valid_nodes;

	function validate_condition( $node_id ){
		global $tree, $valid_nodes;
		$node = $tree[ $node_id ];
		if( $node->is_checked() && validate( $node ) ){
			$valid_nodes[] = getNodeFullPath( $node )."/".$node->toString();
		}
		$childs = $node->returnChild( $tree );
		foreach( $childs as $child ){
			validate_condition( $child );
		}
	}

	// This fonctions Compares the Node's Value with the Condition's Value with El Comparator chosen at the Condition_Chooser Screen
	// the default is "="
	function compareConditions( $comparator, $valueNode, $valueCond ){
		$retour = false;
		switch ($comparator){
		case "!=" :
			$retour = $valueNode != $valueCond;
			break;
		case "<" :
			$retour = $valueNode < $valueCond;
			break;
		case "<=" :
			$retour = $valueNode <= $valueCond;
			break;		
		case ">" :
			$retour = $valueNode > $valueCond;
			break;
		case ">=" :
			$retour = $valueNode >= $valueCond;
			break;
		default :
			$retour = $valueNode == $valueCond;
			break;
		}
		return $retour;				
	}
	
	function validate( $node ){
		$conditions = $_SESSION['conditions'];
		global $conform_cond;
		$nb_condition_valid = 0;
		foreach( $conditions as $condition ){
		// All conditions must be true but some values in a condition can be true
		// Condition => 	Logical AND
		// Value 	=> 	Logical OR
			$value_valid = false;
			if( !isset( $conform_cond[ $condition->name ] ) ){
				$conform_cond[ $condition->name ] = array();
			}
			for( $i = 0; $i < count( $condition->value ); $i++ ){
				$value = $condition->value[$i];
				switch ($condition->category){
				case 0 :
					$sql = "Select attributes.value From attributesdef, attributes Where attributesdef.name = '".$condition->name."' AND attributes.Nodes_ID = '".$node->id."' AND attributesdef.ID = attributes.AttributesDef_ID";
					break;
				case 1 :
					$sql = "Select HwValue From computershw Where HwKey = '".$condition->name."' AND Nodes_ID = '".$node->id."'";
					break;
				case 2 :
					$sql = "Select ".$condition->name." From status Where id = '".$node->id."'";
					break;
				}
				$query = pg_query( $sql );

				// If the query returns any information, look if it's valid
				if( pg_num_rows( $query ) > 0 ){
					$row = pg_fetch_row( $query );
					if( compareConditions( $condition->comparator[$i], $row[0], $value ) ){
						$value_valid = true;
						$conform_cond[ $condition->name ][] = $node->id;
					}
				// Else, if we're using Heritage, look at the parent to know if the child is valid
				} else {
					if( in_array( $node->id_parent, $conform_cond[ $condition->name ] ) && $_SESSION['useHeritage'] ){
						$value_valid = true;
						$conform_cond[ $condition->name ][] = $node->id;
					}
				}
			} // Each values
			if( $value_valid ){
				$nb_condition_valid++;
			}
		} // Each conditions
		if( $nb_condition_valid == count( $conditions ) ){
			$is_valid = true;
		} else {
			$is_valid = false;
		}
		return $is_valid;
	}
?>