/* PR rtl-optimization/68910 */
/* Reported by Sebastian Huber <sebastian.huber@embedded-brains.de> */

/* { dg-do compile } */
/* { dg-require-effective-target ilp32 } */
/* { dg-options "-O2 -mtune=supersparc" } */

typedef unsigned int size_t;
typedef long long unsigned int uint64_t;

extern void *memcpy (void *, const void *, size_t);

void
SHA512_Transform(uint64_t * state, const unsigned char block[128])
{
  uint64_t W[80];
  uint64_t S[8];
  uint64_t t0, t1;
  int i;

  memcpy ((void *)W, (const void *)block, (size_t)128);

  for (i = 16; i < 80; i++)
    W[i] = (((W[i - 2] >> 19) | (W[i - 2] << (64 - 19))) ^ ((W[i - 2] >> 61) | (W[i - 2] << (64 - 61))) ^ (W[i - 2] >> 6)) + W[i - 7] + (((W[i - 15] >> 1) | (W[i - 15] << (64 - 1))) ^ ((W[i - 15] >> 8) | (W[i - 15] << (64 - 8))) ^ (W[i - 15] >> 7)) + W[i - 16];

  memcpy (S, state, 64);

  t0 = S[(87 - 0) % 8] + (((S[(84 - 0) % 8] >> 14) | (S[(84 - 0) % 8] << (64 - 14))) ^ ((S[(84 - 0) % 8] >> 18) | (S[(84 - 0) % 8] << (64 - 18))) ^ ((S[(84 - 0) % 8] >> 41) | (S[(84 - 0) % 8] << (64 - 41)))) + ((S[(84 - 0) % 8] & (S[(85 - 0) % 8] ^ S[(86 - 0) % 8])) ^ S[(86 - 0) % 8]) + W[0] + 0x428a2f98d728ae22ULL; t1 = (((S[(80 - 0) % 8] >> 28) | (S[(80 - 0) % 8] << (64 - 28))) ^ ((S[(80 - 0) % 8] >> 34) | (S[(80 - 0) % 8] << (64 - 34))) ^ ((S[(80 - 0) % 8] >> 39) | (S[(80 - 0) % 8] << (64 - 39)))) + ((S[(80 - 0) % 8] & (S[(81 - 0) % 8] | S[(82 - 0) % 8])) | (S[(81 - 0) % 8] & S[(82 - 0) % 8])); S[(83 - 0) % 8] += t0; S[(87 - 0) % 8] = t0 + t1;

  t0 = S[(87 - 1) % 8] + (((S[(84 - 1) % 8] >> 14) | (S[(84 - 1) % 8] << (64 - 14))) ^ ((S[(84 - 1) % 8] >> 18) | (S[(84 - 1) % 8] << (64 - 18))) ^ ((S[(84 - 1) % 8] >> 41) | (S[(84 - 1) % 8] << (64 - 41)))) + ((S[(84 - 1) % 8] & (S[(85 - 1) % 8] ^ S[(86 - 1) % 8])) ^ S[(86 - 1) % 8]) + W[1] + 0x7137449123ef65cdULL; t1 = (((S[(80 - 1) % 8] >> 28) | (S[(80 - 1) % 8] << (64 - 28))) ^ ((S[(80 - 1) % 8] >> 34) | (S[(80 - 1) % 8] << (64 - 34))) ^ ((S[(80 - 1) % 8] >> 39) | (S[(80 - 1) % 8] << (64 - 39)))) + ((S[(80 - 1) % 8] & (S[(81 - 1) % 8] | S[(82 - 1) % 8])) | (S[(81 - 1) % 8] & S[(82 - 1) % 8])); S[(83 - 1) % 8] += t0; S[(87 - 1) % 8] = t0 + t1;

  t0 = S[(87 - 2) % 8] + (((S[(84 - 2) % 8] >> 14) | (S[(84 - 2) % 8] << (64 - 14))) ^ ((S[(84 - 2) % 8] >> 18) | (S[(84 - 2) % 8] << (64 - 18))) ^ ((S[(84 - 2) % 8] >> 41) | (S[(84 - 2) % 8] << (64 - 41)))) + ((S[(84 - 2) % 8] & (S[(85 - 2) % 8] ^ S[(86 - 2) % 8])) ^ S[(86 - 2) % 8]) + W[2] + 0xb5c0fbcfec4d3b2fULL; t1 = (((S[(80 - 2) % 8] >> 28) | (S[(80 - 2) % 8] << (64 - 28))) ^ ((S[(80 - 2) % 8] >> 34) | (S[(80 - 2) % 8] << (64 - 34))) ^ ((S[(80 - 2) % 8] >> 39) | (S[(80 - 2) % 8] << (64 - 39)))) + ((S[(80 - 2) % 8] & (S[(81 - 2) % 8] | S[(82 - 2) % 8])) | (S[(81 - 2) % 8] & S[(82 - 2) % 8])); S[(83 - 2) % 8] += t0; S[(87 - 2) % 8] = t0 + t1;

  t0 = S[(87 - 3) % 8] + (((S[(84 - 3) % 8] >> 14) | (S[(84 - 3) % 8] << (64 - 14))) ^ ((S[(84 - 3) % 8] >> 18) | (S[(84 - 3) % 8] << (64 - 18))) ^ ((S[(84 - 3) % 8] >> 41) | (S[(84 - 3) % 8] << (64 - 41)))) + ((S[(84 - 3) % 8] & (S[(85 - 3) % 8] ^ S[(86 - 3) % 8])) ^ S[(86 - 3) % 8]) + W[3] + 0xe9b5dba58189dbbcULL; t1 = (((S[(80 - 3) % 8] >> 28) | (S[(80 - 3) % 8] << (64 - 28))) ^ ((S[(80 - 3) % 8] >> 34) | (S[(80 - 3) % 8] << (64 - 34))) ^ ((S[(80 - 3) % 8] >> 39) | (S[(80 - 3) % 8] << (64 - 39)))) + ((S[(80 - 3) % 8] & (S[(81 - 3) % 8] | S[(82 - 3) % 8])) | (S[(81 - 3) % 8] & S[(82 - 3) % 8])); S[(83 - 3) % 8] += t0; S[(87 - 3) % 8] = t0 + t1;

  for (i = 0; i < 8; i++)
    state[i] += S[i];
}

/* { dg-final { scan-assembler-not "stx\t%" } } */
